/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.Dimension;
import java.util.Arrays;
import net.refractions.udig.catalog.internal.wmt.WMTPlugin;
import net.refractions.udig.catalog.internal.wmt.WMTRenderJob;
import net.refractions.udig.catalog.internal.wmt.tile.WMTTile;
import net.refractions.udig.catalog.internal.wmt.wmtsource.WMTSource;
import net.refractions.udig.project.internal.render.impl.ScaleUtils;
import org.eclipse.swt.widgets.Display;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class WMTScaleZoomLevelMatcher {
    private CoordinateReferenceSystem crsMap;
    private CoordinateReferenceSystem crsTiles;
    private MathTransform transformMapToTileCrs;
    private MathTransform transformTileCrsToMap;
    private ReferencedEnvelope mapExtentTileCrs;
    private ReferencedEnvelope mapExtentMapCrs;
    private double scale;
    private static int DPI;

    static {
        try {
            DPI = Display.getDefault().getDPI().x;
        }
        catch (Exception exception) {
            DPI = 96;
        }
    }

    public WMTScaleZoomLevelMatcher(CoordinateReferenceSystem crsMap, CoordinateReferenceSystem crsTiles, MathTransform transformMapToTileCrs, MathTransform transformTileCrsToMap, ReferencedEnvelope mapExtentTileCrs, ReferencedEnvelope mapExtentMapCrs, double scale) {
        this.crsMap = crsMap;
        this.crsTiles = crsTiles;
        this.transformMapToTileCrs = transformMapToTileCrs;
        this.transformTileCrsToMap = transformTileCrsToMap;
        this.mapExtentTileCrs = mapExtentTileCrs;
        this.mapExtentMapCrs = mapExtentMapCrs;
        this.scale = scale;
    }

    public static WMTScaleZoomLevelMatcher createMatcher(ReferencedEnvelope mapExtentMapCrs, double scale, WMTSource wmtSource) throws Exception {
        CoordinateReferenceSystem crsMap = mapExtentMapCrs.getCoordinateReferenceSystem();
        CoordinateReferenceSystem crsTiles = wmtSource.getTileCrs();
        MathTransform transformMapToTileCrs = WMTRenderJob.getTransformation(crsMap, crsTiles);
        MathTransform transformTileCrsToMap = WMTRenderJob.getTransformation(crsTiles, crsMap);
        ReferencedEnvelope mapExtentTileCrs = WMTRenderJob.getProjectedEnvelope(mapExtentMapCrs, crsTiles, transformMapToTileCrs);
        return new WMTScaleZoomLevelMatcher(crsMap, crsTiles, transformMapToTileCrs, transformTileCrsToMap, mapExtentTileCrs, mapExtentMapCrs, scale);
    }

    public CoordinateReferenceSystem getCrsMap() {
        return this.crsMap;
    }

    public CoordinateReferenceSystem getCrsTiles() {
        return this.crsTiles;
    }

    public ReferencedEnvelope getMapExtentTileCrs() {
        return this.mapExtentTileCrs;
    }

    public double getScale() {
        return this.scale;
    }

    public int getZoomLevelFromScale(WMTSource wmtSource, double[] tempScaleList) {
        double[] scaleList = wmtSource.getScaleList();
        int zoomLevel = scaleList.length - 1;
        this.getOptimumScaleFromZoomLevel(zoomLevel, wmtSource, tempScaleList);
        int i = scaleList.length - 2;
        while (i >= 0) {
            if (Double.isNaN(scaleList[i]) || this.getScale() < this.getOptimumScaleFromZoomLevel(i, wmtSource, tempScaleList)) break;
            zoomLevel = i;
            if (this.getScale() > this.getOptimumScaleFromZoomLevel(i + 1, wmtSource, tempScaleList)) {
                zoomLevel = i;
            }
            --i;
        }
        return zoomLevel;
    }

    public double getOptimumScaleFromZoomLevel(int zoomLevel, WMTSource wmtSource, double[] tempScaleList) {
        if (!Double.isNaN(tempScaleList[zoomLevel])) {
            return tempScaleList[zoomLevel];
        }
        try {
            double scale;
            ReferencedEnvelope centerTileBounds = this.getBoundsOfCenterTileInMapCrs(zoomLevel, wmtSource);
            tempScaleList[zoomLevel] = scale = ScaleUtils.calculateScaleDenominator((ReferencedEnvelope)centerTileBounds, (Dimension)new Dimension(wmtSource.getTileWidth(), wmtSource.getTileHeight()), (int)DPI);
            return scale;
        }
        catch (Exception exc) {
            WMTPlugin.trace("[WMTRenderJob.getOptimumScaleFromZoomLevel] Failed for: " + zoomLevel, exc);
            return wmtSource.getScaleList()[zoomLevel];
        }
    }

    public double getOptimumScaleFromZoomLevel(int zoomLevel, WMTSource wmtSource) {
        double[] tempScaleList = new double[wmtSource.getScaleList().length];
        Arrays.fill(tempScaleList, Double.NaN);
        return this.getOptimumScaleFromZoomLevel(zoomLevel, wmtSource, tempScaleList);
    }

    private ReferencedEnvelope getBoundsOfCenterTileInMapCrs(int zoomLevel, WMTSource wmtSource) throws Exception {
        WMTTile centerTile = this.getCenterTile(zoomLevel, wmtSource);
        ReferencedEnvelope boundsInTileCrs = centerTile.getExtent();
        ReferencedEnvelope boundsInMapCrs = this.projectTileToMapCrs(boundsInTileCrs);
        return boundsInMapCrs;
    }

    private WMTTile getCenterTile(int zoomLevel, WMTSource wmtSource) {
        WMTTile.WMTTileFactory tileFactory = wmtSource.getTileFactory();
        WMTTile.WMTZoomLevel zoomLevelInstance = tileFactory.getZoomLevel(zoomLevel, wmtSource);
        Coordinate centerPoint = this.mapExtentTileCrs.centre();
        return tileFactory.getTileFromCoordinate(centerPoint.y, centerPoint.x, zoomLevelInstance, wmtSource);
    }

    public ReferencedEnvelope projectTileToMapCrs(ReferencedEnvelope boundsInTileCrs) throws Exception {
        return WMTRenderJob.getProjectedEnvelope(boundsInTileCrs, this.crsMap, this.transformTileCrsToMap);
    }

    public ReferencedEnvelope projectMapToTileCrs(ReferencedEnvelope boundsInMapCrs) throws Exception {
        return WMTRenderJob.getProjectedEnvelope(boundsInMapCrs, this.crsTiles, this.transformMapToTileCrs);
    }
}

