/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt;

import com.vividsolutions.jts.geom.Envelope;
import net.refractions.udig.catalog.internal.wmt.WMTPlugin;
import net.refractions.udig.catalog.internal.wmt.WMTScaleZoomLevelMatcher;
import net.refractions.udig.catalog.internal.wmt.wmtsource.WMTSource;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class WMTRenderJob {
    private CoordinateReferenceSystem crsTilesProjected;
    private MathTransform transformTileCrsToTilesProjected;
    private MathTransform transformTilesProjectedToMap;
    private WMTScaleZoomLevelMatcher zoomLevelMatcher;

    public WMTRenderJob(CoordinateReferenceSystem crsTilesProjected, MathTransform transformTileCrsToTilesProjected, MathTransform transformTilesProjectedToMap, WMTScaleZoomLevelMatcher zoomLevelMatcher) {
        this.zoomLevelMatcher = zoomLevelMatcher;
        this.crsTilesProjected = crsTilesProjected;
        this.transformTileCrsToTilesProjected = transformTileCrsToTilesProjected;
        this.transformTilesProjectedToMap = transformTilesProjectedToMap;
    }

    public static WMTRenderJob createRenderJob(ReferencedEnvelope mapExtentMapCrs, double scale, WMTSource wmtSource) throws Exception {
        WMTScaleZoomLevelMatcher zoomLevelMatcher = WMTScaleZoomLevelMatcher.createMatcher(mapExtentMapCrs, scale, wmtSource);
        CoordinateReferenceSystem crsTilesProjected = wmtSource.getProjectedTileCrs();
        MathTransform transformTileCrsToTilesProjected = WMTRenderJob.getTransformation(zoomLevelMatcher.getCrsTiles(), crsTilesProjected);
        MathTransform transformTilesProjectedToMap = WMTRenderJob.getTransformation(crsTilesProjected, zoomLevelMatcher.getCrsMap());
        return new WMTRenderJob(crsTilesProjected, transformTileCrsToTilesProjected, transformTilesProjectedToMap, zoomLevelMatcher);
    }

    public static int getScaleFactor() {
        return WMTPlugin.getDefault().getPreferenceStore().getInt("SCALEFACTOR");
    }

    public static int getTileLimitWarning() {
        return WMTPlugin.getDefault().getPreferenceStore().getInt("TILELIMIT_WARNING");
    }

    public static int getTileLimitError() {
        return WMTPlugin.getDefault().getPreferenceStore().getInt("TILELIMIT_ERROR");
    }

    public WMTScaleZoomLevelMatcher getZoomLevelMatcher() {
        return this.zoomLevelMatcher;
    }

    public ReferencedEnvelope getMapExtentTileCrs() {
        return this.zoomLevelMatcher.getMapExtentTileCrs();
    }

    public CoordinateReferenceSystem getCrsTilesProjected() {
        return this.crsTilesProjected;
    }

    public CoordinateReferenceSystem getCrsMap() {
        return this.zoomLevelMatcher.getCrsMap();
    }

    public ReferencedEnvelope projectTileToMapCrs(ReferencedEnvelope boundsInTileCrs) throws Exception {
        return this.zoomLevelMatcher.projectTileToMapCrs(boundsInTileCrs);
    }

    public ReferencedEnvelope projectMapToTileCrs(ReferencedEnvelope boundsInMapCrs) throws Exception {
        return this.zoomLevelMatcher.projectMapToTileCrs(boundsInMapCrs);
    }

    public ReferencedEnvelope projectTileToTileProjectedCrs(ReferencedEnvelope boundsInTileCrs) throws Exception {
        return WMTRenderJob.getProjectedEnvelope(boundsInTileCrs, this.crsTilesProjected, this.transformTileCrsToTilesProjected);
    }

    public ReferencedEnvelope projectTileProjectedToMapCrs(ReferencedEnvelope boundsInTilesProjectedCrs) throws Exception {
        return WMTRenderJob.getProjectedEnvelope(boundsInTilesProjectedCrs, this.getCrsMap(), this.transformTilesProjectedToMap);
    }

    public static ReferencedEnvelope getProjectedEnvelope(ReferencedEnvelope envelope, CoordinateReferenceSystem destinationCRS, MathTransform transformation) throws Exception {
        CoordinateReferenceSystem sourceCRS = envelope.getCoordinateReferenceSystem();
        if (sourceCRS.equals(destinationCRS)) {
            return envelope;
        }
        try {
            return new ReferencedEnvelope(JTS.transform((Envelope)envelope, (MathTransform)transformation), destinationCRS);
        }
        catch (Exception exception) {
            return envelope.transform(destinationCRS, false);
        }
    }

    public static MathTransform getTransformation(CoordinateReferenceSystem fromCRS, CoordinateReferenceSystem toCRS) throws Exception {
        if (!fromCRS.equals(toCRS)) {
            return CRS.findMathTransform((CoordinateReferenceSystem)fromCRS, (CoordinateReferenceSystem)toCRS);
        }
        return null;
    }
}

