/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.jiffle.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.jaitools.numeric.CompareOp;
import org.jaitools.numeric.SampleStats;

public class JiffleFunctions {
    private Random rr = new Random();

    public double degToRad(double x) {
        return Math.PI * x / 180.0;
    }

    public Integer sign(double x) {
        if (!Double.isNaN(x)) {
            return CompareOp.acompare((double)x, (double)0.0);
        }
        return null;
    }

    public double isinf(double x) {
        return Double.isNaN(x) ? Double.NaN : (Double.isInfinite(x) ? 1.0 : 0.0);
    }

    public double isnan(double x) {
        return Double.isNaN(x) ? 1.0 : 0.0;
    }

    public double isnull(double x) {
        return Double.isNaN(x) ? 1.0 : 0.0;
    }

    public double log2Arg(double x, double b) {
        return Math.log(x) / Math.log(b);
    }

    public double max(List values) {
        return SampleStats.max((Double[])this.listToArray(values), (boolean)true);
    }

    public double mean(List values) {
        return SampleStats.mean((Double[])this.listToArray(values), (boolean)true);
    }

    public double median(List values) {
        return SampleStats.median((Double[])this.listToArray(values), (boolean)true);
    }

    public double min(List values) {
        return SampleStats.min((Double[])this.listToArray(values), (boolean)true);
    }

    public double mode(List values) {
        return SampleStats.mode((Double[])this.listToArray(values), (boolean)true);
    }

    public double radToDeg(double x) {
        return x / Math.PI * 180.0;
    }

    public double rand(double x) {
        return this.rr.nextDouble() * x;
    }

    public double randInt(double x) {
        return this.rr.nextInt((int)x);
    }

    public double range(List values) {
        return SampleStats.range((Double[])this.listToArray(values), (boolean)true);
    }

    public double round2Arg(double x, double prec) {
        int ifac = (int)(prec + 0.5);
        return Math.round(x / (double)ifac) * (long)ifac;
    }

    public double sdev(List values) {
        return SampleStats.range((Double[])this.listToArray(values), (boolean)true);
    }

    public double sum(List values) {
        return SampleStats.sum((Double[])this.listToArray(values), (boolean)true);
    }

    public double variance(List values) {
        return SampleStats.variance((Double[])this.listToArray(values), (boolean)true);
    }

    public double OR(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return Double.NaN;
        }
        return !CompareOp.isZero((double)x) || !CompareOp.isZero((double)y) ? 1.0 : 0.0;
    }

    public double AND(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return Double.NaN;
        }
        return !CompareOp.isZero((double)x) && !CompareOp.isZero((double)y) ? 1.0 : 0.0;
    }

    public double XOR(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return Double.NaN;
        }
        return !CompareOp.isZero((double)x) ^ !CompareOp.isZero((double)y) ? 1.0 : 0.0;
    }

    public double GT(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return Double.NaN;
        }
        return CompareOp.acompare((double)x, (double)y) > 0 ? 1.0 : 0.0;
    }

    public double GE(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return Double.NaN;
        }
        return CompareOp.acompare((double)x, (double)y) >= 0 ? 1.0 : 0.0;
    }

    public double LT(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return Double.NaN;
        }
        return CompareOp.acompare((double)x, (double)y) < 0 ? 1.0 : 0.0;
    }

    public double LE(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return Double.NaN;
        }
        return CompareOp.acompare((double)x, (double)y) <= 0 ? 1.0 : 0.0;
    }

    public double EQ(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return Double.NaN;
        }
        return CompareOp.acompare((double)x, (double)y) == 0 ? 1.0 : 0.0;
    }

    public double NE(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return Double.NaN;
        }
        return CompareOp.acompare((double)x, (double)y) != 0 ? 1.0 : 0.0;
    }

    public double NOT(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        return CompareOp.isZero((double)x) ? 1.0 : 0.0;
    }

    public List concatDL(double x, List list) {
        ArrayList<Double> copy = new ArrayList<Double>(list);
        copy.add(x);
        return copy;
    }

    public List concatLD(List list, double x) {
        ArrayList<Double> copy = new ArrayList<Double>(list);
        copy.add(x);
        return copy;
    }

    public List concatLL(List list1, List list2) {
        ArrayList copy = new ArrayList(list1);
        copy.addAll(list2);
        return copy;
    }

    private Double[] listToArray(List values) {
        int N = values.size();
        Double[] dvalues = new Double[values.size()];
        for (int i = 0; i < N; ++i) {
            dvalues[i] = ((Number)values.get(i)).doubleValue();
        }
        return dvalues;
    }
}

