/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.jiffle.runtime;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jaitools.jiffle.Jiffle;
import org.jaitools.jiffle.JiffleException;
import org.jaitools.jiffle.runtime.CoordinateTransform;
import org.jaitools.jiffle.runtime.IdentityCoordinateTransform;
import org.jaitools.jiffle.runtime.IntegerStack;
import org.jaitools.jiffle.runtime.JiffleFunctions;
import org.jaitools.jiffle.runtime.JiffleRuntime;
import org.jaitools.jiffle.runtime.JiffleRuntimeException;
import org.jaitools.jiffle.runtime.WorldNotSetException;

public abstract class AbstractJiffleRuntime
implements JiffleRuntime {
    private static final double EPS = 1.0E-8;
    private Map<String, Jiffle.ImageRole> _imageParams;
    private Rectangle2D _worldBounds;
    private double _xres;
    private double _yres;
    private boolean _worldSet;
    private long _numPixels;
    private CoordinateTransform _defaultTransform = new IdentityCoordinateTransform();
    private Map<String, TransformInfo> _transformLookup;
    private static final int VAR_ARRAY_CHUNK = 100;
    protected ImageScopeVar[] _vars = new ImageScopeVar[100];
    protected boolean _imageScopeVarsInitialized;
    protected int _numVars;
    public static final String VAR_STRING = "_vars[_VAR_].value";
    protected boolean _outsideValueSet;
    protected double _outsideValue;
    protected IntegerStack _stk;
    protected final JiffleFunctions _FN = new JiffleFunctions();

    public AbstractJiffleRuntime() {
        this._stk = new IntegerStack();
        this._transformLookup = new HashMap<String, TransformInfo>();
        this._xres = Double.NaN;
        this._yres = Double.NaN;
    }

    public void setImageParams(Map imageParams) {
        this._imageParams = new HashMap<String, Jiffle.ImageRole>();
        for (Object oname : imageParams.keySet()) {
            String name = (String)oname;
            Jiffle.ImageRole role = (Jiffle.ImageRole)((Object)imageParams.get(oname));
            this._imageParams.put(name, role);
        }
    }

    public String[] getSourceVarNames() {
        return this.doGetImageVarNames(Jiffle.ImageRole.SOURCE);
    }

    public String[] getDestinationVarNames() {
        return this.doGetImageVarNames(Jiffle.ImageRole.DEST);
    }

    private String[] doGetImageVarNames(Jiffle.ImageRole role) {
        ArrayList<String> names = new ArrayList<String>();
        for (String name : this._imageParams.keySet()) {
            if (this._imageParams.get(name) != role) continue;
            names.add(name);
        }
        return names.toArray(new String[0]);
    }

    public void setWorldByResolution(Rectangle2D bounds, double xres, double yres) {
        if (bounds == null || bounds.isEmpty()) {
            throw new IllegalArgumentException("bounds cannot be null or empty");
        }
        if (xres < 1.0E-8 || yres < 1.0E-8) {
            throw new IllegalArgumentException("xres and yres but must be greater than 0");
        }
        this.doSetWorld(bounds, xres, yres);
    }

    public void setWorldByNumPixels(Rectangle2D bounds, int numX, int numY) {
        if (bounds == null || bounds.isEmpty()) {
            throw new IllegalArgumentException("bounds cannot be null or empty");
        }
        if (numX <= 0 || numY <= 0) {
            throw new IllegalArgumentException("numX and numY must be greater than 0");
        }
        this.doSetWorld(bounds, bounds.getWidth() / (double)numX, bounds.getHeight() / (double)numY);
    }

    public boolean isWorldSet() {
        return this._worldSet;
    }

    public Double getVar(String varName) {
        int index = this.getVarIndex(varName);
        if (index < 0) {
            return null;
        }
        return this._vars[index].isSet ? Double.valueOf(this._vars[index].value) : null;
    }

    public void setVar(String varName, Double value) throws JiffleRuntimeException {
        int index = this.getVarIndex(varName);
        if (index < 0) {
            throw new JiffleRuntimeException("Undefined variable: " + varName);
        }
        this.setVarValue(index, value);
    }

    public String[] getVarNames() {
        String[] names = new String[this._numVars];
        for (int i = 0; i < this._numVars; ++i) {
            names[i] = this._vars[i].name;
        }
        return names;
    }

    public double getMinX() {
        return this._worldBounds.getMinX();
    }

    public double getMaxX() {
        return this._worldBounds.getMaxX();
    }

    public double getMinY() {
        return this._worldBounds.getMinY();
    }

    public double getMaxY() {
        return this._worldBounds.getMaxY();
    }

    public double getWidth() {
        return this._worldBounds.getWidth();
    }

    public double getHeight() {
        return this._worldBounds.getHeight();
    }

    public double getXRes() {
        return this._xres;
    }

    public double getYRes() {
        return this._yres;
    }

    public long getNumPixels() {
        if (!this._worldSet) {
            throw new IllegalStateException("Processing area has not been set");
        }
        return this._numPixels;
    }

    protected void setTransform(String imageVarName, CoordinateTransform tr) throws WorldNotSetException {
        TransformInfo info = new TransformInfo();
        if (tr == null) {
            info.transform = this._defaultTransform;
            info.isDefault = true;
        } else {
            if (!this.isWorldSet()) {
                throw new WorldNotSetException();
            }
            info.transform = tr;
            info.isDefault = false;
        }
        this._transformLookup.put(imageVarName, info);
    }

    public void setDefaultTransform(CoordinateTransform tr) throws JiffleException {
        if (tr != null) {
            if (!this.isWorldSet()) {
                throw new JiffleException("Setting a default coordinate tranform without having first set the world bounds and resolution");
            }
        } else {
            tr = new IdentityCoordinateTransform();
        }
        this._defaultTransform = tr;
        for (String name : this._transformLookup.keySet()) {
            TransformInfo info = this._transformLookup.get(name);
            if (!info.isDefault) continue;
            info.transform = this._defaultTransform;
            this._transformLookup.put(name, info);
        }
    }

    protected CoordinateTransform getTransform(String imageVarName) {
        return this._transformLookup.get((Object)imageVarName).transform;
    }

    protected void setVarValue(int index, Double value) throws JiffleRuntimeException {
        if (value == null) {
            if (!this._vars[index].hasDefaultValue) {
                throw new JiffleRuntimeException("Value cannot be null for variable with no default: " + this._vars[index].name);
            }
            this._imageScopeVarsInitialized = false;
            this._vars[index].isSet = false;
        } else {
            this._vars[index].value = value;
            this._vars[index].isSet = true;
        }
    }

    protected int getVarIndex(String varName) {
        for (int i = 0; i < this._numVars; ++i) {
            if (!this._vars[i].name.equals(varName)) continue;
            return i;
        }
        return -1;
    }

    protected void initImageScopeVars() {
        for (int i = 0; i < this._numVars; ++i) {
            if (this._vars[i].isSet) continue;
            Double value = this.getDefaultValue(i);
            if (value == null) {
                throw new JiffleRuntimeException("No default value set for " + this._vars[i].name);
            }
            this._vars[i].value = value;
            this._vars[i].isSet = true;
        }
        this._imageScopeVarsInitialized = true;
    }

    protected abstract Double getDefaultValue(int var1);

    protected abstract void initOptionVars();

    protected void registerVar(String name, boolean hasDefault) {
        if (this.getVarIndex(name) >= 0) {
            throw new JiffleRuntimeException("Variable already defined: " + name);
        }
        ++this._numVars;
        ImageScopeVar var = new ImageScopeVar(name, hasDefault);
        if (this._numVars > this._vars.length) {
            this.growVarsArray();
        }
        this._vars[this._numVars - 1] = var;
    }

    private void growVarsArray() {
        ImageScopeVar[] temp = this._vars;
        this._vars = new ImageScopeVar[this._vars.length + 100];
        System.arraycopy(temp, 0, this._vars, 0, temp.length);
    }

    private void doSetWorld(Rectangle2D bounds, double xres, double yres) {
        this.checkResValue(xres, Dim.XDIM, bounds);
        this.checkResValue(yres, Dim.YDIM, bounds);
        this._worldBounds = new Rectangle2D.Double(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
        this._xres = xres;
        this._yres = yres;
        this._worldSet = true;
    }

    private void checkResValue(double value, Dim dim, Rectangle2D bounds) {
        String name;
        String string = name = dim == Dim.XDIM ? "xres" : "yres";
        if (Double.isInfinite(value)) {
            throw new IllegalArgumentException(name + " cannot be infinite");
        }
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException(name + " cannot be NaN");
        }
        if (dim == Dim.XDIM && value > bounds.getWidth()) {
            throw new IllegalArgumentException(name + "should be less than processing area width");
        }
        if (dim == Dim.YDIM && value > bounds.getHeight()) {
            throw new IllegalArgumentException(name + "should be less than processing area height");
        }
    }

    public class ImageScopeVar {
        public String name;
        public boolean hasDefaultValue;
        public boolean isSet;
        public double value;

        public ImageScopeVar(String name, boolean hasDefaultValue) {
            this.name = name;
            this.hasDefaultValue = hasDefaultValue;
        }
    }

    private class TransformInfo {
        CoordinateTransform transform;
        boolean isDefault;

        private TransformInfo() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Dim {
        XDIM,
        YDIM;

    }
}

