/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.jiffle.runtime;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;
import org.jaitools.jiffle.JiffleException;
import org.jaitools.jiffle.runtime.AbstractJiffleRuntime;
import org.jaitools.jiffle.runtime.CoordinateTransform;
import org.jaitools.jiffle.runtime.JiffleDirectRuntime;
import org.jaitools.jiffle.runtime.JiffleProgressListener;
import org.jaitools.jiffle.runtime.JiffleRuntimeException;
import org.jaitools.jiffle.runtime.NullProgressListener;
import org.jaitools.jiffle.runtime.WorldNotSetException;

public abstract class AbstractDirectRuntime
extends AbstractJiffleRuntime
implements JiffleDirectRuntime {
    private static final double EPS = 1.0E-10;
    protected Map images = new HashMap();
    protected Map readers = new LinkedHashMap();
    protected Map writers = new LinkedHashMap();

    public AbstractDirectRuntime() {
        this.initOptionVars();
    }

    public void setDestinationImage(String varName, WritableRenderedImage image) {
        try {
            this.doSetDestinationImage(varName, image, null);
        }
        catch (WorldNotSetException worldNotSetException) {
            // empty catch block
        }
    }

    public void setDestinationImage(String varName, WritableRenderedImage image, CoordinateTransform tr) throws JiffleException {
        try {
            this.doSetDestinationImage(varName, image, tr);
        }
        catch (WorldNotSetException ex) {
            throw new JiffleException(String.format("Setting a coordinate tranform for a destination (%s) withouthaving first set the world bounds and resolution", varName));
        }
    }

    private void doSetDestinationImage(String varName, WritableRenderedImage image, CoordinateTransform tr) throws WorldNotSetException {
        this.images.put(varName, image);
        this.writers.put(varName, RandomIterFactory.createWritable((WritableRenderedImage)image, null));
        this.setTransform(varName, tr);
    }

    public void setSourceImage(String varName, RenderedImage image) {
        try {
            this.doSetSourceImage(varName, image, null);
        }
        catch (WorldNotSetException worldNotSetException) {
            // empty catch block
        }
    }

    public void setSourceImage(String varName, RenderedImage image, CoordinateTransform tr) throws JiffleException {
        try {
            this.doSetSourceImage(varName, image, tr);
        }
        catch (WorldNotSetException ex) {
            throw new JiffleException(String.format("Setting a coordinate tranform for a source (%s) withouthaving first set the world bounds and resolution", varName));
        }
    }

    private void doSetSourceImage(String varName, RenderedImage image, CoordinateTransform tr) throws WorldNotSetException {
        this.images.put(varName, image);
        this.readers.put(varName, RandomIterFactory.create((RenderedImage)image, null));
        this.setTransform(varName, tr);
    }

    public void evaluateAll(JiffleProgressListener pl) {
        JiffleProgressListener listener;
        JiffleProgressListener jiffleProgressListener = listener = pl == null ? new NullProgressListener() : pl;
        if (!this.isWorldSet()) {
            this.setDefaultBounds();
        }
        long numPixels = this.getNumPixels();
        listener.setTaskSize(numPixels);
        long count = 0L;
        long sinceLastUpdate = 0L;
        long updateInterval = listener.getUpdateInterval();
        double minX = this.getMinX();
        double maxX = this.getMaxX();
        double resX = this.getXRes();
        double minY = this.getMinY();
        double maxY = this.getMaxY();
        double resY = this.getYRes();
        listener.start();
        for (double y = minY; y < maxY - 1.0E-10; y += resY) {
            for (double x = minX; x < maxX - 1.0E-10; x += resX) {
                this.evaluate(x, y);
                ++count;
                if (++sinceLastUpdate < updateInterval) continue;
                listener.update(count);
                sinceLastUpdate = 0L;
            }
        }
        listener.finish();
    }

    public double readFromImage(String srcImageName, double x, double y, int band) {
        boolean inside = true;
        RenderedImage img = (RenderedImage)this.images.get(srcImageName);
        CoordinateTransform tr = this.getTransform(srcImageName);
        Point imgPos = tr.worldToImage(x, y, null);
        int xx = imgPos.x - img.getMinX();
        if (xx < 0 || xx >= img.getWidth()) {
            inside = false;
        } else {
            int yy = imgPos.y - img.getMinY();
            if (yy < 0 || yy >= img.getHeight()) {
                inside = false;
            }
        }
        if (!inside) {
            if (this._outsideValueSet) {
                return this._outsideValue;
            }
            throw new JiffleRuntimeException(String.format("Position %.4f %.4f is outside bounds of image: %s", x, y, srcImageName));
        }
        RandomIter iter = (RandomIter)this.readers.get(srcImageName);
        return iter.getSampleDouble(imgPos.x, imgPos.y, band);
    }

    public void writeToImage(String destImageName, double x, double y, int band, double value) {
        WritableRandomIter iter = (WritableRandomIter)this.writers.get(destImageName);
        CoordinateTransform tr = this.getTransform(destImageName);
        Point imgPos = tr.worldToImage(x, y, null);
        iter.setSample(imgPos.x, imgPos.y, band, value);
    }

    public void setDefaultBounds() {
        RenderedImage refImage = null;
        String imageName = null;
        if (!this.writers.isEmpty()) {
            imageName = (String)this.writers.keySet().iterator().next();
            refImage = (RenderedImage)this.images.get(imageName);
        } else {
            imageName = (String)this.readers.keySet().iterator().next();
            refImage = (RenderedImage)this.images.get(imageName);
        }
        Rectangle rect = new Rectangle(refImage.getMinX(), refImage.getMinY(), refImage.getWidth(), refImage.getHeight());
        this.setWorldByResolution(rect, 1.0, 1.0);
    }

    public Map getImages() {
        HashMap copy = new HashMap();
        copy.putAll(this.images);
        return copy;
    }
}

