/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.jiffle.parser;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jaitools.CollectionFactory;
import org.jaitools.jiffle.parser.OptionInfo;
import org.jaitools.jiffle.parser.UndefinedOptionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionLookup {
    private static final List<OptionInfo> options = CollectionFactory.list();
    private static final Map<String, String> activeRuntimeExpr;
    private static final List<String> names;

    public static boolean isDefined(String optionName) {
        try {
            OptionLookup.getInfo(optionName);
            return true;
        }
        catch (UndefinedOptionException ex) {
            return false;
        }
    }

    public static boolean isValidValue(String optionName, String value) throws UndefinedOptionException {
        return OptionLookup.getInfo(optionName).isValidValue(value);
    }

    public static Iterable<String> getNames() {
        return Collections.unmodifiableList(names);
    }

    public static String getActiveRuntimExpr(String name, String value) throws UndefinedOptionException {
        String key = name.toLowerCase();
        String expr = activeRuntimeExpr.get(key);
        if (expr == null) {
            throw new UndefinedOptionException(name);
        }
        return expr.replace("_VALUE_", value);
    }

    private static OptionInfo getInfo(String optionName) throws UndefinedOptionException {
        for (OptionInfo info : options) {
            if (!info.getName().equalsIgnoreCase(optionName)) continue;
            return info;
        }
        throw new UndefinedOptionException(optionName);
    }

    static {
        names = CollectionFactory.list();
        activeRuntimeExpr = CollectionFactory.map();
        String name = "outside";
        OptionInfo info = new OptionInfo(name, new String[]{"ANY_NUMBER", "NULL_KEYWORD"});
        options.add(info);
        names.add(name);
        activeRuntimeExpr.put(name, "_outsideValueSet = true;\n_outsideValue = _VALUE_;");
    }
}

