/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tool.select.internal;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.aoi.AOIListener;
import net.refractions.udig.aoi.IAOIStrategy;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.Interaction;
import net.refractions.udig.project.ui.ApplicationGIS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class AOILayerStrategy
extends IAOIStrategy {
    private static final String AOI_GEOMETRY = "aoiGeometry";
    private static final String AOI_LAYER = "aoiLayer";
    private static String name = "Layer";

    public void setGeometry(Geometry geometry) {
        IBlackboard mapBlackboard;
        ILayer victim = this.getActiveLayer();
        if (victim != null) {
            IBlackboard blackboard = victim.getBlackboard();
            if (geometry != null) {
                blackboard.put(AOI_GEOMETRY, (Object)geometry);
            } else {
                blackboard.remove(AOI_GEOMETRY);
            }
            mapBlackboard = victim.getMap().getBlackboard();
        } else {
            IMap activeMap = ApplicationGIS.getActiveMap();
            if (activeMap == null) {
                return;
            }
            mapBlackboard = activeMap.getBlackboard();
        }
        if (geometry != null) {
            String wkt = geometry.toText();
            mapBlackboard.put(AOI_GEOMETRY, (Object)wkt);
        } else {
            mapBlackboard.remove(AOI_GEOMETRY);
        }
        AOIListener.Event aoiEvent = new AOIListener.Event((IAOIStrategy)this);
        this.notifyListeners(aoiEvent);
    }

    public ReferencedEnvelope getExtent() {
        Geometry geometry = this.getGeometry();
        if (geometry != null) {
            CoordinateReferenceSystem crs = this.getCrs();
            return new ReferencedEnvelope(geometry.getEnvelopeInternal(), crs);
        }
        return null;
    }

    public Geometry getGeometry() {
        ILayer victim = this.getActiveLayer();
        if (victim == null) {
            return null;
        }
        IBlackboard blackboard = victim.getBlackboard();
        Geometry geometry = (Geometry)blackboard.get(AOI_GEOMETRY);
        return geometry;
    }

    public CoordinateReferenceSystem getCrs() {
        ILayer activeLayer = this.getActiveLayer();
        if (activeLayer == null) {
            return null;
        }
        return activeLayer.getCRS();
    }

    public String getName() {
        return name;
    }

    public List<ILayer> getAOILayers() {
        List layers = ApplicationGIS.getActiveMap().getMapLayers();
        ArrayList<ILayer> aoiLayers = new ArrayList<ILayer>();
        for (ILayer layer : layers) {
            if (!layer.getInteraction(Interaction.AOI)) continue;
            aoiLayers.add(layer);
        }
        return aoiLayers;
    }

    public ILayer getActiveLayer() {
        IMap map = ApplicationGIS.getActiveMap();
        ILayer layer = this.restoreFromMapBlackboard(map);
        if (layer != null) {
            return layer;
        }
        return null;
    }

    private ILayer restoreFromMapBlackboard(IMap map) {
        String layerId = (String)map.getBlackboard().get(AOI_LAYER);
        if (layerId != null) {
            for (ILayer layer : map.getMapLayers()) {
                String wkt;
                if (!layerId.equals(layer.getID().toExternalForm())) continue;
                IBlackboard blackboard = layer.getBlackboard();
                if (blackboard.get(AOI_GEOMETRY) == null && (wkt = map.getBlackboard().getString(AOI_GEOMETRY)) != null) {
                    GeometryFactory gf = JTSFactoryFinder.getGeometryFactory(null);
                    WKTReader reader = new WKTReader(gf);
                    try {
                        Geometry geometry = reader.read(wkt);
                        blackboard.put(AOI_GEOMETRY, (Object)geometry);
                    }
                    catch (ParseException parseException) {}
                }
                return layer;
            }
        }
        return null;
    }

    public void setActiveLayer(ILayer activeLayer) {
        if (activeLayer != null) {
            IMap map = activeLayer.getMap();
            String layerId = activeLayer.getID().toExternalForm();
            map.getBlackboard().put(AOI_LAYER, (Object)layerId);
        } else {
            IMap map = ApplicationGIS.getActiveMap();
            if (map == null) {
                return;
            }
            map.getBlackboard().remove(AOI_LAYER);
        }
        AOIListener.Event aoiEvent = new AOIListener.Event((IAOIStrategy)this);
        this.notifyListeners(aoiEvent);
    }

    public ILayer getNextLayer() {
        ILayer activeLayer;
        List<ILayer> layers = this.getAOILayers();
        int index = layers.indexOf(activeLayer = this.getActiveLayer());
        if (index < layers.size() - 1) {
            return layers.get(index + 1);
        }
        return null;
    }

    public ILayer getPreviousLayer() {
        ILayer activeLayer = this.getActiveLayer();
        if (activeLayer == null) {
            return null;
        }
        List<ILayer> layers = this.getAOILayers();
        int index = layers.indexOf(activeLayer);
        if (index > 0) {
            ILayer previousLayer = layers.get(index - 1);
            return previousLayer;
        }
        return null;
    }
}

