/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tool.select.internal;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;
import net.refractions.udig.aoi.AOIListener;
import net.refractions.udig.aoi.IAOIService;
import net.refractions.udig.aoi.IAOIStrategy;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.ui.commands.SelectionBoxCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import net.refractions.udig.project.ui.tool.AbstractModalTool;
import net.refractions.udig.project.ui.tool.ModalTool;
import net.refractions.udig.project.ui.tool.options.ToolOptionContributionItem;
import net.refractions.udig.tool.select.SelectPlugin;
import net.refractions.udig.tool.select.commands.SetAOILayerCommand;
import net.refractions.udig.tool.select.internal.AOILayerStrategy;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class AOILayerSelectionTool
extends AbstractModalTool
implements ModalTool {
    private SelectionBoxCommand shapeCommand;
    private boolean selecting;
    private Point start;
    private String CURSORPOINTID = "aoiSelectCursor";
    private String CURSORBOXID = "aoiBoxSelectCursor";
    boolean showContextOnRightClick = false;

    public AOILayerSelectionTool() {
        super(3);
    }

    public void mousePressed(MapMouseEvent e) {
        this.shapeCommand = new SelectionBoxCommand();
        if (e.button == 32 && this.showContextOnRightClick) {
            ((ViewportPane)e.source).getMapEditor().openContextMenu();
            return;
        }
        if (e.button == 8 || e.button == 32) {
            this.updateCursor(e);
            this.start = e.getPoint();
            if (e.isShiftDown()) {
                this.selecting = true;
                this.shapeCommand.setValid(true);
                this.shapeCommand.setShape((Shape)new Rectangle(this.start.x, this.start.y, 0, 0));
                this.context.sendASyncCommand((Command)this.shapeCommand);
            } else {
                this.selecting = false;
                this.clickFeedback(e);
                Envelope bounds = this.getBounds(e);
                this.sendSelectionCommand(e, bounds);
            }
        }
    }

    public void mouseReleased(MapMouseEvent e) {
        if (this.selecting) {
            Envelope bounds = this.getBounds(e);
            this.sendSelectionCommand(e, bounds);
        }
    }

    private Envelope getBounds(MapMouseEvent e) {
        Point point = e.getPoint();
        if (this.start == null || this.start.equals(point)) {
            return this.getContext().getBoundingBox(point, 3);
        }
        Coordinate c1 = this.context.getMap().getViewportModel().pixelToWorld(this.start.x, this.start.y);
        Coordinate c2 = this.context.getMap().getViewportModel().pixelToWorld(point.x, point.y);
        return new Envelope(c1, c2);
    }

    public void mouseDragged(MapMouseEvent e) {
        if (this.selecting) {
            Point end = e.getPoint();
            if (this.start == null) {
                return;
            }
            this.shapeCommand.setShape((Shape)new Rectangle(Math.min(this.start.x, end.x), Math.min(this.start.y, end.y), Math.abs(this.start.x - end.x), Math.abs(this.start.y - end.y)));
            this.context.getViewportPane().repaint();
        }
    }

    protected void sendSelectionCommand(MapMouseEvent e, Envelope bounds) {
        SetAOILayerCommand command = new SetAOILayerCommand(e, bounds);
        this.getContext().sendASyncCommand((Command)command);
        this.selecting = false;
        this.shapeCommand.setValid(false);
        this.getContext().getViewportPane().repaint();
    }

    public void clickFeedback(MapMouseEvent e) {
        Rectangle square = new Rectangle(e.x - 2, e.y - 2, 4, 4);
        this.shapeCommand.setValid(true);
        this.shapeCommand.setShape((Shape)square);
        this.context.sendASyncCommand((Command)this.shapeCommand);
        this.context.getViewportPane().repaint();
    }

    private void updateCursor(MapMouseEvent e) {
        if (e.isAltDown()) {
            this.setCursorID(this.CURSORBOXID);
        } else {
            this.setCursorID(this.CURSORPOINTID);
        }
    }

    public void dispose() {
        super.dispose();
    }

    public static class OptionContribtionItem
    extends ToolOptionContributionItem {
        private ComboViewer comboViewer;
        private static String AOI_LAYER_ID = "net.refractions.udig.tool.select.internal.aoiLayer";
        private ISelectionChangedListener comboListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selectedStrategy = (IStructuredSelection)event.getSelection();
                ILayer layer = (ILayer)selectedStrategy.getFirstElement();
                OptionContribtionItem.this.setActiveLayer(layer);
            }
        };
        protected AOIListener watcher = new AOIListener(){

            public void handleEvent(AOIListener.Event event) {
                PlatformGIS.asyncInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ILayer activeLayer = OptionContribtionItem.this.getAOILayerStrategy().getActiveLayer();
                        List<ILayer> layers = OptionContribtionItem.this.getAOILayerStrategy().getAOILayers();
                        if (OptionContribtionItem.this.comboViewer == null || OptionContribtionItem.this.comboViewer.getControl() == null || OptionContribtionItem.this.comboViewer.getControl().isDisposed()) {
                            return;
                        }
                        OptionContribtionItem.this.comboViewer.setInput(layers);
                        if (layers.contains(activeLayer)) {
                            OptionContribtionItem.this.setSelected(activeLayer);
                        } else {
                            OptionContribtionItem.this.setSelected(null);
                        }
                    }
                }, (boolean)true);
            }
        };

        protected IPreferenceStore fillFields(Composite parent) {
            Button nav = new Button(parent, 32);
            nav.setText("Navigate");
            this.addField("aoiNavigateSelection", nav);
            this.setCombo(parent);
            this.listenAOILayer(true);
            List<ILayer> layers = this.getAOILayerStrategy().getAOILayers();
            ILayer activeLayer = this.getAOILayerStrategy().getActiveLayer();
            this.comboViewer.setInput(layers);
            if (!layers.isEmpty()) {
                this.comboViewer.setInput(layers);
                if (activeLayer == null) {
                    activeLayer = layers.get(0);
                }
            }
            this.setSelected(activeLayer);
            this.listenCombo(true);
            return SelectPlugin.getDefault().getPreferenceStore();
        }

        private void setCombo(Composite parent) {
            this.comboViewer = new ComboViewer(parent, 8);
            this.comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof ILayer) {
                        ILayer layer = (ILayer)element;
                        return layer.getName();
                    }
                    return super.getText(element);
                }
            });
            this.comboViewer.setInput(this.getAOILayers());
        }

        protected void listenCombo(boolean listen) {
            if (this.comboViewer == null || this.comboViewer.getControl().isDisposed()) {
                return;
            }
            if (listen) {
                this.comboViewer.addSelectionChangedListener(this.comboListener);
            } else {
                this.comboViewer.removeSelectionChangedListener(this.comboListener);
            }
        }

        protected void listenAOILayer(boolean listen) {
            AOILayerStrategy aOILayerStrategy = this.getAOILayerStrategy();
            if (aOILayerStrategy == null) {
                return;
            }
            if (listen) {
                aOILayerStrategy.addListener(this.watcher);
            } else {
                aOILayerStrategy.removeListener(this.watcher);
            }
        }

        private void setSelected(ILayer selected) {
            boolean disposed = this.comboViewer.getControl().isDisposed();
            if (this.comboViewer == null || disposed) {
                this.listenAOILayer(false);
                return;
            }
            ILayer current = this.getSelected();
            if (current != selected) {
                try {
                    this.listenCombo(false);
                    this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)selected), true);
                }
                finally {
                    this.listenCombo(true);
                }
            }
        }

        private ILayer getSelected() {
            if (this.comboViewer.getSelection() instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)this.comboViewer.getSelection();
                return (ILayer)selection.getFirstElement();
            }
            return null;
        }

        private void setActiveLayer(ILayer activeLayer) {
            this.getAOILayerStrategy().setActiveLayer(activeLayer);
        }

        private AOILayerStrategy getAOILayerStrategy() {
            IAOIService aOIService = PlatformGIS.getAOIService();
            IAOIStrategy aOIStrategy = aOIService.findProxy(AOI_LAYER_ID).getStrategy();
            if (aOIStrategy instanceof AOILayerStrategy) {
                return (AOILayerStrategy)aOIStrategy;
            }
            return null;
        }

        private List<ILayer> getAOILayers() {
            return this.getAOILayerStrategy().getAOILayers();
        }
    }
}

