/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tool.select;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.aoi.AOIListener;
import net.refractions.udig.aoi.IAOIService;
import net.refractions.udig.core.IBlockingProvider;
import net.refractions.udig.core.IProvider;
import net.refractions.udig.core.StaticBlockingProvider;
import net.refractions.udig.core.filter.AdaptingFilter;
import net.refractions.udig.core.filter.AdaptingFilterFactory;
import net.refractions.udig.project.EditManagerEvent;
import net.refractions.udig.project.IEditManagerListener;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.ILayerListener;
import net.refractions.udig.project.IMapCompositionListener;
import net.refractions.udig.project.LayerEvent;
import net.refractions.udig.project.MapCompositionEvent;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.CompositeCommand;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.UndoableCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.command.factory.EditCommandFactory;
import net.refractions.udig.project.command.factory.SelectionCommandFactory;
import net.refractions.udig.project.command.provider.FIDFeatureProvider;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.commands.edit.DeleteFeatureCommand;
import net.refractions.udig.project.internal.commands.edit.DeleteManyFeaturesCommand;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.IUDIGView;
import net.refractions.udig.project.ui.internal.MapPart;
import net.refractions.udig.project.ui.internal.tool.display.ToolManager;
import net.refractions.udig.project.ui.tool.IToolContext;
import net.refractions.udig.tool.select.AdaptableFeatureCollection;
import net.refractions.udig.tool.select.FeatureTypeCellModifier;
import net.refractions.udig.tool.select.SelectPlugin;
import net.refractions.udig.tool.select.internal.Messages;
import net.refractions.udig.ui.FeatureTableControl;
import net.refractions.udig.ui.IFeatureTableLoadingListener;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.ProgressManager;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.UIPlugin;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.Schema;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Intersects;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class TableView
extends ViewPart
implements ISelectionProvider,
IUDIGView {
    private static final String INITIAL_TEXT = Messages.TableView_search;
    protected static final String ANY = Messages.TableView_search_any;
    protected static final String CQL = "CQL";
    private boolean aoiFilter = false;
    FeatureTableControl table;
    MapPart currentEditor;
    Layer layer;
    private IAction select;
    private ISelectionListener workbenchSelectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            Layer selectedLayer;
            if (part instanceof MapPart) {
                TableView.this.editorActivated((MapPart)part);
                return;
            }
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            if (part == TableView.this.getSite().getPart()) {
                return;
            }
            Object selected = ((IStructuredSelection)selection).getFirstElement();
            if (selected instanceof Map) {
                selectedLayer = ((Map)selected).getEditManagerInternal().getSelectedLayer();
            } else if (selected instanceof Layer) {
                selectedLayer = (Layer)selected;
            } else if (selected instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)selected;
                selectedLayer = (Layer)adaptable.getAdapter(Layer.class);
            } else {
                return;
            }
            if (selectedLayer != null) {
                PlatformGIS.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        SelectPlugin.log("error selecting layer", exception);
                    }

                    public void run() throws Exception {
                        TableView.this.layerSelected((ILayer)selectedLayer);
                    }
                });
            }
        }
    };
    private IWorkbenchPage page;
    private IPartListener2 activePartListener;
    private MenuManager contextMenu;
    private volatile boolean active = false;
    protected volatile boolean reloadNeeded = false;
    protected volatile boolean filterChange = false;
    protected volatile boolean editing = false;
    private volatile boolean updatingSelection = false;
    protected volatile boolean updatingLayerFilter;
    private PromoteSelectionAction promoteSelection;
    private Label featuresSelected;
    private Combo attributeCombo;
    private IAction zoom;
    private IAction deleteAction;
    private Button selectAllCheck;
    private Text searchWidget;
    private AOIListener aoiServiceListener;
    private List<FeatureEvent> updates = Collections.synchronizedList(new ArrayList());
    private ILayerListener layerListener = new ILayerListener(){

        public void refresh(LayerEvent event) {
            ILayer notifierLayer = event.getSource();
            if (!$assertionsDisabled && TableView.this.layer != notifierLayer) {
                throw new AssertionError();
            }
            switch (event.getType()) {
                case EDIT_EVENT: {
                    if (TableView.this.editing) break;
                    if (event.getNewValue() == null) {
                        TableView.this.reloadFeatures(notifierLayer);
                        return;
                    }
                    TableView.this.updates.add((FeatureEvent)event.getNewValue());
                    if (!TableView.this.active) break;
                    TableView.this.updateTable(notifierLayer);
                    break;
                }
                case FILTER: {
                    if (TableView.this.active) {
                        TableView.this.updateSelection(notifierLayer);
                        break;
                    }
                    TableView.this.filterChange = true;
                }
            }
        }
    };
    private IMapCompositionListener compositionListener = new IMapCompositionListener(){

        public void changed(MapCompositionEvent event) {
            if (event.getType() == MapCompositionEvent.EventType.REMOVED) {
                if (event.getLayer() == TableView.this.layer) {
                    TableView.this.layerSelected(null);
                }
            } else if (event.getType() == MapCompositionEvent.EventType.MANY_REMOVED && ((List)event.getNewValue()).contains(TableView.this.layer)) {
                TableView.this.layerSelected(null);
            }
        }
    };
    private IEditManagerListener editManagerListener = new IEditManagerListener(){

        public void changed(EditManagerEvent event) {
            if (!($assertionsDisabled || TableView.this.layer == null || TableView.this.layer != null && TableView.this.layer.getMap() == event.getSource().getMap())) {
                throw new AssertionError();
            }
            switch (event.getType()) {
                case -4: 
                case -1: {
                    if (!TableView.this.active) {
                        TableView.this.reloadNeeded = true;
                        return;
                    }
                    TableView.this.reloadFeatures((ILayer)TableView.this.layer);
                    break;
                }
                case 5: {
                    TableView.this.layerSelected((ILayer)event.getNewValue());
                    break;
                }
            }
        }
    };
    private Set<ISelectionChangedListener> selectionChangeListeners = new CopyOnWriteArraySet<ISelectionChangedListener>();
    private IToolContext currentContext;

    public void createPartControl(Composite parent) {
        this.active = true;
        this.featuresSelected = new Label(parent, 0);
        this.featuresSelected.setText(String.valueOf(Messages.TableView_featureSelected) + 0);
        this.attributeCombo = new Combo(parent, 12);
        this.attributeCombo.setItems(new String[]{ANY, CQL});
        this.attributeCombo.select(0);
        this.attributeCombo.setEnabled(false);
        SearchBox search = new SearchBox();
        this.searchWidget = search.createPart(parent);
        IProvider<IProgressMonitor> provider = new IProvider<IProgressMonitor>(){

            public IProgressMonitor get(Object ... params) {
                IStatusLineManager statusLineManager = TableView.this.getViewSite().getActionBars().getStatusLineManager();
                statusLineManager.setCancelEnabled(true);
                return statusLineManager.getProgressMonitor();
            }
        };
        this.selectAllCheck = new Button(parent, 32);
        this.selectAllCheck.setText(Messages.TableView_allCheckText);
        this.selectAllCheck.setToolTipText(Messages.TableView_allToolTip);
        this.selectAllCheck.setEnabled(false);
        this.selectAllCheck.setSelection(true);
        this.table = new FeatureTableControl((IProvider)provider);
        this.table.createTableControl(parent);
        this.table.setSelectionColor((IProvider)new IProvider<RGB>(){

            public RGB get(Object ... params) {
                ScopedPreferenceStore store = ProjectPlugin.getPlugin().getPreferenceStore();
                String key = "P_SELECTION_COLOR";
                RGB color = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
                return color;
            }
        });
        IAOIService aOIService = PlatformGIS.getAOIService();
        this.aoiServiceListener = new AOIListener(){

            public void handleEvent(AOIListener.Event event) {
                if (TableView.this.isAOIFilter()) {
                    TableView.this.reloadFeatures((ILayer)TableView.this.layer);
                }
            }
        };
        aOIService.addListener(this.aoiServiceListener);
        this.table.addLoadingListener(new IFeatureTableLoadingListener(){

            public void loadingStarted(IProgressMonitor monitor) {
                TableView.this.searchWidget.setEnabled(false);
                TableView.this.selectAllCheck.setEnabled(false);
                TableView.this.attributeCombo.setEnabled(false);
            }

            public void loadingStopped(boolean canceled) {
                TableView.this.searchWidget.setEnabled(true);
                TableView.this.selectAllCheck.setEnabled(true);
                TableView.this.attributeCombo.setEnabled(true);
            }
        });
        this.layoutComponents(parent);
        this.createActions();
        this.createMenu();
        this.createToolbar();
        this.hookGlobalActions();
        this.createContextMenu();
        this.page = this.getSite().getPage();
        if (this.page.getActiveEditor() instanceof MapPart) {
            this.editorActivated((MapPart)this.page.getActiveEditor());
        }
        this.addTableSelectionListener();
        this.addWorkbenchSelectionListener();
        this.addPageListener();
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        ApplicationGIS.getToolManager().registerActionsWithPart((IWorkbenchPart)this);
    }

    public boolean isAOIFilter() {
        return this.aoiFilter;
    }

    public void setAOIFilter(boolean aoiFilter) {
        this.aoiFilter = aoiFilter;
        this.reloadFeatures((ILayer)this.layer);
    }

    private void addTableSelectionListener() {
        this.table.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSource() == TableView.this.table) {
                    TableView.this.featuresSelected.setText(String.valueOf(Messages.TableView_featureSelected) + TableView.this.table.getSelectionCount());
                }
                if (TableView.this.updatingSelection) {
                    TableView.this.updatingSelection = false;
                    return;
                }
                ISelection selection = TableView.this.getSelection();
                if (selection.isEmpty()) {
                    TableView.this.updateLayerFilter((Filter)Filter.EXCLUDE);
                } else if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    Filter firstElement = (Filter)structuredSelection.getFirstElement();
                    TableView.this.updateLayerFilter(firstElement);
                }
                TableView.this.fireSelectionChanged();
            }
        });
    }

    private void updateLayerFilter(Filter filter) {
        this.updatingLayerFilter = true;
        UndoableMapCommand createSelectCommand = SelectionCommandFactory.getInstance().createSelectCommand((ILayer)this.layer, filter);
        this.layer.getMap().sendCommandSync((MapCommand)createSelectCommand);
        this.updatingLayerFilter = false;
        this.setZoomToSelectionToolEnablement();
    }

    private void layoutComponents(Composite parent) {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.spacing = 0;
        parent.setLayout((Layout)layout);
        FormData dLabel = new FormData();
        dLabel.left = new FormAttachment(0, 5);
        dLabel.top = new FormAttachment((Control)this.attributeCombo, 2);
        dLabel.right = new FormAttachment(100, -5);
        this.featuresSelected.setLayoutData((Object)dLabel);
        FormData dCombo = new FormData();
        dCombo.left = new FormAttachment(0, 5);
        dCombo.top = new FormAttachment(0);
        dCombo.right = new FormAttachment(30, -5);
        this.attributeCombo.setLayoutData((Object)dCombo);
        FormData dText = new FormData();
        dText.left = new FormAttachment((Control)this.attributeCombo);
        dText.top = new FormAttachment(0);
        dText.right = new FormAttachment(95, -5);
        this.searchWidget.setLayoutData((Object)dText);
        FormData dCheck = new FormData();
        dCheck.top = new FormAttachment(2);
        dCheck.left = new FormAttachment((Control)this.searchWidget, 5);
        dCheck.right = new FormAttachment(100, -5);
        this.selectAllCheck.setLayoutData((Object)dCheck);
        FormData dContents = new FormData(100, 100);
        dContents.right = new FormAttachment(100);
        dContents.left = new FormAttachment(0);
        dContents.top = new FormAttachment((Control)this.featuresSelected, 2);
        dContents.bottom = new FormAttachment(100);
        this.table.getControl().setLayoutData((Object)dContents);
    }

    private void addWorkbenchSelectionListener() {
        ISelectionService selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        selectionService.addPostSelectionListener(this.workbenchSelectionListener);
    }

    private void addPageListener() {
        this.activePartListener = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == TableView.this) {
                    TableView.this.deactivate();
                }
            }

            public void partVisible(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == TableView.this) {
                    TableView.this.activate();
                }
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }
        };
        this.page.addPartListener(this.activePartListener);
    }

    protected void activate() {
        if (this.active) {
            return;
        }
        PlatformGIS.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                SelectPlugin.log("error activating table", exception);
            }

            public void run() throws Exception {
                TableView.this.active = true;
                if (TableView.this.reloadNeeded) {
                    TableView.this.reloadFeatures((ILayer)TableView.this.layer);
                }
                if (!TableView.this.updates.isEmpty()) {
                    TableView.this.updateTable((ILayer)TableView.this.layer);
                }
                if (TableView.this.filterChange) {
                    TableView.this.updateSelection((ILayer)TableView.this.layer);
                }
            }
        });
    }

    protected void deactivate() {
        this.active = false;
    }

    private void hookGlobalActions() {
        ApplicationGIS.getToolManager().contributeGlobalActions((IWorkbenchPart)this, this.getViewSite().getActionBars());
        IKeyBindingService service = this.getSite().getKeyBindingService();
        IAction action = this.deleteAction;
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), action);
        service.registerAction(action);
    }

    private void createActions() {
        this.select = ApplicationGIS.getToolManager().createToolAction("net.refractions.udig.tools.BBoxSelect", "net.refractions.udig.tool.category.selection");
        ImageDescriptor icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.refractions.udig.tool.select", (String)"icons/eview16/select_view.gif");
        this.select.setImageDescriptor(icon);
        this.promoteSelection = new PromoteSelectionAction();
        this.zoom = ((ToolManager)ApplicationGIS.getToolManager()).createToolAction("net.refractions.udig.tool.default.show.selection", "net.refractions.udig.tool.category.zoom");
        icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.refractions.udig.tool.select", (String)"icons/elcl16/zoom_select_co.png");
        this.zoom.setImageDescriptor(icon);
        this.zoom.setText(Messages.TableView_zoomToolText);
        this.zoom.setToolTipText(Messages.TableView_zoomToolToolTip);
        this.deleteAction = new DeleteAction();
    }

    void layerSelected(ILayer selected) {
        if (this.layer == selected) {
            return;
        }
        if (this.layer != null) {
            this.layer.removeListener(this.layerListener);
            if (this.layer.getMap() != null) {
                this.layer.getMap().removeMapCompositionListener(this.compositionListener);
                this.layer.getMap().getEditManager().removeListener(this.editManagerListener);
            }
        }
        if (selected == null || !selected.hasResource(FeatureSource.class) || selected.getMap() == null) {
            if (this.currentEditor != null) {
                this.currentEditor.getMap().getEditManager().addListener(this.editManagerListener);
            }
            this.layer = null;
            this.filterChange = false;
            this.reloadNeeded = false;
            this.table.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TableView.this.table.clear();
                    TableView.this.table.message(Messages.TableView_noFeatureWarning);
                }
            });
            return;
        }
        this.layer = (Layer)selected;
        this.layer.addListener(this.layerListener);
        this.layer.getMap().addMapCompositionListener(this.compositionListener);
        this.layer.getMap().getEditManager().addListener(this.editManagerListener);
        if (!this.active) {
            this.filterChange = true;
            this.reloadNeeded = true;
            return;
        }
        this.setZoomToSelectionToolEnablement();
        this.reloadFeatures((ILayer)this.layer);
        this.updateSelection((ILayer)this.layer);
    }

    private void setZoomToSelectionToolEnablement() {
        final boolean enabled = this.layer.getMap() == ApplicationGIS.getActiveMap() && this.layer.getFilter() != Filter.EXCLUDE;
        this.table.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TableView.this.zoom.setEnabled(enabled);
            }
        });
    }

    protected void editorActivated(MapPart editor) {
        if (this.currentEditor == editor) {
            return;
        }
        this.currentEditor = editor;
        if (editor == null) {
            this.select.setEnabled(false);
            this.table.clear();
            this.table.update();
            return;
        }
        Map map = this.currentEditor.getMap();
        final ILayer selectedLayer = map.getEditManager().getSelectedLayer();
        if (selectedLayer == null && this.layer == null) {
            map.getEditManager().addListener(this.editManagerListener);
            return;
        }
        PlatformGIS.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                SelectPlugin.log("error selecting layer", exception);
            }

            public void run() throws Exception {
                TableView.this.layerSelected(selectedLayer);
            }
        });
        if (selectedLayer != null) {
            this.select.setEnabled(true);
        }
    }

    private void createToolbar() {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        toolbar.add(this.select);
        toolbar.add(this.zoom);
        toolbar.add((IAction)this.promoteSelection);
    }

    private void createContextMenu() {
        this.contextMenu = new MenuManager();
        this.contextMenu.setRemoveAllWhenShown(true);
        this.contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                TableView.this.contextMenu.add(TableView.this.deleteAction);
                TableView.this.contextMenu.add(TableView.this.zoom);
                TableView.this.contextMenu.add((IAction)TableView.this.promoteSelection);
                TableView.this.contextMenu.add((IContributionItem)new GroupMarker("additions"));
                TableView.this.contextMenu.add((IContributionItem)ApplicationGIS.getToolManager().createOperationsContextMenu(TableView.this.getSelection()));
                TableView.this.contextMenu.add((IAction)ActionFactory.EXPORT.create(TableView.this.getSite().getWorkbenchWindow()));
            }
        });
        this.table.setMenuManager(this.contextMenu);
        this.getSite().registerContextMenu(this.contextMenu, (ISelectionProvider)this);
    }

    private void createMenu() {
    }

    public void setFocus() {
        this.hookGlobalActions();
        if (this.table.getControl() != null) {
            this.table.getControl().setFocus();
        }
    }

    public void dispose() {
        if (this.table != null) {
            this.table.dispose();
        }
        if (this.aoiServiceListener != null) {
            IAOIService aOIService = PlatformGIS.getAOIService();
            aOIService.removeListener(this.aoiServiceListener);
        }
        super.dispose();
        if (this.activePartListener != null) {
            this.page.removePartListener(this.activePartListener);
        }
        if (this.workbenchSelectionListener != null) {
            ISelectionService selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
            selectionService.removePostSelectionListener(this.workbenchSelectionListener);
        }
        if (this.layer != null && this.layerListener != null) {
            this.layer.removeListener(this.layerListener);
        }
        this.table = null;
        this.activePartListener = null;
        this.workbenchSelectionListener = null;
        this.layer = null;
        this.layerListener = null;
    }

    protected void updateSelection(final ILayer notifierLayer) {
        if (!this.active) {
            this.filterChange = true;
            return;
        }
        if (this.updatingLayerFilter) {
            return;
        }
        try {
            final FeatureSource featureSource = (FeatureSource)notifierLayer.getResource(FeatureSource.class, null);
            this.filterChange = false;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TableView.this.updatingSelection = true;
                    if (TableView.this.updatingLayerFilter) {
                        return;
                    }
                    Filter filter = notifierLayer.getFilter();
                    if (filter == Filter.EXCLUDE) {
                        TableView.this.table.setSelection((ISelection)new StructuredSelection());
                        return;
                    }
                    AdaptingFilter adaptingFilter = AdaptingFilterFactory.createAdaptingFilter((Filter)filter);
                    adaptingFilter.addAdapter((Object)featureSource);
                    StructuredSelection selection = new StructuredSelection((Object)adaptingFilter);
                    TableView.this.table.setSelection((ISelection)selection);
                }
            });
        }
        catch (IOException e) {
            SelectPlugin.log("", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTable(ILayer notifierLayer) {
        try {
            FeatureCollection features;
            BBOX bboxFilter;
            String srs;
            double maxy;
            double maxx;
            double miny;
            double minx;
            Envelope addedBounds = null;
            Envelope modifiedBounds = null;
            List<FeatureEvent> list = this.updates;
            synchronized (list) {
                for (FeatureEvent event : this.updates) {
                    ReferencedEnvelope bounds = event.getBounds();
                    switch (event.getEventType()) {
                        case 1: {
                            if (bounds == null) break;
                            if (addedBounds == null) {
                                addedBounds = new Envelope((Envelope)bounds);
                                break;
                            }
                            addedBounds.expandToInclude((Envelope)bounds);
                            break;
                        }
                        case -1: {
                            this.reloadNeeded = true;
                            if (this.active) {
                                this.reloadFeatures(notifierLayer);
                            }
                            return;
                        }
                        case 0: {
                            if (event.getBounds() == null) {
                                return;
                            }
                            if (modifiedBounds == null) {
                                modifiedBounds = new Envelope((Envelope)bounds);
                                break;
                            }
                            modifiedBounds.expandToInclude((Envelope)bounds);
                            break;
                        }
                    }
                }
                this.updates.clear();
            }
            if (addedBounds == null && modifiedBounds == null) {
                if (this.active) {
                    this.reloadFeatures(notifierLayer);
                } else {
                    this.reloadNeeded = true;
                }
                return;
            }
            FeatureSource source = (FeatureSource)notifierLayer.getResource(FeatureSource.class, ProgressManager.instance().get(new Object[0]));
            SimpleFeatureType schema = (SimpleFeatureType)source.getSchema();
            FilterFactory fac = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
            List<String> queryAtts = this.obtainQueryAttributesForFeatureTable(schema);
            DefaultQuery query = new DefaultQuery(schema.getName().getLocalPart(), (Filter)Filter.EXCLUDE, queryAtts.toArray(new String[0]));
            String name = schema.getGeometryDescriptor().getName().getLocalPart();
            if (addedBounds != null) {
                minx = addedBounds.getMinX();
                miny = addedBounds.getMinY();
                maxx = addedBounds.getMaxX();
                maxy = addedBounds.getMaxY();
                srs = CRS.lookupIdentifier((IdentifiedObject)schema.getCoordinateReferenceSystem(), (boolean)false);
                bboxFilter = fac.bbox(name, minx, miny, maxx, maxy, srs);
                query.setFilter((Filter)bboxFilter);
                features = source.getFeatures((Query)query);
                this.table.update(features);
            }
            if (modifiedBounds != null) {
                minx = modifiedBounds.getMinX();
                miny = modifiedBounds.getMinY();
                maxx = modifiedBounds.getMaxX();
                maxy = modifiedBounds.getMaxY();
                srs = CRS.lookupIdentifier((IdentifiedObject)schema.getCoordinateReferenceSystem(), (boolean)false);
                bboxFilter = fac.bbox(name, minx, miny, maxx, maxy, srs);
                query.setFilter((Filter)bboxFilter);
                features = source.getFeatures((Query)query);
                this.table.update(features);
            }
        }
        catch (IOException iOException) {
            if (this.active) {
                this.reloadFeatures(notifierLayer);
            } else {
                this.reloadNeeded = true;
            }
        }
        catch (IllegalFilterException illegalFilterException) {
            if (this.active) {
                this.reloadFeatures(notifierLayer);
            } else {
                this.reloadNeeded = true;
            }
        }
        catch (FactoryException factoryException) {
            if (this.active) {
                this.reloadFeatures(notifierLayer);
            }
            this.reloadNeeded = true;
        }
    }

    private Filter addAOIFilter(Filter filter, CoordinateReferenceSystem dataCRS) {
        IAOIService aOIService = PlatformGIS.getAOIService();
        Geometry geometry = aOIService.getGeometry();
        if (aOIService.getExtent() == null) {
            return filter;
        }
        if (geometry == null && (geometry = JTS.toGeometry((ReferencedEnvelope)aOIService.getExtent())) == null) {
            return filter;
        }
        CoordinateReferenceSystem aoiCRS = aOIService.getCrs();
        if (aoiCRS != null && !CRS.equalsIgnoreMetadata((Object)aoiCRS, (Object)dataCRS)) {
            try {
                MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)aoiCRS, (CoordinateReferenceSystem)dataCRS);
                geometry = JTS.transform((Geometry)geometry, (MathTransform)transform);
            }
            catch (TransformException transformException) {
                return filter;
            }
            catch (FactoryException factoryException) {
                return filter;
            }
        }
        FilterFactory2 ff = (FilterFactory2)CommonFactoryFinder.getFilterFactory(null);
        String geomProperty = this.layer.getSchema().getGeometryDescriptor().getLocalName();
        Intersects aoiFilter = ff.intersects((Expression)ff.property(geomProperty), (Expression)ff.literal((Object)geometry));
        return ff.and((Filter)aoiFilter, filter);
    }

    protected void reloadFeatures(ILayer notifierLayer) {
        try {
            FeatureCollection featuresF;
            this.reloadNeeded = false;
            this.updates.clear();
            final FeatureTypeCellModifier featureTypeCellModifier = new FeatureTypeCellModifier(notifierLayer){

                @Override
                public Object getValue(Object element, String property) {
                    ApplicationGIS.getToolManager().unregisterActions((IWorkbenchPart)TableView.this);
                    return super.getValue(element, property);
                }

                @Override
                protected void makeModification(SimpleFeature feature, ILayer layer, String property, Object value, Item item) {
                    if (value == null) {
                        return;
                    }
                    TableItem tableItem = (TableItem)item;
                    Schema schema = new Schema();
                    int columnIndex = schema.getIndexOf(feature.getFeatureType(), property);
                    tableItem.setText(columnIndex + 1, value.toString());
                    UndoableComposite composite = new UndoableComposite();
                    composite.getCommands().add(new SetEditingFlag(true));
                    composite.getCommands().add(EditCommandFactory.getInstance().createSetAttributeCommand(feature, layer, property, value));
                    composite.getFinalizerCommands().add(new SetEditingFlag(false));
                    layer.getMap().sendCommandASync((MapCommand)composite);
                }
            };
            SimpleFeatureType schema = notifierLayer.getSchema();
            IncludeFilter filter = Filter.INCLUDE;
            final FeatureSource featureSource = (FeatureSource)notifierLayer.getResource(FeatureSource.class, null);
            final List<String> queryAtts = this.obtainQueryAttributesForFeatureTable(schema);
            if (this.isAOIFilter()) {
                filter = this.addAOIFilter((Filter)filter, schema.getCoordinateReferenceSystem());
            }
            DefaultQuery query = new DefaultQuery(schema.getName().getLocalPart(), (Filter)filter, queryAtts.toArray(new String[0]));
            final FeatureCollection features = featuresF = featureSource.getFeatures((Query)query);
            Display.getDefault().asyncExec(new Runnable((Query)query){
                private final /* synthetic */ Query val$query;
                {
                    this.val$query = query;
                }

                @Override
                public void run() {
                    if (!TableView.this.table.showWarning(TableView.this.table.getControl().getDisplay())) {
                        return;
                    }
                    queryAtts.add(0, ANY);
                    queryAtts.add(TableView.CQL);
                    TableView.this.attributeCombo.setItems(queryAtts.toArray(new String[0]));
                    TableView.this.attributeCombo.select(0);
                    AdaptableFeatureCollection adaptableCollection = new AdaptableFeatureCollection((FeatureCollection<SimpleFeatureType, SimpleFeature>)features);
                    if (featureSource instanceof FeatureStore) {
                        this.enableEditing(featureTypeCellModifier, this.val$query, adaptableCollection);
                    }
                    TableView.this.table.setFeatures((FeatureCollection)adaptableCollection);
                }

                private void enableEditing(FeatureTypeCellModifier featureTypeCellModifier2, Query query, AdaptableFeatureCollection adaptableCollection) {
                    adaptableCollection.addAdapter(featureTypeCellModifier2);
                    ICellEditorListener[] keyBindingActivators = new ICellEditorListener[query.getPropertyNames().length];
                    int i = 0;
                    while (i < keyBindingActivators.length) {
                        keyBindingActivators[i] = new ICellEditorListener(){

                            public void applyEditorValue() {
                                ApplicationGIS.getToolManager().registerActionsWithPart((IWorkbenchPart)TableView.this);
                            }

                            public void cancelEditor() {
                                this.applyEditorValue();
                            }

                            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                            }
                        };
                        ++i;
                    }
                    adaptableCollection.addAdapter(keyBindingActivators);
                }
            });
        }
        catch (IOException e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TableView.this.table.message(e.getMessage());
                }
            });
        }
    }

    private List<String> obtainQueryAttributesForFeatureTable(SimpleFeatureType schema) {
        ArrayList<String> queryAtts = new ArrayList<String>();
        int i = 0;
        while (i < schema.getAttributeCount()) {
            AttributeDescriptor attr = schema.getDescriptor(i);
            if (!(attr instanceof GeometryDescriptor)) {
                queryAtts.add(attr.getName().getLocalPart());
            }
            ++i;
        }
        return queryAtts;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangeListeners.add(listener);
    }

    public ISelection getSelection() {
        Id firstElement = this.getFilter();
        if (firstElement == null) {
            return new StructuredSelection();
        }
        AdaptingFilter filter = AdaptingFilterFactory.createAdaptingFilter((Filter)firstElement, (Object)this.layer);
        if (this.layer.getGeoResource().canResolve(FeatureSource.class)) {
            try {
                FeatureSource resolve = (FeatureSource)this.layer.getGeoResource().resolve(FeatureSource.class, null);
                FeatureCollection features = resolve.getFeatures((Filter)filter);
                filter.addAdapter((Object)features);
            }
            catch (IOException e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
        }
        return new StructuredSelection((Object)filter);
    }

    private Id getFilter() {
        IStructuredSelection selection = (IStructuredSelection)this.table.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        Id firstElement = (Id)selection.getFirstElement();
        return firstElement;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangeListeners.remove(listener);
    }

    protected void fireSelectionChanged() {
        final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Iterator<ISelectionChangedListener> iterator = this.selectionChangeListeners.iterator();
        while (iterator.hasNext()) {
            ISelectionChangedListener listener;
            final ISelectionChangedListener l = listener = iterator.next();
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
        }
    }

    public void setSelection(ISelection selection) {
        this.table.setSelection(selection);
    }

    public void editFeatureChanged(SimpleFeature feature) {
        if (feature == null) {
            return;
        }
        if (this.getContext().getEditManager().getSelectedLayer() != this.layer || this.updatingLayerFilter) {
            return;
        }
        if (this.table.getSelectionCount() == 1 && this.getFilter().getIDs().toArray(new String[0])[0].equals(feature.getID())) {
            return;
        }
        this.updatingLayerFilter = true;
        try {
            StructuredSelection structuredSelection = new StructuredSelection((Object)feature);
            this.setSelection((ISelection)structuredSelection);
        }
        finally {
            this.updatingLayerFilter = false;
        }
    }

    public IToolContext getContext() {
        return this.currentContext;
    }

    public void setContext(IToolContext newContext) {
        this.currentContext = newContext;
    }

    private class DeleteAction
    extends Action {
        public DeleteAction() {
            this.setActionDefinitionId("org.eclipse.ui.edit.delete");
            ActionFactory.IWorkbenchAction actionTemplate = ActionFactory.DELETE.create(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            this.setText(actionTemplate.getText());
            this.setToolTipText(actionTemplate.getToolTipText());
            this.setImageDescriptor(actionTemplate.getImageDescriptor());
            this.setDescription(actionTemplate.getDescription());
            this.setDisabledImageDescriptor(actionTemplate.getDisabledImageDescriptor());
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)TableView.this.table.getSelection();
            if (selection == null || selection.isEmpty() || TableView.this.table.getSelectionCount() == 0) {
                return;
            }
            Id filter = (Id)selection.getFirstElement();
            CompositeCommand composite = TableView.this.table.getSelectionCount() == 1 ? this.deleteFeature() : this.deleteManyFeatures(filter);
            TableView.this.layer.getMap().sendCommandASync((MapCommand)composite);
        }

        private CompositeCommand deleteFeature() {
            CompositeCommand composite = new CompositeCommand();
            composite.setName(Messages.TableView_compositeName);
            composite.getCommands().add(new SetEditingFlag(true));
            DeleteFromTableCommand deleteFromTableCommand = new DeleteFromTableCommand(TableView.this.layer);
            composite.getCommands().add(deleteFromTableCommand);
            StaticBlockingProvider layerProvider = new StaticBlockingProvider((Object)TableView.this.layer);
            composite.getCommands().add(new DeleteFeatureCommand((IBlockingProvider)deleteFromTableCommand, (IBlockingProvider)layerProvider));
            composite.getFinalizerCommands().add(new SetEditingFlag(false));
            return composite;
        }

        private CompositeCommand deleteManyFeatures(Id filter) {
            CompositeCommand composite = new CompositeCommand();
            composite.setName(Messages.TableView_compositeName);
            composite.getCommands().add(new SetEditingFlag(true));
            composite.getCommands().add(new DeleteManyFeaturesCommand((ILayer)TableView.this.layer, (Filter)filter));
            composite.getCommands().add(new DeleteFromTableCommand(TableView.this.layer));
            composite.getFinalizerCommands().add(new SetEditingFlag(false));
            return composite;
        }
    }

    private class DeleteFromTableCommand
    extends AbstractCommand
    implements UndoableCommand,
    IBlockingProvider<SimpleFeature> {
        private FeatureCollection<SimpleFeatureType, SimpleFeature> deletedFeatures;
        private Layer layer;

        public DeleteFromTableCommand(Layer layer) {
            this.layer = layer;
        }

        public void rollback(IProgressMonitor monitor) throws Exception {
            TableView.this.table.update(this.deletedFeatures);
        }

        public String getName() {
            return Messages.TableView_deleteCommandName;
        }

        public void run(IProgressMonitor monitor) throws Exception {
            this.deletedFeatures = TableView.this.table.deleteSelection();
        }

        public SimpleFeature get(IProgressMonitor monitor, Object ... params) throws IOException {
            StaticBlockingProvider layerProvider = new StaticBlockingProvider((Object)this.layer);
            String featureID = ((SimpleFeature)this.deletedFeatures.features().next()).getID();
            FIDFeatureProvider featureProvider = new FIDFeatureProvider(featureID, (IBlockingProvider)layerProvider);
            return (SimpleFeature)featureProvider.get(monitor, new Object[0]);
        }
    }

    private class PromoteSelectionAction
    extends Action {
        public PromoteSelectionAction() {
            this.setText(Messages.TableView_promote_text);
            this.setToolTipText(Messages.TableView_promote_tooltip);
            this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.refractions.udig.tool.select", (String)"icons/elcl16/promote_selection_co.gif"));
        }

        public void run() {
            TableView.this.table.promoteSelection();
        }
    }

    private class SearchBox
    extends AbstractHandler
    implements Listener {
        private Color systemColor;

        private SearchBox() {
        }

        public void handleEvent(Event e) {
            if (e.keyCode == 13 || e.keyCode == 10) {
                this.doSearch();
            }
        }

        public Text createPart(Composite parent) {
            final Text searchWidget = new Text(parent, 2432);
            searchWidget.setEnabled(false);
            this.systemColor = searchWidget.getDisplay().getSystemColor(16);
            searchWidget.setText(INITIAL_TEXT);
            searchWidget.setForeground(this.systemColor);
            searchWidget.setEditable(true);
            searchWidget.addListener(15, new Listener(){

                public void handleEvent(Event e) {
                    if (searchWidget.getForeground().equals((Object)SearchBox.this.systemColor)) {
                        searchWidget.setForeground(e.display.getSystemColor(2));
                        searchWidget.setText("");
                    }
                    ApplicationGIS.getToolManager().unregisterActions((IWorkbenchPart)TableView.this);
                }
            });
            searchWidget.addListener(16, new Listener(){

                public void handleEvent(Event e) {
                    if (!searchWidget.getForeground().equals((Object)SearchBox.this.systemColor) && searchWidget.getText().trim().length() == 0) {
                        searchWidget.setForeground(SearchBox.this.systemColor);
                        searchWidget.setText("");
                    }
                    ApplicationGIS.getToolManager().registerActionsWithPart((IWorkbenchPart)TableView.this);
                }
            });
            searchWidget.addListener(2, (Listener)this);
            return searchWidget;
        }

        public Object execute(ExecutionEvent arg0) throws ExecutionException {
            this.doSearch();
            return null;
        }

        private void doSearch() {
            if (TableView.this.searchWidget.getText().trim().length() == 0) {
                TableView.this.searchWidget.setText(INITIAL_TEXT);
                TableView.this.searchWidget.setForeground(this.systemColor);
            }
            String item = TableView.this.attributeCombo.getItem(TableView.this.attributeCombo.getSelectionIndex());
            boolean selectAll = TableView.this.selectAllCheck.getSelection();
            if (item.equals(TableView.CQL)) {
                try {
                    String txt = TableView.this.searchWidget.getText().trim();
                    Filter filter = org.geotools.filter.text.cql2.CQL.toFilter((String)txt);
                    FeatureSource source = (FeatureSource)TableView.this.layer.getResource(FeatureSource.class, ProgressManager.instance().get(new Object[0]));
                    SimpleFeatureType schema = (SimpleFeatureType)source.getSchema();
                    Set required = (Set)filter.accept((FilterVisitor)new FilterAttributeExtractor(), null);
                    String[] names = required.toArray(new String[required.size()]);
                    DefaultQuery query = new DefaultQuery(schema.getName().getLocalPart(), filter, names);
                    FeatureCollection features = source.getFeatures((Query)query);
                    final HashSet selection = new HashSet();
                    features.accepts(new FeatureVisitor(){

                        public void visit(Feature feature) {
                            FeatureId identifier = feature.getIdentifier();
                            selection.add(identifier);
                        }
                    }, null);
                    TableView.this.table.select(selection);
                }
                catch (Exception e) {
                    Status status = new Status(2, "net.refractions.udig.ui", e.getLocalizedMessage(), (Throwable)e);
                    UIPlugin.getDefault().getLog().log((IStatus)status);
                    TableView.this.searchWidget.setToolTipText(e.getLocalizedMessage());
                }
            } else {
                String[] attsToSearch = item.equals(ANY) ? FeatureTableControl.ALL : new String[]{item};
                TableView.this.table.select(TableView.this.searchWidget.getText().trim(), attsToSearch, selectAll);
            }
        }
    }

    private class SetEditingFlag
    extends AbstractCommand
    implements UndoableCommand {
        boolean oldState;
        final boolean newState;

        public SetEditingFlag(boolean newState) {
            this.newState = newState;
        }

        public void rollback(IProgressMonitor monitor) throws Exception {
            TableView.this.editing = this.oldState;
        }

        public String getName() {
            return "Set Editing Flag";
        }

        public void run(IProgressMonitor monitor) throws Exception {
            this.oldState = TableView.this.editing;
            TableView.this.editing = this.newState;
        }
    }
}

