/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tool.select;

import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.command.factory.EditCommandFactory;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.Item;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class FeatureTypeCellModifier
implements ICellModifier {
    private final IMap map;
    private final SimpleFeatureType schema;
    private ILayer layer;

    public FeatureTypeCellModifier(ILayer layer) {
        this.map = layer.getMap();
        this.schema = layer.getSchema();
        this.layer = layer;
    }

    public boolean canModify(Object element, String property) {
        return this.schema.indexOf(property) != -1;
    }

    public Object getValue(Object element, String property) {
        Object attribute = ((SimpleFeature)element).getAttribute(property);
        return attribute;
    }

    public void modify(Object element, String property, Object value) {
        Item item = (Item)element;
        SimpleFeature feature = (SimpleFeature)item.getData();
        Object oldValue = feature.getAttribute(property);
        if (oldValue == null) {
            if (value == null) {
                return;
            }
            this.makeModification(feature, this.layer, property, value, item);
        } else if (!oldValue.equals(value)) {
            this.makeModification(feature, this.layer, property, value, item);
        }
    }

    protected void makeModification(SimpleFeature feature, ILayer layer, String property, Object value, Item item) {
        UndoableMapCommand c = EditCommandFactory.getInstance().createSetAttributeCommand(feature, layer, property, value);
        this.map.sendCommandASync((MapCommand)c);
    }
}

