/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.core.opengis;

import org.eclipse.core.runtime.IProgressMonitor;
import org.opengis.util.InternationalString;
import org.opengis.util.ProgressListener;

public class ProgressListenerAdaptor
implements ProgressListener {
    private String description;
    private int progress;
    private InternationalString task;
    private IProgressMonitor monitor;

    public ProgressListenerAdaptor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void complete() {
        this.monitor.done();
    }

    public void dispose() {
        this.description = null;
    }

    public void exceptionOccurred(Throwable arg0) {
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isCanceled() {
        return this.monitor.isCanceled();
    }

    public void progress(float amount) {
        int current = (int)(100.0 * (double)amount);
        this.monitor.worked(current - this.progress);
        this.progress = current;
    }

    public void setCanceled(boolean arg0) {
        this.monitor.setCanceled(true);
    }

    public void setDescription(String text) {
        this.description = text;
    }

    public void started() {
        this.monitor.beginTask(this.description, 100);
    }

    public void warningOccurred(String arg0, String arg1, String arg2) {
    }

    public InternationalString getTask() {
        return this.task;
    }

    public void setTask(InternationalString task) {
        this.task = task;
    }

    public float getProgress() {
        return this.progress;
    }
}

