/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.core.jts;

import com.google.common.base.ReferenceType;
import com.google.common.collect.ReferenceMap;
import java.util.Collection;
import java.util.Map;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.Geometry;
import org.opengis.metadata.extent.BoundingPolygon;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ReferencedEnvelopeCache {
    private static Map<ReferenceIdentifier, ReferencedEnvelope> crsCache;

    private static synchronized Map<ReferenceIdentifier, ReferencedEnvelope> getCache() {
        if (crsCache == null) {
            ReferenceMap content;
            crsCache = content = new ReferenceMap(ReferenceType.STRONG, ReferenceType.WEAK);
        }
        return crsCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReferencedEnvelope getReferencedEnvelope(CoordinateReferenceSystem crs) {
        if (crs == null) {
            return new ReferencedEnvelope();
        }
        try {
            Map<ReferenceIdentifier, ReferencedEnvelope> map;
            Map<ReferenceIdentifier, ReferencedEnvelope> map2 = map = ReferencedEnvelopeCache.getCache();
            synchronized (map2) {
                ReferencedEnvelope envelope = map.get(crs.getName());
                if (envelope == null) {
                    envelope = ReferencedEnvelopeCache.getCRSBounds(crs);
                    map.put(crs.getName(), envelope);
                }
                return envelope;
            }
        }
        catch (Throwable throwable) {
            return new ReferencedEnvelope();
        }
    }

    private static ReferencedEnvelope getCRSBounds(CoordinateReferenceSystem crs) {
        if (crs == null) {
            return new ReferencedEnvelope();
        }
        try {
            Extent extent = crs.getDomainOfValidity();
            Collection elem = extent.getGeographicElements();
            double xmin = Double.MAX_VALUE;
            double ymin = Double.MAX_VALUE;
            double xmax = Double.MIN_VALUE;
            double ymax = Double.MIN_VALUE;
            for (GeographicExtent ext : elem) {
                if (ext instanceof BoundingPolygon) {
                    BoundingPolygon bp = (BoundingPolygon)ext;
                    Collection geoms = bp.getPolygons();
                    for (Geometry geom : geoms) {
                        Envelope env = geom.getEnvelope();
                        if (env.getMinimum(0) < xmin) {
                            xmin = env.getMinimum(0);
                        }
                        if (env.getMaximum(0) > xmax) {
                            xmax = env.getMaximum(0);
                        }
                        if (env.getMinimum(1) < ymin) {
                            ymin = env.getMinimum(1);
                        }
                        if (!(env.getMaximum(1) > ymax)) continue;
                        ymax = env.getMaximum(1);
                    }
                    continue;
                }
                if (!(ext instanceof GeographicBoundingBox)) continue;
                GeographicBoundingBox gbb = (GeographicBoundingBox)ext;
                ReferencedEnvelope env = new ReferencedEnvelope((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                env.expandToInclude(gbb.getWestBoundLongitude(), gbb.getNorthBoundLatitude());
                env.expandToInclude(gbb.getEastBoundLongitude(), gbb.getSouthBoundLatitude());
                env = env.transform(crs, true);
                if (env.getMinX() < xmin) {
                    xmin = env.getMinX();
                }
                if (env.getMaxX() > xmax) {
                    xmax = env.getMaxX();
                }
                if (env.getMinY() < ymin) {
                    ymin = env.getMinY();
                }
                if (!(env.getMaxY() > ymax)) continue;
                ymax = env.getMaxY();
            }
            if (xmin == Double.MAX_VALUE || ymin == Double.MAX_VALUE || xmax == Double.MIN_VALUE || ymax == Double.MAX_VALUE) {
                return new ReferencedEnvelope(crs);
            }
            return new ReferencedEnvelope(xmin, xmax, ymin, ymax, crs);
        }
        catch (Throwable throwable) {
            return new ReferencedEnvelope(crs);
        }
    }
}

