/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.core.internal;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;

public class GeometryBuilder {
    public GeometryFactory factory = new GeometryFactory();

    private GeometryBuilder() {
    }

    public static GeometryBuilder create() {
        return new GeometryBuilder();
    }

    public Geometry createGeometry(Class type, Coordinate[] coords) {
        if (LinearRing.class.isAssignableFrom(type)) {
            return this.factory.createLinearRing(coords);
        }
        if (LineString.class.isAssignableFrom(type)) {
            return this.factory.createLineString(coords);
        }
        return null;
    }

    public <T extends Geometry> T safeCreateGeometry(Class<T> type, Coordinate[] coords) {
        if (LinearRing.class.isAssignableFrom(type)) {
            LinearRing ring = this.safeCreateLinearRing(coords);
            return (T)((Geometry)type.cast(ring));
        }
        if (LineString.class.isAssignableFrom(type)) {
            if (coords.length < 2) {
                Coordinate[] tmp = new Coordinate[2];
                System.arraycopy(coords, 0, tmp, 0, coords.length);
                int i = coords.length;
                while (i < tmp.length) {
                    tmp[i] = new Coordinate(coords[coords.length - 1]);
                    ++i;
                }
                coords = tmp;
            }
            return (T)((Geometry)type.cast(this.factory.createLineString(coords)));
        }
        if (Coordinate.class.isAssignableFrom(type)) {
            return (T)((Geometry)type.cast(this.factory.createPoint(coords[0])));
        }
        if (Point.class.isAssignableFrom(type)) {
            return (T)((Geometry)type.cast(this.factory.createPoint(coords[0])));
        }
        if (MultiPoint.class.isAssignableFrom(type)) {
            return (T)((Geometry)type.cast(this.factory.createMultiPoint(coords)));
        }
        if (Polygon.class.isAssignableFrom(type)) {
            return (T)((Geometry)type.cast(this.factory.createPolygon(this.safeCreateGeometry(LinearRing.class, coords), new LinearRing[0])));
        }
        if (MultiPolygon.class.isAssignableFrom(type)) {
            return (T)((Geometry)type.cast(this.factory.createMultiPolygon(new Polygon[]{this.safeCreateGeometry(Polygon.class, coords)})));
        }
        if (MultiLineString.class.isAssignableFrom(type)) {
            return (T)((Geometry)type.cast(this.factory.createMultiLineString(new LineString[]{this.safeCreateGeometry(LineString.class, coords)})));
        }
        return null;
    }

    public LinearRing safeCreateLinearRing(Coordinate[] coords) {
        Coordinate[] tmp;
        if (coords.length < 4) {
            tmp = new Coordinate[4];
            System.arraycopy(coords, 0, tmp, 0, coords.length);
            int i = coords.length;
            while (i < tmp.length) {
                tmp[i] = new Coordinate(coords[0]);
                ++i;
            }
            coords = tmp;
        }
        if (!coords[0].equals((Object)coords[coords.length - 1])) {
            tmp = new Coordinate[coords.length + 1];
            System.arraycopy(coords, 0, tmp, 0, coords.length);
            tmp[tmp.length - 1] = tmp[0];
            coords = tmp;
        }
        return this.factory.createLinearRing(coords);
    }
}

