/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.core.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.refractions.udig.core.internal.CorePlugin;
import net.refractions.udig.core.internal.Messages;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class ExtensionPointList
extends ArrayList<IConfigurationElement> {
    private static final long serialVersionUID = ExtensionPointList.class.hashCode();
    private static Map<String, List<IConfigurationElement>> cache = new WeakHashMap<String, List<IConfigurationElement>>();

    private ExtensionPointList(String xpid) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(xpid);
        if (extensionPoint == null) {
            return;
        }
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            try {
                this.addAll(Arrays.asList(extension.getConfigurationElements()));
            }
            catch (Exception e) {
                Bundle bundle = Platform.getBundle((String)extensionPoint.getNamespaceIdentifier());
                if (bundle == null) {
                    if (CorePlugin.getDefault().isDebugging()) {
                        System.out.println("Could not locate bundle for " + extensionPoint.getUniqueIdentifier());
                    }
                    bundle = CorePlugin.getDefault().getBundle();
                }
                ILog log = Platform.getLog((Bundle)bundle);
                log.log((IStatus)new Status(4, extension.getNamespaceIdentifier(), 0, String.valueOf(extensionPoint.getUniqueIdentifier()) + Messages.ExtensionPointList_problem + e, (Throwable)e));
            }
            ++n2;
        }
    }

    public static List<IConfigurationElement> getExtensionPointList(String extensionPointId) {
        ArrayList list = cache.get(extensionPointId);
        if (list == null) {
            list = new ExtensionPointList(extensionPointId);
            cache.put(extensionPointId, list);
        }
        list = new ArrayList<IConfigurationElement>(list);
        return list;
    }
}

