/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.core.filter;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.runtime.IAdaptable;
import org.geotools.filter.text.cql2.CQL;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;

public class AdaptingFilter<F extends Filter>
implements Filter,
IAdaptable {
    protected F wrapped;
    protected Set<Object> adapters = new CopyOnWriteArraySet<Object>();

    AdaptingFilter(F filter) {
        if (filter == null) {
            throw new NullPointerException("filterA cannot be null");
        }
        this.wrapped = filter;
    }

    public Object getAdapter(Class adapter) {
        for (Object obj : this.adapters) {
            if (!adapter.isAssignableFrom(obj.getClass())) continue;
            return obj;
        }
        if (Filter.class.isAssignableFrom(adapter)) {
            return this.wrapped;
        }
        return null;
    }

    public void addAdapter(Object adapter) {
        if (adapter == null) {
            throw new NullPointerException("adapter cannont be null");
        }
        this.adapters.add(adapter);
    }

    public boolean removeAdapter(Object adapter) {
        if (adapter == null) {
            throw new NullPointerException("adapter cannont be null");
        }
        return this.adapters.remove(adapter);
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return this.wrapped.accept(visitor, extraData);
    }

    public boolean evaluate(Object object) {
        return this.wrapped.evaluate(object);
    }

    public String toString() {
        return "Adapting:" + CQL.toCQL(this.wrapped);
    }
}

