/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.core;

import java.util.NoSuchElementException;
import org.opengis.feature.simple.SimpleFeature;

public abstract class Option<T> {
    public static final Option NONE = new None();

    private Option() {
    }

    public boolean isDefined() {
        return false;
    }

    public T value() {
        throw new NoSuchElementException();
    }

    public boolean isNone() {
        return !this.isDefined();
    }

    public static <V> None<V> none() {
        return (None)NONE;
    }

    public static Option<SimpleFeature> some(SimpleFeature next) {
        return new Some<SimpleFeature>(next);
    }

    /* synthetic */ Option(Option option) {
        this();
    }

    private static final class None<V>
    extends Option<V> {
        private None() {
            super(null);
        }
    }

    public static final class Some<V>
    extends Option<V> {
        private V value;

        public Some(V value) {
            super(null);
            this.value = value;
        }

        @Override
        public boolean isDefined() {
            return true;
        }

        @Override
        public V value() {
            return this.value;
        }
    }
}

