/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.core;

import java.util.HashSet;
import java.util.Set;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.ImageOutline;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.OverlapBehavior;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.ShadedRelief;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.UserLayer;
import org.geotools.util.Range;

public class MinMaxScaleCalculator
implements StyleVisitor {
    private Set<Range<Double>> ranges = new HashSet<Range<Double>>();
    private double max;
    private double min;

    public void visit(StyledLayerDescriptor sld) {
        StyledLayer[] layers;
        StyledLayer[] styledLayerArray = layers = sld.getStyledLayers();
        int n = layers.length;
        int n2 = 0;
        while (n2 < n) {
            StyledLayer styledLayer = styledLayerArray[n2];
            if (styledLayer instanceof NamedLayer) {
                ((NamedLayer)styledLayer).accept((StyleVisitor)this);
            } else if (styledLayer instanceof UserLayer) {
                ((UserLayer)styledLayer).accept((StyleVisitor)this);
            }
            ++n2;
        }
    }

    public void visit(NamedLayer layer) {
        Style[] styles;
        Style[] styleArray = styles = layer.getStyles();
        int n = styles.length;
        int n2 = 0;
        while (n2 < n) {
            Style style = styleArray[n2];
            style.accept((StyleVisitor)this);
            ++n2;
        }
    }

    public void visit(UserLayer layer) {
        Style[] styles;
        Style[] styleArray = styles = layer.getUserStyles();
        int n = styles.length;
        int n2 = 0;
        while (n2 < n) {
            Style style = styleArray[n2];
            style.accept((StyleVisitor)this);
            ++n2;
        }
    }

    public void visit(FeatureTypeConstraint ftc) {
    }

    public void visit(Style style) {
        FeatureTypeStyle[] featureTypeStyles;
        FeatureTypeStyle[] featureTypeStyleArray = featureTypeStyles = style.getFeatureTypeStyles();
        int n = featureTypeStyles.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureTypeStyle featureTypeStyle = featureTypeStyleArray[n2];
            featureTypeStyle.accept((StyleVisitor)this);
            ++n2;
        }
    }

    public void visit(Rule rule) {
        double min = rule.getMinScaleDenominator();
        double max = rule.getMaxScaleDenominator();
        this.min = Math.min(min, this.min);
        this.max = Math.max(max, this.max);
        this.ranges.add((Range<Double>)new Range(Double.class, (Comparable)Double.valueOf(min), (Comparable)Double.valueOf(max)));
    }

    public void visit(FeatureTypeStyle fts) {
        Rule[] rules;
        Rule[] ruleArray = rules = fts.getRules();
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            Rule rule = ruleArray[n2];
            rule.accept((StyleVisitor)this);
            ++n2;
        }
    }

    public void visit(Fill fill) {
    }

    public void visit(Stroke stroke) {
    }

    public void visit(Symbolizer sym) {
    }

    public void visit(PointSymbolizer ps) {
    }

    public void visit(LineSymbolizer line) {
    }

    public void visit(PolygonSymbolizer poly) {
    }

    public void visit(TextSymbolizer text) {
    }

    public void visit(RasterSymbolizer raster) {
    }

    public void visit(Graphic gr) {
    }

    public void visit(Mark mark) {
    }

    public void visit(ExternalGraphic exgr) {
    }

    public void visit(PointPlacement pp) {
    }

    public void visit(AnchorPoint ap) {
    }

    public void visit(Displacement dis) {
    }

    public void visit(LinePlacement lp) {
    }

    public void visit(Halo halo) {
    }

    public void visit(ColorMap colorMap) {
    }

    public void visit(ColorMapEntry colorMapEntry) {
    }

    public Set<Range<Double>> getRanges() {
        return this.ranges;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public void visit(ContrastEnhancement arg0) {
    }

    public void visit(ImageOutline arg0) {
    }

    public void visit(ChannelSelection arg0) {
    }

    public void visit(OverlapBehavior arg0) {
    }

    public void visit(SelectedChannelType arg0) {
    }

    public void visit(ShadedRelief arg0) {
    }

    public static Set<Range<Double>> getValidScaleRanges(Style style) {
        if (style == null) {
            return new HashSet<Range<Double>>();
        }
        MinMaxScaleCalculator minMaxScaleCalculator = new MinMaxScaleCalculator();
        style.accept((StyleVisitor)minMaxScaleCalculator);
        return minMaxScaleCalculator.getRanges();
    }
}

