/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.core;

import net.refractions.udig.core.Pair;

public class Either<T1, T2>
extends Pair<T1, T2> {
    private boolean isLeft;

    private Either(boolean isleft, T1 left, T2 right) {
        super(left, right);
        this.isLeft = isleft;
    }

    public static <T1, T2> Either<T1, T2> createLeft(T1 value) {
        return new Either<T1, Object>(true, value, null);
    }

    public static <T1, T2> Either<T1, T2> createRight(T2 value) {
        return new Either<Object, T2>(false, null, value);
    }

    public boolean isLeft() {
        return this.isLeft;
    }

    public boolean isRight() {
        return !this.isLeft;
    }

    @Override
    public T1 getLeft() {
        if (!this.isLeft()) {
            throw new IllegalStateException("The left value is not set.  Call isLeft first");
        }
        return (T1)super.getLeft();
    }

    @Override
    public T2 getRight() {
        if (!this.isRight()) {
            throw new IllegalStateException("The right value is not set.  Call isRight first");
        }
        return (T2)super.getRight();
    }
}

