/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.core;

import java.io.IOException;
import net.refractions.udig.core.IBlockingAdaptable;
import net.refractions.udig.core.internal.CorePlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class AdapterUtil {
    public static final AdapterUtil instance = new AdapterUtil();

    private AdapterUtil() {
    }

    public boolean canAdaptTo(String targetClass, Object obj) {
        if (obj == null) {
            return false;
        }
        ClassLoader classLoader = obj.getClass().getClassLoader();
        return this.canAdaptTo(targetClass, obj, classLoader);
    }

    public boolean canAdaptTo(String targetClass, Object obj, ClassLoader classLoader) {
        Class<?> target = null;
        if (obj == null) {
            return false;
        }
        if (classLoader == null) {
            classLoader = obj.getClass().getClassLoader();
        }
        try {
            target = classLoader.loadClass(targetClass);
        }
        catch (Throwable throwable) {
            return false;
        }
        if (target.isAssignableFrom(obj.getClass())) {
            return true;
        }
        return this.canAdaptTo(obj, target);
    }

    public boolean canAdaptTo(Object obj, Class<?> target) {
        if (Platform.getAdapterManager().hasAdapter(obj, target.getName())) {
            return true;
        }
        IBlockingAdaptable blockingAdaptable = this.getBlockingAdapter(obj);
        if (blockingAdaptable != null && blockingAdaptable.canAdaptTo(target)) {
            return true;
        }
        IAdaptable adaptable = this.getAdaptable(obj);
        if (adaptable != null) {
            return adaptable.getAdapter(target) != null;
        }
        return false;
    }

    public IAdaptable getAdaptable(Object obj) {
        if (obj instanceof IAdaptable) {
            return (IAdaptable)obj;
        }
        if (Platform.getAdapterManager().hasAdapter(obj, IAdaptable.class.getSimpleName())) {
            return (IAdaptable)Platform.getAdapterManager().getAdapter(obj, IAdaptable.class);
        }
        return null;
    }

    public IBlockingAdaptable getBlockingAdapter(Object obj) {
        if (obj instanceof IBlockingAdaptable) {
            return (IBlockingAdaptable)obj;
        }
        if (Platform.getAdapterManager().hasAdapter(obj, IBlockingAdaptable.class.getName())) {
            return (IBlockingAdaptable)Platform.getAdapterManager().getAdapter(obj, IBlockingAdaptable.class);
        }
        if (obj instanceof IAdaptable) {
            IAdaptable adapter = (IAdaptable)obj;
            return (IBlockingAdaptable)adapter.getAdapter(IBlockingAdaptable.class);
        }
        return null;
    }

    public <T> T adapt(String targetClass, Object obj, IProgressMonitor monitor) throws IOException {
        Class<?> target = null;
        try {
            target = obj.getClass().getClassLoader().loadClass(targetClass);
            return (T)this.adaptTo(target, obj, monitor);
        }
        catch (ClassNotFoundException e) {
            CorePlugin.log("This exception is bad.  The framework should not allow this to be reached.", e);
            return null;
        }
    }

    public <T> T adaptTo(Class<T> target, Object obj, IProgressMonitor monitor) throws IOException {
        if (target.isAssignableFrom(obj.getClass())) {
            return target.cast(obj);
        }
        if (Platform.getAdapterManager().hasAdapter(obj, target.getName())) {
            return target.cast(Platform.getAdapterManager().loadAdapter(obj, target.getName()));
        }
        IBlockingAdaptable blockingAdaptable = this.getBlockingAdapter(obj);
        if (blockingAdaptable != null && blockingAdaptable.canAdaptTo(target)) {
            return blockingAdaptable.getAdapter(target, monitor);
        }
        if (obj instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)obj;
            return target.cast(adaptable.getAdapter(target));
        }
        return null;
    }
}

