/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.renderer.lite.SynchronizedLabelCache;
import org.geotools.swing.AbstractMapPane;
import org.geotools.swing.RenderingExecutor;
import org.geotools.swing.RenderingOperands;

public class JLayeredMapPane
extends AbstractMapPane {
    private final Map<Layer, LayerOperands> operandLookup = new HashMap<Layer, LayerOperands>();
    private final Map<Object, Object> renderingHints;

    public JLayeredMapPane() {
        this((MapContent)null);
    }

    public JLayeredMapPane(MapContent content) {
        this(content, null);
    }

    public JLayeredMapPane(MapContent content, RenderingExecutor executor) {
        super(content, executor);
        this.labelCache = new SynchronizedLabelCache();
        this.renderingHints = new HashMap<Object, Object>();
        this.renderingHints.put("labelCache", this.labelCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawLayers(boolean recreate) {
        this.drawingLock.lock();
        try {
            if (this.mapContent != null && !this.mapContent.layers().isEmpty() && !this.mapContent.getViewport().isEmpty() && this.acceptRepaintRequests.get()) {
                this.getRenderingExecutor().submit(this.mapContent, this.getOperands(recreate), this);
            }
        }
        finally {
            this.drawingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.drawingLock.tryLock()) {
            try {
                if (this.mapContent != null) {
                    Graphics2D g2 = (Graphics2D)g;
                    for (Layer layer : this.mapContent.layers()) {
                        LayerOperands op = this.operandLookup.get(layer);
                        if (op == null) continue;
                        g2.drawImage((Image)op.image, this.imageOrigin.x, this.imageOrigin.y, null);
                    }
                }
            }
            finally {
                this.drawingLock.unlock();
            }
        }
    }

    private List<RenderingOperands> getOperands(boolean recreate) {
        ArrayList<RenderingOperands> ops = new ArrayList<RenderingOperands>();
        Rectangle r = this.getVisibleRect();
        for (Layer layer : this.mapContent.layers()) {
            ops.add(this.getRenderingOperands(layer, r, recreate));
        }
        return ops;
    }

    private RenderingOperands getRenderingOperands(Layer layer, Rectangle r, boolean recreate) {
        LayerOperands op = this.operandLookup.get(layer);
        if (op == null) {
            op = new LayerOperands();
            this.operandLookup.put(layer, op);
        }
        if (op.image == null || recreate) {
            op.image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(r.width, r.height, 3);
            if (op.graphics != null) {
                op.graphics.dispose();
            }
            op.graphics = op.image.createGraphics();
        }
        if (op.renderer == null) {
            op.renderer = new StreamingRenderer();
            op.renderer.setRendererHints(this.renderingHints);
        }
        return new RenderingOperands(layer, op.graphics, op.renderer);
    }

    private static class LayerOperands {
        BufferedImage image;
        Graphics2D graphics;
        GTRenderer renderer;

        private LayerOperands() {
        }
    }
}

