/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.map.MapViewport;
import org.geotools.map.event.MapBoundsEvent;
import org.geotools.map.event.MapBoundsListener;
import org.geotools.map.event.MapLayerListEvent;
import org.geotools.map.event.MapLayerListListener;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.swing.DefaultRenderingExecutor;
import org.geotools.swing.MapPane;
import org.geotools.swing.MouseDragBox;
import org.geotools.swing.RenderingExecutor;
import org.geotools.swing.RenderingExecutorEvent;
import org.geotools.swing.RenderingExecutorListener;
import org.geotools.swing.event.DefaultMapMouseEventDispatcher;
import org.geotools.swing.event.MapMouseEventDispatcher;
import org.geotools.swing.event.MapMouseListener;
import org.geotools.swing.event.MapPaneEvent;
import org.geotools.swing.event.MapPaneKeyHandler;
import org.geotools.swing.event.MapPaneListener;
import org.geotools.swing.tool.CursorTool;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class AbstractMapPane
extends JPanel
implements MapPane,
RenderingExecutorListener,
MapLayerListListener,
MapBoundsListener {
    public static final int DEFAULT_PAINT_DELAY = 500;
    public static final Color DEFAULT_BACKGROUND_COLOR = Color.WHITE;
    protected final ScheduledExecutorService paneTaskExecutor;
    protected Future<?> resizedFuture;
    protected int paintDelay;
    protected final AtomicBoolean acceptRepaintRequests;
    protected final AtomicBoolean baseImageMoved;
    protected Future<?> imageMovedFuture;
    protected final Point imageOrigin;
    protected final Lock drawingLock;
    protected final ReadWriteLock paramsLock;
    protected final Set<MapPaneListener> listeners = new HashSet<MapPaneListener>();
    protected final MouseDragBox dragBox;
    protected ReferencedEnvelope pendingDisplayArea;
    protected ReferencedEnvelope fullExtent;
    protected MapContent mapContent;
    protected RenderingExecutor renderingExecutor;
    protected KeyListener keyHandler;
    protected MapMouseEventDispatcher mouseEventDispatcher;
    protected LabelCache labelCache;
    protected AtomicBoolean clearLabelCache;
    protected CursorTool currentCursorTool;

    public AbstractMapPane(MapContent content, RenderingExecutor executor) {
        this.setBackground(DEFAULT_BACKGROUND_COLOR);
        this.setFocusable(true);
        this.drawingLock = new ReentrantLock();
        this.paramsLock = new ReentrantReadWriteLock();
        this.paneTaskExecutor = Executors.newSingleThreadScheduledExecutor();
        this.paintDelay = 500;
        this.acceptRepaintRequests = new AtomicBoolean(true);
        this.clearLabelCache = new AtomicBoolean(true);
        this.baseImageMoved = new AtomicBoolean();
        this.imageOrigin = new Point(0, 0);
        this.dragBox = new MouseDragBox(this);
        this.mouseEventDispatcher = new DefaultMapMouseEventDispatcher(this);
        this.addMouseListener(this.dragBox);
        this.addMouseMotionListener(this.dragBox);
        this.addMouseListener(this.mouseEventDispatcher);
        this.addMouseMotionListener(this.mouseEventDispatcher);
        this.addMouseWheelListener(this.mouseEventDispatcher);
        this.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                if (AbstractMapPane.this.currentCursorTool != null) {
                    AbstractMapPane.this.setCursor(AbstractMapPane.this.currentCursorTool.getCursor());
                }
            }
        });
        this.keyHandler = new MapPaneKeyHandler(this);
        this.addKeyListener(this.keyHandler);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent he) {
                if ((he.getChangeFlags() & 4L) != 0L && AbstractMapPane.this.isShowing()) {
                    AbstractMapPane.this.onShownOrResized();
                }
            }
        });
        this.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            @Override
            public void ancestorResized(HierarchyEvent he) {
                if (AbstractMapPane.this.isShowing()) {
                    AbstractMapPane.this.onShownOrResized();
                }
            }
        });
        this.doSetMapContent(content);
        this.doSetRenderingExecutor(executor);
    }

    protected abstract void drawLayers(boolean var1);

    public RenderingExecutor getRenderingExecutor() {
        if (this.renderingExecutor == null) {
            this.doSetRenderingExecutor(new DefaultRenderingExecutor());
        }
        return this.renderingExecutor;
    }

    @Override
    public MapMouseEventDispatcher getMouseEventDispatcher() {
        return this.mouseEventDispatcher;
    }

    @Override
    public void setMouseEventDispatcher(MapMouseEventDispatcher dispatcher) {
        if (this.mouseEventDispatcher != null) {
            this.mouseEventDispatcher.removeAllListeners();
        }
        this.mouseEventDispatcher = dispatcher;
    }

    public void setRenderingExecutor(RenderingExecutor executor) {
        this.doSetRenderingExecutor(executor);
    }

    private void doSetRenderingExecutor(RenderingExecutor newExecutor) {
        if (this.renderingExecutor != null) {
            this.renderingExecutor.shutdown();
        }
        this.renderingExecutor = newExecutor;
    }

    public KeyListener getKeyHandler() {
        return this.keyHandler;
    }

    public void setKeyHandler(KeyListener controller) {
        if (this.keyHandler != null) {
            this.removeKeyListener(this.keyHandler);
        }
        if (controller != null) {
            this.addKeyListener(controller);
        }
        this.keyHandler = controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPaintDelay() {
        this.paramsLock.readLock().lock();
        try {
            long l = this.paintDelay;
            return l;
        }
        finally {
            this.paramsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPaintDelay(int delay) {
        this.paramsLock.writeLock().lock();
        try {
            this.paintDelay = delay < 0 ? 500 : delay;
        }
        finally {
            this.paramsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIgnoreRepaint(boolean ignoreRepaint) {
        this.drawingLock.lock();
        try {
            super.setIgnoreRepaint(ignoreRepaint);
            this.acceptRepaintRequests.set(!ignoreRepaint);
        }
        finally {
            this.drawingLock.unlock();
        }
    }

    public boolean isAcceptingRepaints() {
        return this.acceptRepaintRequests.get();
    }

    protected void onShownOrResized() {
        if (this.resizedFuture != null && !this.resizedFuture.isDone()) {
            this.resizedFuture.cancel(true);
        }
        this.resizedFuture = this.paneTaskExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                AbstractMapPane.this.setForNewSize();
                AbstractMapPane.this.repaint();
            }
        }, (long)this.paintDelay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setForNewSize() {
        this.drawingLock.lock();
        try {
            if (this.mapContent != null) {
                if (this.mapContent.getViewport().getScreenArea().equals(this.getVisibleRect())) {
                    return;
                }
                this.mapContent.getViewport().setScreenArea(this.getVisibleRect());
                if (this.pendingDisplayArea != null) {
                    this.doSetDisplayArea((Envelope)this.pendingDisplayArea);
                    this.pendingDisplayArea = null;
                } else if (this.mapContent.getViewport().getBounds().isEmpty()) {
                    this.setFullExtent();
                    this.doSetDisplayArea((Envelope)this.fullExtent);
                }
                this.publishEvent(new MapPaneEvent(this, MapPaneEvent.Type.DISPLAY_AREA_CHANGED, this.getDisplayArea()));
                this.acceptRepaintRequests.set(true);
                this.drawLayers(true);
            }
        }
        finally {
            this.drawingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveImage(int dx, int dy) {
        this.drawingLock.lock();
        try {
            if (this.isShowing() && !this.getVisibleRect().isEmpty()) {
                this.imageOrigin.translate(dx, dy);
                this.baseImageMoved.set(true);
                this.repaint();
                this.onImageMoved();
            }
        }
        finally {
            this.drawingLock.unlock();
        }
    }

    protected void onImageMoved() {
        if (this.imageMovedFuture != null && !this.imageMovedFuture.isDone()) {
            this.imageMovedFuture.cancel(true);
        }
        this.imageMovedFuture = this.paneTaskExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                AbstractMapPane.this.afterImageMoved();
                AbstractMapPane.this.clearLabelCache.set(true);
                AbstractMapPane.this.drawLayers(false);
                AbstractMapPane.this.repaint();
            }
        }, (long)this.paintDelay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterImageMoved() {
        this.paramsLock.writeLock().lock();
        try {
            int dx = this.imageOrigin.x;
            int dy = this.imageOrigin.y;
            DirectPosition2D newPos = new DirectPosition2D(dx, dy);
            this.mapContent.getViewport().getScreenToWorld().transform(newPos, newPos);
            ReferencedEnvelope env = new ReferencedEnvelope(this.mapContent.getViewport().getBounds());
            env.translate(env.getMinimum(0) - newPos.x, env.getMaximum(1) - newPos.y);
            this.doSetDisplayArea((Envelope)env);
            this.imageOrigin.setLocation(0, 0);
            this.baseImageMoved.set(false);
        }
        finally {
            this.paramsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapContent getMapContent() {
        this.paramsLock.readLock().lock();
        try {
            MapContent mapContent = this.mapContent;
            return mapContent;
        }
        finally {
            this.paramsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMapContent(MapContent content) {
        this.paramsLock.writeLock().lock();
        try {
            this.doSetMapContent(content);
        }
        finally {
            this.paramsLock.writeLock().unlock();
        }
    }

    private void doSetMapContent(MapContent newMapContent) {
        if (this.mapContent != newMapContent) {
            if (this.mapContent != null) {
                this.mapContent.removeMapLayerListListener((MapLayerListListener)this);
                for (Layer layer : this.mapContent.layers()) {
                    if (!(layer instanceof ComponentListener)) continue;
                    this.removeComponentListener((ComponentListener)layer);
                }
            }
            this.mapContent = newMapContent;
            if (this.mapContent != null) {
                MapViewport viewport = this.mapContent.getViewport();
                viewport.setMatchingAspectRatio(true);
                Rectangle rect = this.getVisibleRect();
                if (!rect.isEmpty()) {
                    viewport.setScreenArea(rect);
                }
                this.mapContent.addMapLayerListListener((MapLayerListListener)this);
                this.mapContent.addMapBoundsListener((MapBoundsListener)this);
                if (!this.mapContent.layers().isEmpty()) {
                    for (Layer layer : this.mapContent.layers()) {
                        layer.setSelected(true);
                        if (!(layer instanceof ComponentListener)) continue;
                        this.addComponentListener((ComponentListener)layer);
                    }
                    this.setFullExtent();
                    this.doSetDisplayArea((Envelope)this.mapContent.getViewport().getBounds());
                }
            }
            MapPaneEvent event = new MapPaneEvent(this, MapPaneEvent.Type.NEW_MAPCONTENT, this.mapContent);
            this.publishEvent(event);
            this.drawLayers(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferencedEnvelope getDisplayArea() {
        this.paramsLock.readLock().lock();
        try {
            if (this.mapContent != null) {
                ReferencedEnvelope referencedEnvelope = this.mapContent.getViewport().getBounds();
                return referencedEnvelope;
            }
            if (this.pendingDisplayArea != null) {
                ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(this.pendingDisplayArea);
                return referencedEnvelope;
            }
            ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope();
            return referencedEnvelope;
        }
        finally {
            this.paramsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDisplayArea(Envelope envelope) {
        this.paramsLock.writeLock().lock();
        try {
            if (envelope == null) {
                throw new IllegalArgumentException("envelope must not be null");
            }
            this.doSetDisplayArea(envelope);
            if (this.mapContent != null) {
                this.clearLabelCache.set(true);
                this.drawLayers(false);
            }
        }
        finally {
            this.paramsLock.writeLock().unlock();
        }
    }

    protected void doSetDisplayArea(Envelope envelope) {
        if (this.mapContent != null) {
            CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
            if (crs == null) {
                crs = this.mapContent.getCoordinateReferenceSystem();
            }
            ReferencedEnvelope refEnv = new ReferencedEnvelope(envelope.getMinimum(0), envelope.getMaximum(0), envelope.getMinimum(1), envelope.getMaximum(1), crs);
            this.mapContent.getViewport().setBounds(refEnv);
        } else {
            this.pendingDisplayArea = new ReferencedEnvelope(envelope);
        }
        this.publishEvent(new MapPaneEvent(this, MapPaneEvent.Type.DISPLAY_AREA_CHANGED, this.getDisplayArea()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this.paramsLock.writeLock().lock();
        try {
            if (this.fullExtent != null) {
                this.setDisplayArea((Envelope)this.fullExtent);
            }
        }
        finally {
            this.paramsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AffineTransform getScreenToWorldTransform() {
        this.paramsLock.readLock().lock();
        try {
            if (this.mapContent != null) {
                AffineTransform affineTransform = this.mapContent.getViewport().getScreenToWorld();
                return affineTransform;
            }
            AffineTransform affineTransform = null;
            return affineTransform;
        }
        finally {
            this.paramsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AffineTransform getWorldToScreenTransform() {
        this.paramsLock.readLock().lock();
        try {
            if (this.mapContent != null) {
                AffineTransform affineTransform = this.mapContent.getViewport().getWorldToScreen();
                return affineTransform;
            }
            AffineTransform affineTransform = null;
            return affineTransform;
        }
        finally {
            this.paramsLock.readLock().unlock();
        }
    }

    @Override
    public void addMapPaneListener(MapPaneListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeMapPaneListener(MapPaneListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void addMouseListener(MapMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.mouseEventDispatcher.addMouseListener(listener);
    }

    @Override
    public void removeMouseListener(MapMouseListener listener) {
        if (listener != null) {
            this.mouseEventDispatcher.removeMouseListener(listener);
        }
    }

    @Override
    public CursorTool getCursorTool() {
        return this.currentCursorTool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCursorTool(CursorTool tool) {
        this.paramsLock.writeLock().lock();
        try {
            if (this.currentCursorTool != null) {
                this.mouseEventDispatcher.removeMouseListener(this.currentCursorTool);
            }
            this.currentCursorTool = tool;
            if (this.currentCursorTool == null) {
                this.setCursor(Cursor.getDefaultCursor());
                this.dragBox.setEnabled(false);
            } else {
                this.setCursor(this.currentCursorTool.getCursor());
                this.dragBox.setEnabled(this.currentCursorTool.drawDragBox());
                this.currentCursorTool.setMapPane(this);
                this.mouseEventDispatcher.addMouseListener(this.currentCursorTool);
            }
        }
        finally {
            this.paramsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layerAdded(MapLayerListEvent event) {
        this.paramsLock.writeLock().lock();
        try {
            Layer layer = event.getElement();
            if (layer instanceof ComponentListener) {
                this.addComponentListener((ComponentListener)layer);
            }
            this.setFullExtent();
            MapViewport viewport = this.mapContent.getViewport();
            if (viewport.getBounds().isEmpty()) {
                viewport.setBounds(this.fullExtent);
            }
        }
        finally {
            this.paramsLock.writeLock().unlock();
        }
        this.drawLayers(false);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layerRemoved(MapLayerListEvent event) {
        this.paramsLock.writeLock().lock();
        try {
            Layer layer = event.getElement();
            if (layer instanceof ComponentListener) {
                this.addComponentListener((ComponentListener)layer);
            }
            if (this.mapContent.layers().isEmpty()) {
                this.fullExtent = null;
            } else {
                this.setFullExtent();
            }
        }
        finally {
            this.paramsLock.writeLock().unlock();
        }
        this.drawLayers(false);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layerChanged(MapLayerListEvent event) {
        this.paramsLock.writeLock().lock();
        try {
            int reason = event.getMapLayerEvent().getReason();
            if (reason == 3) {
                this.setFullExtent();
            }
            if (reason != 6) {
                this.clearLabelCache.set(true);
                this.drawLayers(false);
            }
        }
        finally {
            this.paramsLock.writeLock().unlock();
        }
        this.repaint();
    }

    public void layerMoved(MapLayerListEvent event) {
        this.drawLayers(false);
        this.repaint();
    }

    public void layerPreDispose(MapLayerListEvent event) {
        this.getRenderingExecutor().cancelAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapBoundsChanged(MapBoundsEvent event) {
        this.paramsLock.writeLock().lock();
        try {
            int type = event.getType();
            if ((type & 2) != 0) {
                this.setFullExtent();
                this.reset();
            }
        }
        finally {
            this.paramsLock.writeLock().unlock();
        }
    }

    protected void publishEvent(MapPaneEvent ev) {
        for (MapPaneListener listener : this.listeners) {
            switch (ev.getType()) {
                case NEW_MAPCONTENT: {
                    listener.onNewMapContent(ev);
                    break;
                }
                case DISPLAY_AREA_CHANGED: {
                    listener.onDisplayAreaChanged(ev);
                    break;
                }
                case RENDERING_STARTED: {
                    listener.onRenderingStarted(ev);
                    break;
                }
                case RENDERING_STOPPED: {
                    listener.onRenderingStopped(ev);
                }
            }
        }
    }

    protected boolean setFullExtent() {
        if (this.mapContent != null && !this.mapContent.layers().isEmpty()) {
            try {
                this.fullExtent = this.mapContent.getMaxBounds();
                if (this.fullExtent == null) {
                    this.fullExtent = new ReferencedEnvelope(-1.0, 1.0, -1.0, 1.0, this.mapContent.getCoordinateReferenceSystem());
                }
                double w = this.fullExtent.getWidth();
                double h = this.fullExtent.getHeight();
                double x = this.fullExtent.getMinimum(0);
                double y = this.fullExtent.getMinimum(1);
                double xmin = x;
                double xmax = x + w;
                if (w <= 0.0) {
                    xmin = x - 1.0;
                    xmax = x + 1.0;
                }
                double ymin = y;
                double ymax = y + h;
                if (h <= 0.0) {
                    ymin = y - 1.0;
                    ymax = y + 1.0;
                }
                this.fullExtent = new ReferencedEnvelope(xmin, xmax, ymin, ymax, this.mapContent.getCoordinateReferenceSystem());
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        } else {
            this.fullExtent = null;
        }
        return this.fullExtent != null;
    }

    @Override
    public void onRenderingStarted(RenderingExecutorEvent ev) {
        this.publishEvent(new MapPaneEvent(this, MapPaneEvent.Type.RENDERING_STARTED));
    }

    @Override
    public void onRenderingCompleted(RenderingExecutorEvent event) {
        if (this.clearLabelCache.get()) {
            this.labelCache.clear();
        }
        this.clearLabelCache.set(false);
        this.repaint();
        this.publishEvent(new MapPaneEvent(this, MapPaneEvent.Type.RENDERING_STOPPED));
    }

    @Override
    public void onRenderingFailed(RenderingExecutorEvent ev) {
        this.publishEvent(new MapPaneEvent(this, MapPaneEvent.Type.RENDERING_STOPPED));
    }
}

