/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.jgrass.legend;

import eu.udig.style.jgrass.legend.VectorLegendGraphic;
import eu.udig.style.jgrass.legend.VectorLegendStyle;
import eu.udig.style.jgrass.legend.VectorLegendStyleContent;
import eu.udig.style.jgrass.messages.Messages;
import java.awt.Color;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.project.ui.internal.dialogs.ColorEditor;
import net.refractions.udig.style.IStyleConfigurator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VectorLegendGraphicStyleConfigurator
extends IStyleConfigurator
implements SelectionListener,
ModifyListener {
    private Text xposText;
    private ColorEditor fontColour;
    private ColorEditor backgroundColour;
    private Text yposText;
    private Text legHeightText;
    private Text legWidthText;
    private Text boxWidthText;
    private Button isroundedButton;
    private Text backgroundAlphaText;
    private Text forgroundAlphaText;
    private ColorEditor foregroundColor;
    private VectorLegendStyle style;

    public void createControl(Composite parent) {
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        Composite c = new Composite((Composite)scrollComposite, 0);
        c.setLayout((Layout)new GridLayout());
        c.setLayoutData((Object)new GridData(1808));
        Object layoutData = null;
        Group propertiesGroup = new Group(c, 2048);
        GridLayout layout2 = new GridLayout(2, true);
        propertiesGroup.setLayout((Layout)layout2);
        Label xposLabel = new Label((Composite)propertiesGroup, 0);
        xposLabel.setLayoutData(layoutData);
        xposLabel.setText(Messages.getString("LegendGraphicStyleConfigurator.xpos"));
        this.xposText = new Text((Composite)propertiesGroup, 2048);
        this.xposText.setLayoutData((Object)new GridData(768));
        Label yposLabel = new Label((Composite)propertiesGroup, 0);
        yposLabel.setLayoutData(layoutData);
        yposLabel.setText(Messages.getString("LegendGraphicStyleConfigurator.ypos"));
        this.yposText = new Text((Composite)propertiesGroup, 2048);
        this.yposText.setLayoutData((Object)new GridData(768));
        Label legWidthLabel = new Label((Composite)propertiesGroup, 0);
        legWidthLabel.setLayoutData(layoutData);
        legWidthLabel.setText(Messages.getString("LegendGraphicStyleConfigurator.legendwidth"));
        this.legWidthText = new Text((Composite)propertiesGroup, 2048);
        this.legWidthText.setLayoutData((Object)new GridData(768));
        Label legHeightLabel = new Label((Composite)propertiesGroup, 0);
        legHeightLabel.setLayoutData(layoutData);
        legHeightLabel.setText(Messages.getString("LegendGraphicStyleConfigurator.legendheight"));
        this.legHeightText = new Text((Composite)propertiesGroup, 2048);
        this.legHeightText.setLayoutData((Object)new GridData(768));
        Label boxWidthLabel = new Label((Composite)propertiesGroup, 0);
        boxWidthLabel.setLayoutData(layoutData);
        boxWidthLabel.setText(Messages.getString("LegendGraphicStyleConfigurator.boxwidth"));
        this.boxWidthText = new Text((Composite)propertiesGroup, 2048);
        this.boxWidthText.setLayoutData((Object)new GridData(768));
        this.isroundedButton = new Button((Composite)propertiesGroup, 2080);
        this.isroundedButton.setText(Messages.getString("LegendGraphicStyleConfigurator.roundedrect"));
        GridData gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        this.isroundedButton.setLayoutData((Object)gdata);
        Label fontColourLabel = new Label((Composite)propertiesGroup, 0);
        fontColourLabel.setLayoutData((Object)new GridData(768));
        fontColourLabel.setText(Messages.getString("LegendGraphicStyleConfigurator.fontcolor"));
        this.fontColour = new ColorEditor((Composite)propertiesGroup);
        Label backgroundColourLabel = new Label((Composite)propertiesGroup, 0);
        backgroundColourLabel.setLayoutData((Object)new GridData(768));
        backgroundColourLabel.setText(Messages.getString("LegendGraphicStyleConfigurator.backgroundcolor"));
        this.backgroundColour = new ColorEditor((Composite)propertiesGroup);
        Label backgroundAlphaLabel = new Label((Composite)propertiesGroup, 0);
        backgroundAlphaLabel.setLayoutData((Object)new GridData(768));
        backgroundAlphaLabel.setText(Messages.getString("LegendGraphicStyleConfigurator.backgroundalpha"));
        this.backgroundAlphaText = new Text((Composite)propertiesGroup, 2048);
        this.backgroundAlphaText.setLayoutData((Object)new GridData(768));
        Label foregroundColourLabel = new Label((Composite)propertiesGroup, 0);
        foregroundColourLabel.setLayoutData((Object)new GridData(768));
        foregroundColourLabel.setText(Messages.getString("LegendGraphicStyleConfigurator.foregroundcolor"));
        this.foregroundColor = new ColorEditor((Composite)propertiesGroup);
        Label forgroundAlphaLabel = new Label((Composite)propertiesGroup, 0);
        forgroundAlphaLabel.setLayoutData(layoutData);
        forgroundAlphaLabel.setText(Messages.getString("LegendGraphicStyleConfigurator.foregroundalpha"));
        this.forgroundAlphaText = new Text((Composite)propertiesGroup, 2048);
        this.forgroundAlphaText.setLayoutData((Object)new GridData(768));
        c.layout();
        Point size = c.computeSize(-1, -1);
        c.setSize(size);
        scrollComposite.setContent((Control)c);
        this.xposText.addModifyListener((ModifyListener)this);
        this.yposText.addModifyListener((ModifyListener)this);
        this.legWidthText.addModifyListener((ModifyListener)this);
        this.legHeightText.addModifyListener((ModifyListener)this);
        this.boxWidthText.addModifyListener((ModifyListener)this);
        this.backgroundAlphaText.addModifyListener((ModifyListener)this);
        this.forgroundAlphaText.addModifyListener((ModifyListener)this);
        this.isroundedButton.addSelectionListener((SelectionListener)this);
        this.foregroundColor.addSelectionListener((SelectionListener)this);
        this.backgroundColour.addSelectionListener((SelectionListener)this);
        this.fontColour.addSelectionListener((SelectionListener)this);
    }

    public boolean canStyle(Layer aLayer) {
        return aLayer.hasResource(VectorLegendGraphic.class);
    }

    protected void refresh() {
        StyleBlackboard styleBlackboard = this.getLayer().getStyleBlackboard();
        this.style = (VectorLegendStyle)styleBlackboard.get("eu.hydrologis.jgrass.rasterlegend.vectorlegendStyle");
        if (this.style == null) {
            this.style = VectorLegendStyleContent.createDefault();
            styleBlackboard.put("eu.hydrologis.jgrass.rasterlegend.vectorlegendStyle", (Object)this.style);
            styleBlackboard.setSelected(new String[]{"eu.hydrologis.jgrass.rasterlegend.vectorlegendStyle"});
        }
        this.fontColour.setColorValue(new RGB(this.style.fontColor.getRed(), this.style.fontColor.getGreen(), this.style.fontColor.getBlue()));
        this.foregroundColor.setColorValue(new RGB(this.style.foregroundColor.getRed(), this.style.foregroundColor.getGreen(), this.style.foregroundColor.getBlue()));
        this.backgroundColour.setColorValue(new RGB(this.style.backgroundColor.getRed(), this.style.backgroundColor.getGreen(), this.style.backgroundColor.getBlue()));
        this.xposText.setText(Integer.toString(this.style.xPos));
        this.yposText.setText(Integer.toString(this.style.yPos));
        this.legWidthText.setText(Integer.toString(this.style.legendWidth));
        this.legHeightText.setText(Integer.toString(this.style.legendHeight));
        this.boxWidthText.setText(Integer.toString(this.style.boxWidth));
        this.forgroundAlphaText.setText(Integer.toString(this.style.fAlpha));
        this.backgroundAlphaText.setText(Integer.toString(this.style.bAlpha));
        this.isroundedButton.setSelection(this.style.isRoundedRectangle);
    }

    public void preApply() {
        this.updateBlackboard();
    }

    private void updateBlackboard() {
        StyleBlackboard styleBlackboard = this.getLayer().getStyleBlackboard();
        this.style = (VectorLegendStyle)styleBlackboard.get("eu.hydrologis.jgrass.rasterlegend.vectorlegendStyle");
        if (this.style == null) {
            this.style = VectorLegendStyleContent.createDefault();
            styleBlackboard.put("eu.hydrologis.jgrass.rasterlegend.vectorlegendStyle", (Object)this.style);
            styleBlackboard.setSelected(new String[]{"eu.hydrologis.jgrass.rasterlegend.vectorlegendStyle"});
        }
        RGB bg = this.backgroundColour.getColorValue();
        try {
            int bAlpha = Integer.parseInt(this.backgroundAlphaText.getText());
            this.style.backgroundColor = new Color(bg.red, bg.green, bg.blue, bAlpha);
        }
        catch (Exception exception) {
            this.style.backgroundColor = new Color(bg.red, bg.green, bg.blue);
        }
        bg = this.foregroundColor.getColorValue();
        try {
            int fAlpha = Integer.parseInt(this.forgroundAlphaText.getText());
            this.style.foregroundColor = new Color(bg.red, bg.green, bg.blue, fAlpha);
        }
        catch (Exception exception) {
            this.style.foregroundColor = new Color(bg.red, bg.green, bg.blue);
        }
        bg = this.fontColour.getColorValue();
        this.style.fontColor = new Color(bg.red, bg.green, bg.blue);
        this.style.xPos = Integer.parseInt(this.xposText.getText());
        this.style.yPos = Integer.parseInt(this.yposText.getText());
        this.style.legendHeight = Integer.parseInt(this.legHeightText.getText());
        this.style.legendWidth = Integer.parseInt(this.legWidthText.getText());
        this.style.boxWidth = Integer.parseInt(this.boxWidthText.getText());
        this.style.isRoundedRectangle = this.isroundedButton.getSelection();
        styleBlackboard.put("eu.hydrologis.jgrass.rasterlegend.vectorlegendStyle", (Object)this.style);
    }

    public void widgetSelected(SelectionEvent e) {
        this.updateBlackboard();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.updateBlackboard();
    }

    public void modifyText(ModifyEvent e) {
    }
}

