/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.jgrass.legend;

import eu.udig.catalog.jgrass.activeregion.dialogs.JGRasterChooserDialog;
import eu.udig.catalog.jgrass.core.JGrassMapGeoResource;
import eu.udig.style.jgrass.legend.RasterLegendGraphic;
import eu.udig.style.jgrass.legend.RasterLegendStyle;
import eu.udig.style.jgrass.legend.RasterLegendStyleContent;
import eu.udig.style.jgrass.messages.Messages;
import java.awt.Color;
import java.io.File;
import java.util.List;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.dialogs.ColorEditor;
import net.refractions.udig.style.IStyleConfigurator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RasterLegendGraphicStyleConfigurator
extends IStyleConfigurator
implements SelectionListener,
ModifyListener {
    private Text xposText;
    private ColorEditor fontColour;
    private ColorEditor backgroundColour;
    private Text yposText;
    private Text legHeightText;
    private Text legWidthText;
    private Text boxWidthText;
    private Button isroundedButton;
    private Text backgroundAlphaText;
    private Text forgroundAlphaText;
    private ColorEditor foregroundColor;
    private Text titleText;
    private Label mapNameLabel;
    private RasterLegendStyle style;

    public void createControl(Composite parent) {
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        Composite c = new Composite((Composite)scrollComposite, 0);
        c.setLayout((Layout)new GridLayout());
        c.setLayoutData((Object)new GridData(1808));
        Object layoutData = null;
        Group chooseMapGroup = new Group(c, 2048);
        GridLayout layout1 = new GridLayout(3, false);
        chooseMapGroup.setLayout((Layout)layout1);
        chooseMapGroup.setLayoutData((Object)new GridData(1808));
        Label mapLabel = new Label((Composite)chooseMapGroup, 0);
        mapLabel.setLayoutData(layoutData);
        mapLabel.setText(Messages.getString("LegendGraphicStyleConfigurator.map4legend"));
        this.mapNameLabel = new Label((Composite)chooseMapGroup, 2048);
        GridData gd = new GridData();
        gd.widthHint = 100;
        this.mapNameLabel.setLayoutData((Object)gd);
        final Button mapButton = new Button((Composite)chooseMapGroup, 2056);
        GridData gd2 = new GridData();
        gd2.horizontalAlignment = 128;
        mapButton.setLayoutData((Object)gd2);
        mapButton.setText(Messages.getString("LegendGraphicStyleConfigurator.browse"));
        mapButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JGRasterChooserDialog cDialog = new JGRasterChooserDialog(null);
                cDialog.open(mapButton.getShell(), 4);
                List selectedResource = cDialog.getSelectedResources();
                JGrassMapGeoResource jGrassMapGeoResource = (JGrassMapGeoResource)selectedResource.get(0);
                File mapFile = jGrassMapGeoResource.getMapFile();
                String name = mapFile.getName();
                RasterLegendGraphicStyleConfigurator.this.mapNameLabel.setText(name);
                if (RasterLegendGraphicStyleConfigurator.this.style == null) {
                    RasterLegendGraphicStyleConfigurator.this.checkStyle();
                }
                ((RasterLegendGraphicStyleConfigurator)RasterLegendGraphicStyleConfigurator.this).style.mapPath = mapFile.getAbsolutePath();
            }
        });
        Group propertiesGroup = new Group(c, 2048);
        GridLayout layout2 = new GridLayout(2, true);
        propertiesGroup.setLayout((Layout)layout2);
        Label titleLabel = new Label((Composite)propertiesGroup, 0);
        titleLabel.setLayoutData(layoutData);
        titleLabel.setText(Messages.getString("LegendGraphicStyleConfigurator.title"));
        this.titleText = new Text((Composite)propertiesGroup, 2048);
        this.titleText.setLayoutData((Object)new GridData(768));
        Label xposLabel = new Label((Composite)propertiesGroup, 0);
        xposLabel.setLayoutData(layoutData);
        xposLabel.setText(Messages.getString("LegendGraphicStyleConfigurator.xpos"));
        this.xposText = new Text((Composite)propertiesGroup, 2048);
        this.xposText.setLayoutData((Object)new GridData(768));
        Label yposLabel = new Label((Composite)propertiesGroup, 0);
        yposLabel.setLayoutData(layoutData);
        yposLabel.setText(Messages.getString("LegendGraphicStyleConfigurator.ypos"));
        this.yposText = new Text((Composite)propertiesGroup, 2048);
        this.yposText.setLayoutData((Object)new GridData(768));
        Label legWidthLabel = new Label((Composite)propertiesGroup, 0);
        legWidthLabel.setLayoutData(layoutData);
        legWidthLabel.setText(Messages.getString("LegendGraphicStyleConfigurator.legendwidth"));
        this.legWidthText = new Text((Composite)propertiesGroup, 2048);
        this.legWidthText.setLayoutData((Object)new GridData(768));
        Label legHeightLabel = new Label((Composite)propertiesGroup, 0);
        legHeightLabel.setLayoutData(layoutData);
        legHeightLabel.setText(Messages.getString("LegendGraphicStyleConfigurator.legendheight"));
        this.legHeightText = new Text((Composite)propertiesGroup, 2048);
        this.legHeightText.setLayoutData((Object)new GridData(768));
        Label boxWidthLabel = new Label((Composite)propertiesGroup, 0);
        boxWidthLabel.setLayoutData(layoutData);
        boxWidthLabel.setText(Messages.getString("LegendGraphicStyleConfigurator.boxwidth"));
        this.boxWidthText = new Text((Composite)propertiesGroup, 2048);
        this.boxWidthText.setLayoutData((Object)new GridData(768));
        this.isroundedButton = new Button((Composite)propertiesGroup, 2080);
        this.isroundedButton.setText(Messages.getString("LegendGraphicStyleConfigurator.roundedrect"));
        GridData gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        this.isroundedButton.setLayoutData((Object)gdata);
        Label fontColourLabel = new Label((Composite)propertiesGroup, 0);
        fontColourLabel.setLayoutData((Object)new GridData(768));
        fontColourLabel.setText(Messages.getString("LegendGraphicStyleConfigurator.fontcolor"));
        this.fontColour = new ColorEditor((Composite)propertiesGroup);
        Label backgroundColourLabel = new Label((Composite)propertiesGroup, 0);
        backgroundColourLabel.setLayoutData((Object)new GridData(768));
        backgroundColourLabel.setText(Messages.getString("LegendGraphicStyleConfigurator.backgroundcolor"));
        this.backgroundColour = new ColorEditor((Composite)propertiesGroup);
        Label backgroundAlphaLabel = new Label((Composite)propertiesGroup, 0);
        backgroundAlphaLabel.setLayoutData((Object)new GridData(768));
        backgroundAlphaLabel.setText(Messages.getString("LegendGraphicStyleConfigurator.backgroundalpha"));
        this.backgroundAlphaText = new Text((Composite)propertiesGroup, 2048);
        this.backgroundAlphaText.setLayoutData((Object)new GridData(768));
        Label foregroundColourLabel = new Label((Composite)propertiesGroup, 0);
        foregroundColourLabel.setLayoutData((Object)new GridData(768));
        foregroundColourLabel.setText(Messages.getString("LegendGraphicStyleConfigurator.foregroundcolor"));
        this.foregroundColor = new ColorEditor((Composite)propertiesGroup);
        Label forgroundAlphaLabel = new Label((Composite)propertiesGroup, 0);
        forgroundAlphaLabel.setLayoutData(layoutData);
        forgroundAlphaLabel.setText(Messages.getString("LegendGraphicStyleConfigurator.foregroundalpha"));
        this.forgroundAlphaText = new Text((Composite)propertiesGroup, 2048);
        this.forgroundAlphaText.setLayoutData((Object)new GridData(768));
        c.layout();
        Point size = c.computeSize(-1, -1);
        c.setSize(size);
        scrollComposite.setContent((Control)c);
        this.titleText.addModifyListener((ModifyListener)this);
        this.xposText.addModifyListener((ModifyListener)this);
        this.yposText.addModifyListener((ModifyListener)this);
        this.legWidthText.addModifyListener((ModifyListener)this);
        this.legHeightText.addModifyListener((ModifyListener)this);
        this.boxWidthText.addModifyListener((ModifyListener)this);
        this.backgroundAlphaText.addModifyListener((ModifyListener)this);
        this.forgroundAlphaText.addModifyListener((ModifyListener)this);
        this.isroundedButton.addSelectionListener((SelectionListener)this);
        this.foregroundColor.addSelectionListener((SelectionListener)this);
        this.backgroundColour.addSelectionListener((SelectionListener)this);
        this.fontColour.addSelectionListener((SelectionListener)this);
    }

    public boolean canStyle(Layer aLayer) {
        return aLayer.hasResource(RasterLegendGraphic.class);
    }

    private void checkStyle() {
        IMap activeMap = ApplicationGIS.getActiveMap();
        IBlackboard styleBlackboard = activeMap.getBlackboard();
        if (this.style == null) {
            this.style = (RasterLegendStyle)styleBlackboard.get("eu.hydrologis.jgrass.rasterlegend.rasterlegendStyle");
        }
        if (this.style == null) {
            this.style = RasterLegendStyleContent.createDefault();
            styleBlackboard.put("eu.hydrologis.jgrass.rasterlegend.rasterlegendStyle", (Object)this.style);
        }
    }

    protected void refresh() {
        this.checkStyle();
        String mapPath = this.style.mapPath;
        if (mapPath == null) {
            mapPath = "";
        }
        File mapFile = new File(mapPath);
        String mName = null;
        if (mapFile.exists()) {
            mName = mapFile.getName();
        }
        if (mName == null) {
            mName = "";
        }
        this.mapNameLabel.setText(mName);
        this.fontColour.setColorValue(new RGB(this.style.fontColor.getRed(), this.style.fontColor.getGreen(), this.style.fontColor.getBlue()));
        this.foregroundColor.setColorValue(new RGB(this.style.foregroundColor.getRed(), this.style.foregroundColor.getGreen(), this.style.foregroundColor.getBlue()));
        this.backgroundColour.setColorValue(new RGB(this.style.backgroundColor.getRed(), this.style.backgroundColor.getGreen(), this.style.backgroundColor.getBlue()));
        if (this.style.titleString == null) {
            this.style.titleString = " ";
        }
        this.titleText.setText(this.style.titleString);
        this.xposText.setText(Integer.toString(this.style.xPos));
        this.yposText.setText(Integer.toString(this.style.yPos));
        this.legWidthText.setText(Integer.toString(this.style.legendWidth));
        this.legHeightText.setText(Integer.toString(this.style.legendHeight));
        this.boxWidthText.setText(Integer.toString(this.style.boxWidth));
        this.forgroundAlphaText.setText(Integer.toString(this.style.fAlpha));
        this.backgroundAlphaText.setText(Integer.toString(this.style.bAlpha));
        this.isroundedButton.setSelection(this.style.isRoundedRectangle);
    }

    public void preApply() {
        this.updateBlackboard();
    }

    private void updateBlackboard() {
        IMap activeMap = ApplicationGIS.getActiveMap();
        IBlackboard styleBlackboard = activeMap.getBlackboard();
        this.style = (RasterLegendStyle)styleBlackboard.get("eu.hydrologis.jgrass.rasterlegend.rasterlegendStyle");
        if (this.style == null) {
            this.style = RasterLegendStyleContent.createDefault();
            styleBlackboard.put("eu.hydrologis.jgrass.rasterlegend.rasterlegendStyle", (Object)this.style);
        }
        RGB bg = this.backgroundColour.getColorValue();
        try {
            int bAlpha = Integer.parseInt(this.backgroundAlphaText.getText());
            this.style.backgroundColor = new Color(bg.red, bg.green, bg.blue, bAlpha);
        }
        catch (Exception exception) {
            this.style.backgroundColor = new Color(bg.red, bg.green, bg.blue);
        }
        bg = this.foregroundColor.getColorValue();
        try {
            int fAlpha = Integer.parseInt(this.forgroundAlphaText.getText());
            this.style.foregroundColor = new Color(bg.red, bg.green, bg.blue, fAlpha);
        }
        catch (Exception exception) {
            this.style.foregroundColor = new Color(bg.red, bg.green, bg.blue);
        }
        bg = this.fontColour.getColorValue();
        this.style.fontColor = new Color(bg.red, bg.green, bg.blue);
        this.style.titleString = this.titleText.getText();
        this.style.xPos = Integer.parseInt(this.xposText.getText());
        this.style.yPos = Integer.parseInt(this.yposText.getText());
        this.style.legendHeight = Integer.parseInt(this.legHeightText.getText());
        this.style.legendWidth = Integer.parseInt(this.legWidthText.getText());
        this.style.boxWidth = Integer.parseInt(this.boxWidthText.getText());
        this.style.isRoundedRectangle = this.isroundedButton.getSelection();
        styleBlackboard.put("eu.hydrologis.jgrass.rasterlegend.rasterlegendStyle", (Object)this.style);
    }

    public void widgetSelected(SelectionEvent e) {
        this.updateBlackboard();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.updateBlackboard();
    }

    public void modifyText(ModifyEvent e) {
    }
}

