/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.jgrass.legend;

import eu.udig.catalog.jgrass.activeregion.dialogs.JGRasterChooserDialog;
import eu.udig.catalog.jgrass.core.JGrassMapGeoResource;
import eu.udig.style.jgrass.legend.RasterLegendStyle;
import eu.udig.style.jgrass.legend.RasterLegendStyleContent;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.refractions.udig.mapgraphic.MapGraphic;
import net.refractions.udig.mapgraphic.MapGraphicContext;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.ui.graphics.ViewportGraphics;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.geotools.gce.grassraster.JGrassMapEnvironment;
import org.geotools.gce.grassraster.core.color.JGrassColorTable;

public class RasterLegendGraphic
implements MapGraphic {
    public static final String LEGEND_SEPERATOR = "|";
    private Thread run;
    private Display display;
    private Thread run2;
    private static Shell shell;
    private RasterLegendStyle legendStyle;

    public void draw(MapGraphicContext context) {
        String mapPath;
        IMap currentMap;
        IMap activeMap = ApplicationGIS.getActiveMap();
        if (!activeMap.equals(currentMap = context.getLayer().getMap())) {
            return;
        }
        context.getLayer().setStatus(5);
        this.display = Display.getDefault();
        this.setShell();
        IBlackboard blackboard = context.getMap().getBlackboard();
        this.legendStyle = (RasterLegendStyle)blackboard.get("eu.hydrologis.jgrass.rasterlegend.rasterlegendStyle");
        if (this.legendStyle == null) {
            this.legendStyle = RasterLegendStyleContent.createDefault();
            blackboard.put("eu.hydrologis.jgrass.rasterlegend.rasterlegendStyle", (Object)this.legendStyle);
        }
        if ((mapPath = this.legendStyle.mapPath) == null) {
            this.getMapPath(blackboard);
            mapPath = this.legendStyle.mapPath;
        }
        if (mapPath == null) {
            return;
        }
        File cellFile = new File(mapPath);
        if (!cellFile.exists()) {
            context.getLayer().setStatus(2);
            return;
        }
        JGrassMapEnvironment jGrassMapEnvironment = new JGrassMapEnvironment(cellFile);
        List categories = null;
        List colorRules = null;
        try {
            categories = jGrassMapEnvironment.getCategories();
            colorRules = jGrassMapEnvironment.getColorRules(null);
        }
        catch (IOException e) {
            e.printStackTrace();
            context.getLayer().setStatus(2);
            return;
        }
        ViewportGraphics graphics = context.getGraphics();
        if (categories.size() == 0 || categories.size() != colorRules.size()) {
            int rulesNum = colorRules.size();
            String titleString = this.legendStyle.titleString;
            int textheight = (int)Math.round(graphics.getStringBounds(titleString).getHeight());
            if (titleString.length() == 0) {
                textheight = 0;
            }
            int w = Math.round(this.legendStyle.legendWidth);
            int h = Math.round(this.legendStyle.legendHeight);
            int x = Math.round(this.legendStyle.xPos);
            int y = Math.round(this.legendStyle.yPos);
            int bWidth = Math.round(this.legendStyle.boxWidth);
            int bHeight = Math.round((float)(h - textheight) / (1.5f + (float)rulesNum));
            int yInset = bHeight / 2;
            int xInset = 15;
            int currentX = x + xInset;
            int currentY = y + yInset + textheight;
            if (textheight == 0) {
                currentY = y;
                h -= yInset;
            }
            if (this.legendStyle.isRoundedRectangle) {
                graphics.setColor(this.legendStyle.backgroundColor);
                graphics.fillRoundRect(Math.round(x), Math.round(y), Math.round(w), Math.round(h), 15, 15);
                graphics.setColor(this.legendStyle.foregroundColor);
                graphics.setBackground(this.legendStyle.backgroundColor);
                graphics.drawRoundRect(Math.round(x), Math.round(y), Math.round(w), Math.round(h), 15, 15);
            } else {
                graphics.setColor(this.legendStyle.backgroundColor);
                graphics.fillRect(Math.round(x), Math.round(y), Math.round(w), Math.round(h));
                graphics.setColor(this.legendStyle.foregroundColor);
                graphics.setBackground(this.legendStyle.backgroundColor);
                graphics.drawRect(Math.round(x), Math.round(y), Math.round(w), Math.round(h));
            }
            if (textheight != 0) {
                graphics.setColor(this.legendStyle.fontColor);
                graphics.drawString(titleString, currentX, currentY, -1, -1);
            }
            currentY += yInset;
            int i = 0;
            while (i < colorRules.size()) {
                String rule = (String)colorRules.get(i);
                double[] values = new double[2];
                Color[] colors = new Color[2];
                JGrassColorTable.parseColorRule((String)rule, (double[])values, (Color[])colors);
                String firstValue = String.valueOf(values[0]);
                Color actualColor = colors[0];
                String secondValue = String.valueOf(values[1]);
                Color nextColor = colors[1];
                graphics.fillGradientRectangle(currentX, currentY, bWidth, bHeight, actualColor, nextColor, true);
                int tx = Math.round((float)currentX + 1.5f * (float)bWidth);
                graphics.setColor(this.legendStyle.fontColor);
                graphics.drawString(String.format("%-8.2f", Float.valueOf(Float.parseFloat(firstValue))), tx, currentY, -1, 0);
                currentY += bHeight;
                if (i == colorRules.size() - 1) {
                    tx = Math.round((float)currentX + 1.5f * (float)bWidth);
                    graphics.setColor(this.legendStyle.fontColor);
                    graphics.drawString(String.format("%-8.2f", Float.valueOf(Float.parseFloat(secondValue))), tx, currentY, -1, 0);
                }
                ++i;
            }
        } else {
            int rulesNum = colorRules.size();
            String titleString = this.legendStyle.titleString;
            int textheight = (int)Math.round(graphics.getStringBounds(titleString).getHeight());
            if (titleString.length() == 0) {
                textheight = 0;
            }
            int w = Math.round(this.legendStyle.legendWidth);
            int h = Math.round(this.legendStyle.legendHeight);
            int x = Math.round(this.legendStyle.xPos);
            int y = Math.round(this.legendStyle.yPos);
            int bWidth = Math.round(this.legendStyle.boxWidth);
            int bHeight = Math.round((float)(h - textheight) / (1.5f + 1.3333334f * (float)rulesNum));
            int yInset = bHeight / 2;
            int xInset = 15;
            int currentX = x + xInset;
            int currentY = y + yInset + textheight;
            if (textheight == 0) {
                currentY = y;
                h = (int)((float)(h - yInset) - 0.33333334f * (float)bHeight);
            }
            if (this.legendStyle.isRoundedRectangle) {
                graphics.setColor(this.legendStyle.backgroundColor);
                graphics.fillRoundRect(Math.round(x), Math.round(y), Math.round(w), Math.round(h), 15, 15);
                graphics.setColor(this.legendStyle.foregroundColor);
                graphics.setBackground(this.legendStyle.backgroundColor);
                graphics.drawRoundRect(Math.round(x), Math.round(y), Math.round(w), Math.round(h), 15, 15);
            } else {
                graphics.setColor(this.legendStyle.backgroundColor);
                graphics.fillRect(Math.round(x), Math.round(y), Math.round(w), Math.round(h));
                graphics.setColor(this.legendStyle.foregroundColor);
                graphics.setBackground(this.legendStyle.backgroundColor);
                graphics.drawRect(Math.round(x), Math.round(y), Math.round(w), Math.round(h));
            }
            if (textheight != 0) {
                graphics.setColor(this.legendStyle.fontColor);
                graphics.drawString(titleString, currentX, currentY, -1, -1);
            }
            currentY += yInset;
            int i = 0;
            while (i < colorRules.size()) {
                String rule = (String)colorRules.get(i);
                String cat = (String)categories.get(i);
                int lastColon = cat.lastIndexOf(58);
                String attribute = cat.substring(lastColon + 1);
                double[] values = new double[2];
                Color[] colors = new Color[2];
                JGrassColorTable.parseColorRule((String)rule, (double[])values, (Color[])colors);
                String.valueOf(values[0]);
                graphics.setColor(Color.black);
                graphics.drawRect(currentX, currentY, bWidth, bHeight);
                graphics.setColor(colors[0]);
                graphics.fillRect(currentX, currentY, bWidth, bHeight);
                int tx = Math.round((float)currentX + 1.5f * (float)bWidth);
                int tHeight = (int)Math.round(graphics.getStringBounds(attribute).getHeight());
                graphics.setColor(this.legendStyle.fontColor);
                int ty = Math.round(currentY - graphics.getFontAscent() + tHeight);
                graphics.drawString(attribute, tx, ty, -1, 0);
                currentY = Math.round((float)currentY + 1.3333334f * (float)bHeight);
                ++i;
            }
        }
        System.out.println();
        context.getLayer().setStatus(0);
    }

    private void getMapPath(final IBlackboard blackboard) {
        this.run = new Thread(new Runnable(){

            @Override
            public void run() {
                RasterLegendGraphic.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        JGRasterChooserDialog chooserDialog = new JGRasterChooserDialog(null);
                        chooserDialog.open(shell, 4);
                        List resources = chooserDialog.getSelectedResources();
                        if (resources != null && resources.size() > 0) {
                            JGrassMapGeoResource res = (JGrassMapGeoResource)resources.get(0);
                            File mapFile = res.getMapFile();
                            ((RasterLegendGraphic)(this).RasterLegendGraphic.this).legendStyle.mapPath = mapFile.getAbsolutePath();
                            blackboard.put("eu.hydrologis.jgrass.rasterlegend.rasterlegendStyle", (Object)RasterLegendGraphic.this.legendStyle);
                        }
                    }
                });
            }
        });
        this.run.start();
        while (this.run.isAlive()) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void setShell() {
        if (shell != null) {
            return;
        }
        this.run2 = new Thread(new Runnable(){

            @Override
            public void run() {
                RasterLegendGraphic.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        RasterLegendGraphic.shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                    }
                });
            }
        });
        this.run2.start();
        while (this.run2.isAlive()) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

