/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.jgrass.legend;

import eu.udig.style.jgrass.legend.RasterLegendStyle;
import eu.udig.style.jgrass.legend.VectorLegendStyle;
import java.awt.Rectangle;
import net.refractions.udig.legend.ui.LegendStyle;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IStyleBlackboard;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.tool.ModalTool;
import net.refractions.udig.project.ui.tool.SimpleTool;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class MapgraphicDragger
extends SimpleTool
implements ModalTool {
    private IStyleBlackboard bBoard;
    private ILayer selectedLayer;
    private boolean goGo = true;
    private Point startPoint;
    private Point runningPoint;
    private RasterLegendStyle rasterLegendStyle;
    private VectorLegendStyle vectorLegendStyle;
    private Rectangle scaleBarRectangle;
    private LegendStyle legendStyle;

    public MapgraphicDragger() {
        super(3);
    }

    protected void onMousePressed(MapMouseEvent e) {
        super.onMousePressed(e);
        this.goGo = true;
        this.rasterLegendStyle = null;
        this.vectorLegendStyle = null;
        this.scaleBarRectangle = null;
        this.legendStyle = null;
        this.startPoint = new Point(e.x, e.y);
        this.selectedLayer = ApplicationGIS.getActiveMap().getEditManager().getSelectedLayer();
        this.bBoard = this.selectedLayer.getStyleBlackboard();
        this.rasterLegendStyle = (RasterLegendStyle)this.bBoard.get("eu.hydrologis.jgrass.rasterlegend.rasterlegendStyle");
        this.vectorLegendStyle = (VectorLegendStyle)this.bBoard.get("eu.hydrologis.jgrass.rasterlegend.vectorlegendStyle");
        this.scaleBarRectangle = (Rectangle)this.bBoard.get("net.refractions.udig.printing.ui.locationStyle");
        this.legendStyle = (LegendStyle)this.bBoard.get("net.refractions.udig.legend.legendStyle");
        if (this.selectedLayer == null || this.rasterLegendStyle == null && this.vectorLegendStyle == null && this.scaleBarRectangle == null && this.legendStyle == null) {
            this.goGo = false;
            Thread thread = new Thread(){

                @Override
                public void run() {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                            MessageDialog.openWarning((Shell)shell, (String)"Unsupported", (String)"The selected layer type is not supported.");
                        }
                    });
                }
            };
            thread.start();
        }
    }

    protected void onMouseDragged(MapMouseEvent e) {
        super.onMouseDragged(e);
        if (this.goGo) {
            this.runningPoint = new Point(e.x, e.y);
            int dx = this.runningPoint.x - this.startPoint.x;
            int dy = this.runningPoint.y - this.startPoint.y;
            if (this.rasterLegendStyle != null) {
                this.rasterLegendStyle.xPos += dx;
                this.rasterLegendStyle.yPos += dy;
            }
            if (this.vectorLegendStyle != null) {
                this.vectorLegendStyle.xPos += dx;
                this.vectorLegendStyle.yPos += dy;
            }
            if (this.scaleBarRectangle != null) {
                this.scaleBarRectangle.setLocation(this.scaleBarRectangle.x + dx, this.scaleBarRectangle.y + dy);
            }
            this.startPoint = this.runningPoint;
        }
    }

    protected void onMouseReleased(MapMouseEvent e) {
        this.selectedLayer.refresh(null);
        super.onMouseReleased(e);
    }
}

