/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.jgrass.colors;

import eu.udig.catalog.jgrass.activeregion.dialogs.JGRasterChooserDialog;
import eu.udig.catalog.jgrass.core.JGrassMapGeoResource;
import eu.udig.catalog.jgrass.core.JGrassMapsetGeoResource;
import eu.udig.catalog.jgrass.utils.JGrassCatalogUtilities;
import eu.udig.style.jgrass.JGrassrasterStyleActivator;
import eu.udig.style.jgrass.colors.Rule;
import eu.udig.style.jgrass.colors.RuleComposite;
import eu.udig.style.jgrass.core.GrassColorTable;
import eu.udig.style.jgrass.core.PredefinedColorRules;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.ui.ExceptionDetailsDialog;
import net.refractions.udig.ui.PlatformGIS;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.geotools.gce.grassraster.JGrassMapEnvironment;
import org.geotools.gce.grassraster.JGrassUtilities;
import org.geotools.gce.grassraster.core.color.ColorRule;
import org.geotools.gce.grassraster.core.color.JGrassColorTable;

public class ColorEditor
extends Composite
implements SelectionListener {
    private ArrayList<Rule> listOfRules = new ArrayList();
    private Button addRuleButton = null;
    private Button removeRuleButton = null;
    private Button moveRuleUpButton = null;
    private Button moveRuleDownButton = null;
    private Composite rulesComposite = null;
    private Group alphaGroup = null;
    private Scale alphaScale = null;
    private ScrolledComposite scrolledRulesComposite = null;
    private Layer layer;
    private String[] mapsetPathAndMapName;
    private File colrFile;
    private Label alphaLabel = null;
    private Button loadFromFileButton = null;
    private Button loadFromMapButton = null;
    private Button exportToFileButton = null;
    private Combo predefinedRulesCombo;
    private HashMap<String, String[][]> colorRulesMap;
    private Button resetColormapButton;

    public ColorEditor(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.verticalAlignment = 2;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.verticalAlignment = 2;
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 4;
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.verticalAlignment = 2;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        this.addRuleButton = new Button((Composite)this, 0);
        this.addRuleButton.setText("+");
        this.addRuleButton.setLayoutData((Object)gridData);
        this.addRuleButton.addSelectionListener((SelectionListener)this);
        this.removeRuleButton = new Button((Composite)this, 0);
        this.removeRuleButton.setText("-");
        this.removeRuleButton.setLayoutData((Object)gridData1);
        this.removeRuleButton.addSelectionListener((SelectionListener)this);
        this.moveRuleUpButton = new Button((Composite)this, 132);
        this.moveRuleUpButton.setLayoutData((Object)gridData2);
        this.moveRuleUpButton.addSelectionListener((SelectionListener)this);
        this.moveRuleDownButton = new Button((Composite)this, 1028);
        this.moveRuleDownButton.setLayoutData((Object)gridData3);
        this.moveRuleDownButton.addSelectionListener((SelectionListener)this);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = true;
        this.setLayout((Layout)gridLayout);
        GridData gd = new GridData(4, 4, true, true);
        this.setLayoutData(gd);
        this.createScrolledRulesComposite();
        GridData gridDataBC = new GridData();
        gridDataBC.horizontalAlignment = 4;
        gridDataBC.horizontalSpan = 4;
        gridDataBC.verticalAlignment = 2;
        Composite buttonComposite = new Composite((Composite)this, 0);
        buttonComposite.setLayoutData((Object)gridDataBC);
        buttonComposite.setLayout((Layout)new GridLayout(8, true));
        GridData loadGD = new GridData(4, 0x1000000, true, false);
        loadGD.horizontalSpan = 2;
        GridData loadFMapGD = new GridData(4, 0x1000000, true, false);
        loadFMapGD.horizontalSpan = 2;
        GridData exportGD = new GridData(4, 0x1000000, true, false);
        exportGD.horizontalSpan = 2;
        GridData resetGD = new GridData(4, 0x1000000, true, false);
        resetGD.horizontalSpan = 2;
        this.loadFromMapButton = new Button(buttonComposite, 0);
        this.loadFromMapButton.setText("load from map");
        this.loadFromMapButton.setLayoutData((Object)loadFMapGD);
        this.loadFromMapButton.addSelectionListener((SelectionListener)this);
        this.loadFromFileButton = new Button(buttonComposite, 0);
        this.loadFromFileButton.setText("import colormap");
        this.loadFromFileButton.setLayoutData((Object)loadGD);
        this.loadFromFileButton.addSelectionListener((SelectionListener)this);
        this.exportToFileButton = new Button(buttonComposite, 0);
        this.exportToFileButton.setText("export colormap");
        this.exportToFileButton.setLayoutData((Object)resetGD);
        this.exportToFileButton.addSelectionListener((SelectionListener)this);
        this.resetColormapButton = new Button(buttonComposite, 0);
        this.resetColormapButton.setText("reset colormap");
        this.resetColormapButton.setLayoutData((Object)resetGD);
        this.resetColormapButton.addSelectionListener((SelectionListener)this);
        Label predefinedRulesLabel = new Label(buttonComposite, 0);
        GridData rulesLabelGD = new GridData(4, 0x1000000, true, false);
        rulesLabelGD.horizontalSpan = 3;
        predefinedRulesLabel.setLayoutData((Object)rulesLabelGD);
        predefinedRulesLabel.setText("Set from predefined table");
        this.predefinedRulesCombo = new Combo(buttonComposite, 12);
        GridData comboGD = new GridData(4, 0x1000000, true, false);
        comboGD.horizontalSpan = 5;
        this.predefinedRulesCombo.setLayoutData((Object)comboGD);
        this.colorRulesMap = PredefinedColorRules.getColorsFolder(true);
        Set<String> keySet = this.colorRulesMap.keySet();
        Object[] rulesNames = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(rulesNames);
        this.predefinedRulesCombo.setItems((String[])rulesNames);
        this.predefinedRulesCombo.addSelectionListener((SelectionListener)this);
        this.createRulesComposite();
        this.createAlphaGroup();
    }

    private void createRulesComposite() {
        GridData gridData4 = new GridData();
        gridData4.horizontalSpan = 4;
        gridData4.verticalAlignment = 4;
        gridData4.grabExcessHorizontalSpace = true;
        gridData4.grabExcessVerticalSpace = true;
        gridData4.horizontalAlignment = 4;
        this.rulesComposite = new Composite((Composite)this.scrolledRulesComposite, 0);
        this.rulesComposite.setLayout((Layout)new GridLayout());
        this.rulesComposite.setLayoutData((Object)gridData4);
        this.scrolledRulesComposite.setContent((Control)this.rulesComposite);
    }

    private void createScrolledRulesComposite() {
        GridData gridData7 = new GridData();
        gridData7.horizontalSpan = 4;
        gridData7.verticalAlignment = 4;
        gridData7.grabExcessVerticalSpace = true;
        gridData7.grabExcessHorizontalSpace = true;
        gridData7.horizontalAlignment = 4;
        this.scrolledRulesComposite = new ScrolledComposite((Composite)this, 2560);
        this.scrolledRulesComposite.setLayoutData((Object)gridData7);
        this.scrolledRulesComposite.setExpandHorizontal(true);
        this.scrolledRulesComposite.setExpandVertical(true);
        this.scrolledRulesComposite.setMinHeight(2000);
    }

    private void createAlphaGroup() {
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 4;
        GridData gridData6 = new GridData();
        gridData6.horizontalAlignment = 4;
        gridData6.grabExcessHorizontalSpace = true;
        gridData6.horizontalSpan = 3;
        gridData6.verticalAlignment = 2;
        GridData gridData5 = new GridData();
        gridData5.horizontalSpan = 4;
        gridData5.verticalAlignment = 2;
        gridData5.grabExcessHorizontalSpace = true;
        gridData5.horizontalAlignment = 4;
        this.alphaGroup = new Group((Composite)this, 0);
        this.alphaGroup.setLayoutData((Object)gridData5);
        this.alphaGroup.setLayout((Layout)gridLayout1);
        this.alphaGroup.setText("alpha");
        this.alphaScale = new Scale((Composite)this.alphaGroup, 0);
        this.alphaScale.setLayoutData((Object)gridData6);
        this.alphaScale.setMinimum(0);
        this.alphaScale.setMaximum(255);
        this.alphaScale.setPageIncrement(5);
        this.alphaScale.setSelection(255);
        this.alphaLabel = new Label((Composite)this.alphaGroup, 0);
        this.alphaLabel.setText(String.valueOf(this.alphaScale.getSelection()));
        this.alphaScale.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int perspectiveValue = ColorEditor.this.alphaScale.getSelection();
                ColorEditor.this.alphaLabel.setText(String.valueOf(perspectiveValue));
            }
        });
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Combo combo;
        Object source = e.getSource();
        if (source instanceof Button) {
            String path;
            Rule r;
            Button selectedButton = (Button)source;
            if (selectedButton.equals(this.addRuleButton)) {
                Rule r2 = new Rule();
                this.listOfRules.add(r2);
                this.redoLayout();
            } else if (selectedButton.equals(this.removeRuleButton)) {
                int i = 0;
                while (i < this.listOfRules.size()) {
                    r = this.listOfRules.get(i);
                    if (r.isActive()) {
                        this.listOfRules.remove(r);
                    }
                    ++i;
                }
                this.redoLayout();
            } else if (selectedButton.equals(this.moveRuleUpButton)) {
                int i = 0;
                while (i < this.listOfRules.size()) {
                    r = this.listOfRules.get(i);
                    if (r.isActive() && i > 0) {
                        this.listOfRules.remove(r);
                        this.listOfRules.add(i - 1, r);
                    }
                    ++i;
                }
                this.redoLayout();
            } else if (selectedButton.equals(this.moveRuleDownButton)) {
                int i = 0;
                while (i < this.listOfRules.size()) {
                    r = this.listOfRules.get(i);
                    if (r.isActive() && i < this.listOfRules.size() - 1) {
                        this.listOfRules.remove(r);
                        this.listOfRules.add(i + 1, r);
                        ++i;
                    }
                    ++i;
                }
                this.redoLayout();
            } else if (selectedButton.equals(this.loadFromFileButton)) {
                FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
                path = fileDialog.open();
                if (path == null) {
                    return;
                }
                this.makeSomeColor(path);
            } else if (selectedButton.equals(this.loadFromMapButton)) {
                JGRasterChooserDialog tree = new JGRasterChooserDialog(null);
                tree.open(this.getShell(), 4);
                this.update(tree.getSelectedResources());
            } else if (selectedButton.equals(this.exportToFileButton)) {
                FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
                fileDialog.setText("Choose file");
                path = fileDialog.open();
                try {
                    FileUtils.copyFile((File)this.colrFile, (File)new File(path));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            } else if (selectedButton.equals(this.resetColormapButton)) {
                IRunnableWithProgress operation = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            File cellFile = new File(String.valueOf(ColorEditor.this.mapsetPathAndMapName[0]) + File.separator + "cell" + File.separator + ColorEditor.this.mapsetPathAndMapName[1]);
                            JGrassMapEnvironment mE = new JGrassMapEnvironment(cellFile);
                            double[] dataRange = mE.getRangeFromMapScan();
                            List defColorTable = JGrassColorTable.createDefaultColorTable((double[])dataRange, (int)255);
                            File colrFile = mE.getCOLR();
                            JGrassUtilities.makeColorRulesPersistent((File)colrFile, (List)defColorTable, (double[])dataRange, (int)255);
                            ColorEditor.this.makeSomeColor(colrFile.getAbsolutePath());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            String message = "An error occurred while persisting the colortable to disk.";
                            ExceptionDetailsDialog.openError(null, (String)message, (int)4, (String)"eu.udig.style.jgrass", (Throwable)e);
                            return;
                        }
                    }
                };
                PlatformGIS.runInProgressDialog((String)"Resetting colormap", (boolean)true, (IRunnableWithProgress)operation, (boolean)true);
            }
        }
        if (source instanceof Combo && (combo = (Combo)source).equals(this.predefinedRulesCombo)) {
            int selectionIndex = this.predefinedRulesCombo.getSelectionIndex();
            String item = this.predefinedRulesCombo.getItem(selectionIndex);
            try {
                String[][] colorRules = this.colorRulesMap.get(item);
                GrassColorTable.setColorTableFromRules(this.colrFile, null, colorRules);
                this.makeSomeColor(this.colrFile.getAbsolutePath());
            }
            catch (IOException e1) {
                MessageDialog.openError((Shell)this.getShell(), (String)"ERROR", (String)("An error occurred while setting the colortable: " + this.colrFile.getAbsolutePath()));
                e1.printStackTrace();
            }
        }
    }

    private void makeSomeColor(String colrpath) {
        GrassColorTable ctable = null;
        Enumeration<ColorRule> rules = null;
        try {
            while (rules == null || !rules.hasMoreElements()) {
                try {
                    ctable = new GrassColorTable(colrpath, null);
                }
                catch (IOException e1) {
                    JGrassrasterStyleActivator.log("JGrassrasterStyleActivator problem", e1);
                    e1.printStackTrace();
                }
                rules = ctable.getColorRules();
                if (rules != null && rules.hasMoreElements()) continue;
                ctable.createDefaultColorRulesString(null, true);
            }
        }
        catch (Exception e) {
            JGrassrasterStyleActivator.log("JGrassrasterStyleActivator problem: eu.hydrologis.jgrass.style.jgrassraster.colors#ColorEditor#makeSomeColor", e);
            e.printStackTrace();
        }
        ArrayList<Rule> listOfRules = new ArrayList<Rule>();
        while (rules.hasMoreElements()) {
            ColorRule element = rules.nextElement();
            float lowvalue = element.getLowCategoryValue();
            float highvalue = element.getLowCategoryValue() + element.getCategoryRange();
            byte[] lowcatcol = element.getColor(lowvalue);
            byte[] highcatcol = element.getColor(highvalue);
            float[] lowHigh = new float[]{lowvalue, highvalue};
            Color lowColor = new Color((Device)Display.getDefault(), lowcatcol[0] & 0xFF, lowcatcol[1] & 0xFF, lowcatcol[2] & 0xFF);
            Color highColor = new Color((Device)Display.getDefault(), highcatcol[0] & 0xFF, highcatcol[1] & 0xFF, highcatcol[2] & 0xFF);
            listOfRules.add(new Rule(lowHigh, lowColor, highColor, true));
        }
        this.setLayer(this.layer);
        this.setAlphaValue(ctable.getAlpha());
        this.setRulesList(listOfRules);
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
        IGeoResource resource = layer.getGeoResource();
        this.mapsetPathAndMapName = JGrassCatalogUtilities.getMapsetpathAndMapnameFromJGrassMapGeoResource((IGeoResource)resource);
        this.colrFile = new File(String.valueOf(this.mapsetPathAndMapName[0]) + File.separator + "colr" + File.separator + this.mapsetPathAndMapName[1]);
    }

    public void setAlphaValue(final int value) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ColorEditor.this.alphaScale.setSelection(value);
                ColorEditor.this.alphaLabel.setText(String.valueOf(value));
            }
        });
    }

    public void setRulesList(ArrayList<Rule> listOfRules) {
        this.listOfRules = listOfRules;
        this.redoLayout();
    }

    protected void redoLayout() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Control[] rulesControls = ColorEditor.this.rulesComposite.getChildren();
                int i = 0;
                while (i < rulesControls.length) {
                    rulesControls[i].dispose();
                    ++i;
                }
                for (Rule rule : ColorEditor.this.listOfRules) {
                    new RuleComposite(ColorEditor.this, ColorEditor.this.rulesComposite, 2048, rule);
                }
                ColorEditor.this.rulesComposite.layout();
            }
        });
    }

    public synchronized void makePersistent() {
        if (this.colrFile != null) {
            BufferedWriter bw = null;
            try {
                bw = new BufferedWriter(new FileWriter(this.colrFile));
                if (this.listOfRules.size() == 0) {
                    return;
                }
                try {
                    float[] dataRange = new float[]{this.listOfRules.get(0).getFromToValues()[0], this.listOfRules.get(this.listOfRules.size() - 1).getFromToValues()[1]};
                    String header = "% " + dataRange[0] + "   " + dataRange[1] + "   " + this.alphaLabel.getText();
                    bw.write(String.valueOf(header) + "\n");
                    for (Rule r : this.listOfRules) {
                        if (!r.isActive()) continue;
                        bw.write(String.valueOf(r.ruleToString()) + "\n");
                    }
                }
                catch (IOException e1) {
                    JGrassrasterStyleActivator.log("JGrassrasterStyleActivator problem", e1);
                    e1.printStackTrace();
                }
            }
            finally {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    JGrassrasterStyleActivator.log("JGrassrasterStyleActivator problem", e);
                }
            }
        }
    }

    public void update(Object updatedObject) {
        if (updatedObject instanceof List) {
            String mapName = null;
            String mapsetPath = null;
            List layers = (List)updatedObject;
            for (Object layer : layers) {
                if (!(layer instanceof JGrassMapGeoResource)) continue;
                JGrassMapGeoResource rasterMapResource = (JGrassMapGeoResource)layer;
                try {
                    mapName = rasterMapResource.getInfo(null).getTitle();
                    mapsetPath = ((JGrassMapsetGeoResource)rasterMapResource.parent(null)).getFile().getAbsolutePath();
                    if (mapName == null || mapsetPath == null) continue;
                    String colrPath = String.valueOf(mapsetPath) + File.separator + "colr" + File.separator + mapName;
                    this.makeSomeColor(colrPath);
                }
                catch (IOException e) {
                    JGrassrasterStyleActivator.log("JGrassrasterStyleActivator problem", e);
                    e.printStackTrace();
                }
            }
        }
    }
}

