/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.arcsde;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveChangeEvent;
import net.refractions.udig.catalog.IResolveDelta;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceInfo;
import net.refractions.udig.catalog.internal.CatalogImpl;
import net.refractions.udig.catalog.internal.ResolveChangeEvent;
import net.refractions.udig.catalog.internal.ResolveDelta;
import net.refractions.udig.catalog.internal.arcsde.ArcSDERasterService;
import net.refractions.udig.catalog.internal.arcsde.ArcSDEVectorService;
import net.refractions.udig.catalog.internal.arcsde.ArcsdePlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.geotools.arcsde.data.ArcSDEDataStoreConfig;
import org.geotools.arcsde.session.ArcSDEConnectionConfig;
import org.geotools.data.DataStore;

public class ArcServiceImpl
extends IService {
    private final URL url;
    private Throwable msg;
    private ArcSDEVectorService vectorService;
    private ArcSDERasterService rasterService;
    private volatile List<IGeoResource> members;
    private final ArcSDEDataStoreConfig dataStoreConfig;

    public ArcServiceImpl(URL url, Map<String, Serializable> params) {
        this.url = url;
        this.dataStoreConfig = new ArcSDEDataStoreConfig(params);
        this.vectorService = new ArcSDEVectorService(this);
        this.rasterService = new ArcSDERasterService(this);
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (adaptee == null) {
            throw new NullPointerException("No adaptor specified");
        }
        if (adaptee.isAssignableFrom(DataStore.class)) {
            try {
                return adaptee.cast(this.vectorService.getDataStore(monitor));
            }
            catch (IOException e) {
                this.msg = e;
                throw e;
            }
            catch (Exception e) {
                this.msg = e;
                throw (IOException)new IOException(e.getLocalizedMessage()).initCause(e);
            }
        }
        return (T)super.resolve(adaptee, monitor);
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        if (adaptee.isAssignableFrom(DataStore.class)) {
            return true;
        }
        return super.canResolve(adaptee);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IGeoResource> resources(IProgressMonitor monitor) throws IOException {
        if (this.members == null) {
            ArcServiceImpl arcServiceImpl = this;
            synchronized (arcServiceImpl) {
                if (this.members == null) {
                    this.members = new ArrayList<IGeoResource>();
                    if (this.vectorService != null) {
                        this.members.addAll(this.vectorService.resources(monitor));
                    }
                    if (this.rasterService != null) {
                        this.members.addAll(this.rasterService.resources(monitor));
                    }
                    ResolveDelta delta = new ResolveDelta((IResolve)this, IResolveDelta.Kind.CHANGED);
                    ((CatalogImpl)CatalogPlugin.getDefault().getLocalCatalog()).fire((IResolveChangeEvent)new ResolveChangeEvent((Object)this, IResolveChangeEvent.Type.POST_CHANGE, (IResolveDelta)delta));
                }
            }
        }
        return this.members;
    }

    public IServiceArcSDEInfo getInfo(IProgressMonitor monitor) throws IOException {
        return (IServiceArcSDEInfo)super.getInfo(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IServiceInfo createInfo(IProgressMonitor monitor) throws IOException {
        if (this.info == null) {
            ArcServiceImpl arcServiceImpl = this;
            synchronized (arcServiceImpl) {
                if (this.info == null) {
                    URL identifier = this.getIdentifier();
                    this.info = new IServiceArcSDEInfo(identifier, this.dataStoreConfig.getSessionConfig());
                }
            }
            ResolveDelta delta = new ResolveDelta((IResolve)this, IResolveDelta.Kind.CHANGED);
            ((CatalogImpl)CatalogPlugin.getDefault().getLocalCatalog()).fire((IResolveChangeEvent)new ResolveChangeEvent((Object)this, IResolveChangeEvent.Type.POST_CHANGE, (IResolveDelta)delta));
        }
        return this.info;
    }

    public Map<String, Serializable> getConnectionParams() {
        return this.dataStoreConfig == null ? null : this.dataStoreConfig.toMap();
    }

    public IResolve.Status getStatus() {
        if (this.vectorService == null) {
            return super.getStatus();
        }
        return IResolve.Status.CONNECTED;
    }

    public Throwable getMessage() {
        return this.msg;
    }

    public URL getIdentifier() {
        return this.url;
    }

    public ArcSDEDataStoreConfig getDataStoreConfig() {
        return this.dataStoreConfig;
    }

    public ArcSDEConnectionConfig getConnectionConfig() {
        return this.dataStoreConfig.getSessionConfig();
    }

    public ArcSDEVectorService getVectorService() {
        return this.vectorService;
    }

    private static class IServiceArcSDEInfo
    extends IServiceInfo {
        private final URL identifier;

        IServiceArcSDEInfo(URL identifier, ArcSDEConnectionConfig connectionConfig) {
            this.identifier = identifier;
            try {
                this.schema = new URI("arcsde://geotools/gml");
            }
            catch (URISyntaxException e) {
                ArcsdePlugin.log(null, e);
            }
            this.icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.refractions.udig.catalog.arcsde", (String)"icons/obj16/arcsde_obj.gif");
        }

        public String getDescription() {
            return this.identifier.toString();
        }

        public URI getSource() {
            try {
                return this.identifier.toURI();
            }
            catch (URISyntaxException e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
        }

        public String getTitle() {
            return "ARCSDE " + this.identifier.getHost();
        }
    }
}

