/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.arcsde;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.internal.arcsde.ArcSDEService;
import net.refractions.udig.catalog.internal.arcsde.ArcSDEVectorGeoResource;
import net.refractions.udig.catalog.internal.arcsde.ArcServiceImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.arcsde.ArcSDEDataStoreFactory;
import org.geotools.arcsde.data.ArcSDEDataStore;
import org.geotools.arcsde.data.ArcSDEDataStoreConfig;
import org.geotools.arcsde.session.ISessionPool;
import org.geotools.data.DataStore;

class ArcSDEVectorService
extends ArcSDEService {
    private volatile ArcSDEDataStore ds;

    public ArcSDEVectorService(ArcServiceImpl service) {
        super(service);
    }

    @Override
    protected List<IGeoResource> createMembers(IProgressMonitor monitor) throws IOException {
        this.getDS(null);
        String[] typenames = this.ds.getTypeNames();
        ArrayList<IGeoResource> members = new ArrayList<IGeoResource>(typenames.length);
        int i = 0;
        while (i < typenames.length) {
            ArcSDEVectorGeoResource resource = new ArcSDEVectorGeoResource(this.service, typenames[i]);
            members.add(resource);
            ++i;
        }
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ArcSDEDataStore getDS(IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (this.ds != null) return this.ds;
        Class<ArcSDEDataStoreFactory> clazz = ArcSDEDataStoreFactory.class;
        synchronized (ArcSDEDataStoreFactory.class) {
            if (this.ds != null) return this.ds;
            ISessionPool sessionPool = this.getSessionPool();
            this.ds = this.connect(sessionPool, monitor);
            return this.ds;
        }
    }

    private ArcSDEDataStore connect(ISessionPool sessionPool, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ArcSDEDataStoreConfig dsConfig = this.service.getDataStoreConfig();
        String namespaceUri = dsConfig.getNamespaceUri();
        String versionName = dsConfig.getVersion();
        boolean allowNonSpatialTables = dsConfig.isAllowNonSpatialTables();
        ArcSDEDataStore ds = new ArcSDEDataStore(sessionPool, namespaceUri, versionName, allowNonSpatialTables);
        return ds;
    }

    public DataStore getDataStore(IProgressMonitor monitor) throws IOException {
        return this.getDS(monitor);
    }
}

