/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.arcsde;

import java.io.IOException;
import java.util.List;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.internal.arcsde.ArcServiceImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.arcsde.jndi.SharedSessionPool;
import org.geotools.arcsde.session.ArcSDEConnectionConfig;
import org.geotools.arcsde.session.ISessionPool;
import org.geotools.arcsde.session.ISessionPoolFactory;
import org.geotools.arcsde.session.SessionPoolFactory;

abstract class ArcSDEService {
    protected final ArcServiceImpl service;
    protected final ArcSDEConnectionConfig connectionConfig;
    private volatile ISessionPool sessionPool;

    public ArcSDEService(ArcServiceImpl service) {
        this.service = service;
        this.connectionConfig = service.getConnectionConfig();
    }

    public final List<IGeoResource> resources(IProgressMonitor monitor) throws IOException {
        List<IGeoResource> members = this.createMembers(monitor);
        return members;
    }

    protected abstract List<IGeoResource> createMembers(IProgressMonitor var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISessionPool getSessionPool() throws IOException {
        if (this.sessionPool == null) {
            ArcSDEConnectionConfig arcSDEConnectionConfig = this.connectionConfig;
            synchronized (arcSDEConnectionConfig) {
                if (this.sessionPool == null) {
                    ISessionPoolFactory fact = SessionPoolFactory.getInstance();
                    this.sessionPool = SharedSessionPool.getInstance((ArcSDEConnectionConfig)this.connectionConfig, (ISessionPoolFactory)fact);
                }
            }
        }
        return this.sessionPool;
    }

    public void dispose() {
        if (this.sessionPool != null) {
            this.sessionPool.close();
        }
    }

    protected void finalize() {
        this.dispose();
    }
}

