/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.arcsde;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.internal.arcsde.ArcServiceImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.geotools.arcsde.ArcSDERasterFormatFactory;
import org.geotools.arcsde.raster.gce.ArcSDERasterFormat;
import org.geotools.arcsde.session.ArcSDEConnectionConfig;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.data.ServiceInfo;
import org.geotools.geometry.GeneralEnvelope;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ArcSDERasterGeoResource
extends IGeoResource {
    private String name;
    private IResolve.Status status;
    private Throwable msg;

    public ArcSDERasterGeoResource(ArcServiceImpl service, String name) {
        this.service = service;
        this.name = name;
        this.status = IResolve.Status.NOTCONNECTED;
    }

    protected IGeoResourceInfo createInfo(IProgressMonitor monitor) throws IOException {
        try {
            AbstractGridCoverage2DReader reader = this.getReader(monitor);
            ServiceInfo serviceInfo = reader.getInfo();
            String name = serviceInfo.getTitle();
            String title = serviceInfo.getTitle();
            String description = serviceInfo.getDescription();
            URI schema = serviceInfo.getSchema();
            String[] keywords = serviceInfo.getKeywords().toArray(new String[serviceInfo.getKeywords().size()]);
            GeneralEnvelope env = reader.getOriginalEnvelope();
            Envelope bounds = new Envelope(env.getMinimum(0), env.getMaximum(0), env.getMinimum(1), env.getMaximum(1));
            CoordinateReferenceSystem crs = reader.getCrs();
            ImageDescriptor icon = null;
            IGeoResourceInfo rasterInfo = new IGeoResourceInfo(title, name, description, schema, bounds, crs, keywords, icon);
            return rasterInfo;
        }
        catch (Exception e) {
            this.msg = e;
            this.status = IResolve.Status.BROKEN;
            throw (IOException)new IOException(e.getLocalizedMessage()).initCause(e);
        }
    }

    public ArcServiceImpl service(IProgressMonitor monitor) throws IOException {
        return (ArcServiceImpl)this.service;
    }

    public URL getIdentifier() {
        try {
            return new URL(String.valueOf(this.service.getIdentifier().toString()) + "#" + this.name);
        }
        catch (MalformedURLException malformedURLException) {
            return this.service.getIdentifier();
        }
    }

    public Throwable getMessage() {
        return this.msg;
    }

    public IResolve.Status getStatus() {
        return this.status;
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        return adaptee != null && (adaptee.isAssignableFrom(GridCoverage.class) || adaptee.isAssignableFrom(AbstractGridCoverage2DReader.class) || super.canResolve(adaptee));
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (adaptee == null) {
            throw new NullPointerException("No adaptor specified");
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (adaptee.isAssignableFrom(AbstractGridCoverage2DReader.class)) {
            AbstractGridCoverage2DReader reader = this.getReader(monitor);
            this.status = IResolve.Status.CONNECTED;
            return adaptee.cast(reader);
        }
        return (T)super.resolve(adaptee, monitor);
    }

    private AbstractGridCoverage2DReader getReader(IProgressMonitor monitor) {
        String source = this.getCoverageURL();
        ArcSDERasterFormatFactory formatFactory = new ArcSDERasterFormatFactory();
        ArcSDERasterFormat format = formatFactory.createFormat();
        AbstractGridCoverage2DReader reader = format.getReader((Object)source);
        return reader;
    }

    private String getCoverageURL() {
        ArcSDEConnectionConfig config = ((ArcServiceImpl)this.service).getConnectionConfig();
        return ArcSDERasterFormat.createRasterURL((ArcSDEConnectionConfig)config, (String)this.name);
    }
}

