/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.config.Config;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

class CleanupThread
extends Thread {
    private ArrayList nonJarItemRemovalList = new ArrayList();
    private ArrayList jarItemRemovalList = new ArrayList();
    private ArrayList loadedResourceList = new ArrayList();
    private static final double CACHE_THRESHOLD_PERCENT = 0.98;
    private final Object syncObject;
    private final long currentCacheMaxSize = Config.getCacheSizeMax();
    private volatile long currentCacheSize = 0L;
    private boolean initCacheSize = true;

    CleanupThread(String string, Object object) {
        super(string);
        this.setDaemon(true);
        this.syncObject = object;
    }

    synchronized void addToLoadedResourceList(String string) {
        this.loadedResourceList.add(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startCleanup() {
        CleanupThread cleanupThread = this;
        synchronized (cleanupThread) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCurrentCacheSize() {
        long l = 0L;
        File[] fileArray = CleanupThread.getCacheResourceFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string = fileArray[i].getPath();
            File file = null;
            if (fileArray[i].isDirectory()) {
                if (!fileArray[i].getName().toLowerCase().endsWith("-n")) {
                    CleanupThread.deleteFileOrDirectory(fileArray[i]);
                    continue;
                }
                file = new File(string.substring(0, string.length() - 2) + ".idx");
                if (file.exists()) continue;
                CleanupThread.deleteFileOrDirectory(fileArray[i]);
                continue;
            }
            file = new File(string + ".idx");
            if (file.exists()) {
                CacheEntry cacheEntry = Cache.getCacheEntryFromFile(file);
                if (cacheEntry != null) {
                    l += file.length();
                    l += fileArray[i].length();
                    l += CleanupThread.getFileOrDirectorySize(new File(cacheEntry.getNativeLibPath()));
                    boolean bl = true;
                    String string2 = cacheEntry.getURL().toLowerCase();
                    CleanupThread cleanupThread = this;
                    synchronized (cleanupThread) {
                        if (string2.endsWith(".jnlp") || string2.endsWith(".jarjnlp") || cacheEntry.getIsShortcutImage() == 1 || MemoryCache.contains(cacheEntry.getURL()) || this.loadedResourceList.contains(cacheEntry.getURL()) || cacheEntry.getBusy() == 1) {
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    if (string2.endsWith(".jar") || string2.endsWith(".jarjar") || string2.endsWith(".zip")) {
                        if (this.jarItemRemovalList.contains(fileArray[i].getPath())) continue;
                        this.jarItemRemovalList.add(fileArray[i].getPath());
                        continue;
                    }
                    if (this.nonJarItemRemovalList.contains(fileArray[i].getPath())) continue;
                    this.nonJarItemRemovalList.add(fileArray[i].getPath());
                    continue;
                }
                if (!file.delete()) {
                    file.deleteOnExit();
                }
                if (!fileArray[i].delete()) {
                    fileArray[i].deleteOnExit();
                }
                CleanupThread.deleteFileOrDirectory(new File(string + "-n"));
                continue;
            }
            if (fileArray[i].delete()) continue;
            fileArray[i].deleteOnExit();
        }
        return l;
    }

    private static File[] getCacheResourceFiles() {
        File file = Cache.getCacheDir();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < 64; ++i) {
            File file2 = new File(file.getPath() + File.separator + i);
            if (!file2.exists() || !file2.isDirectory()) continue;
            File[] fileArray = file2.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    String string = file.getName().toLowerCase();
                    return !string.endsWith(".idx") && !string.endsWith(".lap") && !string.endsWith(".ico") && !string.endsWith("-temp");
                }
            });
            for (int j = 0; j < fileArray.length; ++j) {
                arrayList.add(fileArray[j]);
            }
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private static long getFileOrDirectorySize(File file) {
        long l = 0L;
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    l += CleanupThread.getFileOrDirectorySize(fileArray[i]);
                }
            } else {
                l += file.length();
            }
        }
        return l;
    }

    private static void deleteFileOrDirectory(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    CleanupThread.deleteFileOrDirectory(fileArray[i]);
                }
            }
            file.delete();
        }
    }

    private Object[] prepareRemovalList(ArrayList arrayList) {
        Object object;
        ArrayList<CacheEntry> arrayList2 = new ArrayList<CacheEntry>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            File file = new File((String)object + ".idx");
            if (!file.exists()) continue;
            CacheEntry cacheEntry = Cache.getCacheEntryFromFile(file);
            arrayList2.add(cacheEntry);
        }
        object = arrayList2.toArray();
        Arrays.sort(object, new Comparator(){

            public int compare(Object object, Object object2) {
                CacheEntry cacheEntry = (CacheEntry)object;
                CacheEntry cacheEntry2 = (CacheEntry)object2;
                if (cacheEntry.removeBefore(cacheEntry2)) {
                    return -1;
                }
                if (cacheEntry2.removeBefore(cacheEntry)) {
                    return 1;
                }
                return 0;
            }
        });
        return object;
    }

    private void removeResourceFromList(Object[] objectArray) {
        long l = (long)((double)this.currentCacheMaxSize * 0.98);
        for (int i = 0; i < objectArray.length && this.currentCacheSize >= l; ++i) {
            CacheEntry cacheEntry = (CacheEntry)objectArray[i];
            long l2 = cacheEntry.getIndexFile().length() + new File(cacheEntry.getResourceFilename()).length() + CleanupThread.getFileOrDirectorySize(new File(cacheEntry.getNativeLibPath()));
            Cache.removeCacheEntry(cacheEntry);
            this.currentCacheSize -= l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                while (true) {
                    CleanupThread cleanupThread = this;
                    synchronized (cleanupThread) {
                        this.wait();
                    }
                    long l = SystemUtils.microTime();
                    Object object = this.syncObject;
                    synchronized (object) {
                        if (this.initCacheSize) {
                            this.currentCacheSize = this.getCurrentCacheSize();
                            this.initCacheSize = false;
                        }
                        if (this.currentCacheMaxSize != -1L && this.currentCacheSize >= this.currentCacheMaxSize) {
                            Object[] objectArray = this.prepareRemovalList(this.nonJarItemRemovalList);
                            this.removeResourceFromList(objectArray);
                            objectArray = this.prepareRemovalList(this.jarItemRemovalList);
                            this.removeResourceFromList(objectArray);
                        }
                    }
                    long l2 = SystemUtils.microTime() - l;
                    Trace.println("CleanupThread used " + l2 + " us", TraceLevel.NETWORK);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

