/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mysql;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LinearRing;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.filter.FilterCapabilities;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public class MySQLFilterToSQL
extends FilterToSQL {
    @Override
    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities caps = super.createFilterCapabilities();
        caps.addType(BBOX.class);
        caps.addType(Contains.class);
        caps.addType(Disjoint.class);
        caps.addType(Equals.class);
        caps.addType(Intersects.class);
        caps.addType(Overlaps.class);
        caps.addType(Touches.class);
        caps.addType(Within.class);
        caps.addType(Beyond.class);
        return caps;
    }

    @Override
    protected void visitLiteralGeometry(Literal expression) throws IOException {
        Geometry g = (Geometry)this.evaluateLiteral(expression, Geometry.class);
        if (g instanceof LinearRing) {
            g = g.getFactory().createLineString(((LinearRing)g).getCoordinateSequence());
        }
        this.out.write("GeomFromText('" + g.toText() + "', " + this.currentSRID + ")");
    }

    @Override
    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        return this.visitBinarySpatialOperator(filter, (Expression)property, (Expression)geometry, swapped, extraData);
    }

    @Override
    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, Object extraData) {
        return this.visitBinarySpatialOperator(filter, e1, e2, false, extraData);
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, boolean swapped, Object extraData) {
        try {
            if (!(filter instanceof Disjoint)) {
                this.out.write("MbrIntersects(");
                e1.accept((ExpressionVisitor)this, extraData);
                this.out.write(",");
                e2.accept((ExpressionVisitor)this, extraData);
                this.out.write(")");
                if (!(filter instanceof BBOX)) {
                    this.out.write(" AND ");
                }
            }
            if (filter instanceof BBOX) {
                return extraData;
            }
            if (filter instanceof DistanceBufferOperator) {
                this.out.write("Distance(");
                e1.accept((ExpressionVisitor)this, extraData);
                this.out.write(", ");
                e2.accept((ExpressionVisitor)this, extraData);
                this.out.write(")");
                if (filter instanceof DWithin) {
                    this.out.write("<");
                } else if (filter instanceof Beyond) {
                    this.out.write(">");
                } else {
                    throw new RuntimeException("Unknown distance operator");
                }
                this.out.write(Double.toString(((DistanceBufferOperator)filter).getDistance()));
            } else if (!(filter instanceof BBOX)) {
                if (filter instanceof Contains) {
                    this.out.write("Contains(");
                } else if (filter instanceof Crosses) {
                    this.out.write("Crosses(");
                } else if (filter instanceof Disjoint) {
                    this.out.write("Disjoint(");
                } else if (filter instanceof Equals) {
                    this.out.write("Equals(");
                } else if (filter instanceof Intersects) {
                    this.out.write("Intersects(");
                } else if (filter instanceof Overlaps) {
                    this.out.write("Overlaps(");
                } else if (filter instanceof Touches) {
                    this.out.write("Touches(");
                } else if (filter instanceof Within) {
                    this.out.write("Within(");
                } else {
                    throw new RuntimeException("Unknown operator: " + filter);
                }
                if (swapped) {
                    e2.accept((ExpressionVisitor)this, extraData);
                    this.out.write(", ");
                    e1.accept((ExpressionVisitor)this, extraData);
                } else {
                    e1.accept((ExpressionVisitor)this, extraData);
                    this.out.write(", ");
                    e2.accept((ExpressionVisitor)this, extraData);
                }
                this.out.write(")");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return extraData;
    }

    @Override
    protected void writeLiteral(Object literal) throws IOException {
        if (literal instanceof Date) {
            Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            c.setTime((Date)literal);
            this.out.write(String.format("STR_TO_DATE('%d,%d,%d,%d,%d,%d,%d'", c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13), c.get(14) * 1000) + ",'%Y,%m,%d,%H,%i,%s,%f')");
        } else {
            super.writeLiteral(literal);
        }
    }
}

