/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mysql;

import java.io.IOException;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.mysql.MySQLDialectBasic;
import org.geotools.data.mysql.MySQLDialectPrepared;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;

public class MySQLDataStoreFactory
extends JDBCDataStoreFactory {
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"mysql");
    public static final DataAccessFactory.Param PORT = new DataAccessFactory.Param("port", Integer.class, "Port", true, (Object)3306);
    public static final DataAccessFactory.Param STORAGE_ENGINE = new DataAccessFactory.Param("storage engine", String.class, "Storage Engine", false, (Object)"MyISAM");

    @Override
    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new MySQLDialectBasic(dataStore);
    }

    @Override
    public String getDisplayName() {
        return "MySQL";
    }

    @Override
    protected String getDriverClassName() {
        return "com.mysql.jdbc.Driver";
    }

    @Override
    protected String getDatabaseID() {
        return (String)MySQLDataStoreFactory.DBTYPE.sample;
    }

    public String getDescription() {
        return "MySQL Database";
    }

    @Override
    protected String getValidationQuery() {
        return "select version()";
    }

    @Override
    protected void setupParameters(Map parameters) {
        super.setupParameters(parameters);
        parameters.put(MySQLDataStoreFactory.DBTYPE.key, DBTYPE);
        parameters.put(MySQLDataStoreFactory.PORT.key, PORT);
        parameters.put(MySQLDataStoreFactory.STORAGE_ENGINE.key, STORAGE_ENGINE);
        parameters.remove(MySQLDataStoreFactory.SCHEMA.key);
    }

    @Override
    protected JDBCDataStore createDataStoreInternal(JDBCDataStore dataStore, Map params) throws IOException {
        SQLDialect dialect;
        String storageEngine = (String)STORAGE_ENGINE.lookUp(params);
        if (storageEngine == null) {
            storageEngine = (String)MySQLDataStoreFactory.STORAGE_ENGINE.sample;
        }
        if ((dialect = dataStore.getSQLDialect()) instanceof MySQLDialectBasic) {
            ((MySQLDialectBasic)dialect).setStorageEngine(storageEngine);
        } else {
            ((MySQLDialectPrepared)dialect).setStorageEngine(storageEngine);
        }
        return dataStore;
    }
}

