/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPoint;
import java.util.ArrayList;
import java.util.List;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.opengis.filter.capability.FunctionName;

public class FilterFunction_vertices
extends FunctionExpressionImpl {
    public static FunctionName NAME = new FunctionNameImpl("vertices", FunctionNameImpl.parameter("vertices", MultiPoint.class), FunctionNameImpl.parameter("geometry", Geometry.class));

    public FilterFunction_vertices() {
        super(NAME);
    }

    @Override
    public Object evaluate(Object feature, Class context) {
        Geometry g = (Geometry)this.getExpression(0).evaluate(feature, Geometry.class);
        if (g == null) {
            return null;
        }
        MultiPointExtractor filter = new MultiPointExtractor();
        g.apply(filter);
        return filter.getMultiPoint();
    }

    static class MultiPointExtractor
    implements CoordinateFilter {
        List<Coordinate> coordinates = new ArrayList<Coordinate>();

        MultiPointExtractor() {
        }

        @Override
        public void filter(Coordinate c) {
            this.coordinates.add(c);
        }

        MultiPoint getMultiPoint() {
            Coordinate[] coorArray = this.coordinates.toArray(new Coordinate[this.coordinates.size()]);
            return new GeometryFactory().createMultiPoint(coorArray);
        }
    }
}

