/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.SumVisitor;
import org.geotools.filter.Expression;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.function.CollectionFeatureMemberFilterVisitor;
import org.geotools.util.logging.Logging;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.ExpressionVisitor;

public class Collection_SumFunction
extends FunctionExpressionImpl {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.filter.function");
    SimpleFeatureCollection previousFeatureCollection = null;
    Object sum = null;
    public static FunctionName NAME = new FunctionNameImpl("Collection_Sum", FunctionNameImpl.parameter("sum", Number.class), FunctionNameImpl.parameter("expression", Number.class));

    public Collection_SumFunction() {
        super(NAME);
    }

    static CalcResult calculateSum(SimpleFeatureCollection collection, Expression expression) throws IllegalFilterException, IOException {
        SumVisitor sumVisitor = new SumVisitor(expression);
        collection.accepts(sumVisitor, null);
        return sumVisitor.getResult();
    }

    @Override
    public void setParameters(List args) {
        org.opengis.filter.expression.Expression expr = (org.opengis.filter.expression.Expression)args.get(0);
        expr = (org.opengis.filter.expression.Expression)expr.accept((ExpressionVisitor)new CollectionFeatureMemberFilterVisitor(), null);
        args.set(0, expr);
        super.setParameters(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(Object feature) {
        if (feature == null) {
            return new Integer(0);
        }
        SimpleFeatureCollection featureCollection = (SimpleFeatureCollection)feature;
        Expression expr = (Expression)this.getExpression(0);
        SimpleFeatureCollection simpleFeatureCollection = featureCollection;
        synchronized (simpleFeatureCollection) {
            if (featureCollection != this.previousFeatureCollection) {
                this.previousFeatureCollection = featureCollection;
                this.sum = null;
                try {
                    CalcResult result = Collection_SumFunction.calculateSum(featureCollection, expr);
                    if (result != null) {
                        this.sum = result.getValue();
                    }
                }
                catch (IllegalFilterException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
            }
        }
        return this.sum;
    }

    public void setExpression(Expression e) {
        this.setParameters(Collections.singletonList(e));
    }
}

