/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.geotools.Builder;
import org.geotools.styling.Font;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.styling.builder.AbstractStyleBuilder;
import org.geotools.styling.builder.FillBuilder;
import org.geotools.styling.builder.FontBuilder;
import org.geotools.styling.builder.HaloBuilder;
import org.geotools.styling.builder.LinePlacementBuilder;
import org.geotools.styling.builder.PointPlacementBuilder;
import org.geotools.styling.builder.RuleBuilder;
import org.geotools.styling.builder.StyleBuilder;
import org.opengis.filter.expression.Expression;

public class TextSymbolizerBuilder
extends AbstractStyleBuilder<TextSymbolizer> {
    FillBuilder fill = new FillBuilder(this).unset();
    List<FontBuilder> fonts = new ArrayList<FontBuilder>();
    FontBuilder font;
    HaloBuilder halo = new HaloBuilder(this).unset();
    Expression label;
    String geometry;
    Unit<Length> uom;
    Builder<? extends LabelPlacement> placement = new PointPlacementBuilder(this).unset();
    private Map<String, String> options = new HashMap<String, String>();

    public TextSymbolizerBuilder() {
        this((RuleBuilder)null);
    }

    public TextSymbolizerBuilder(RuleBuilder parent) {
        super(parent);
        this.reset();
    }

    public TextSymbolizerBuilder geometry(String geometry) {
        this.geometry = geometry;
        return this;
    }

    public HaloBuilder halo() {
        this.unset = false;
        return this.halo;
    }

    public FillBuilder fill() {
        this.unset = false;
        return this.fill;
    }

    public FontBuilder newFont() {
        this.unset = false;
        FontBuilder font = new FontBuilder(this);
        this.fonts.add(font);
        return font;
    }

    public LinePlacementBuilder linePlacement() {
        if (!(this.placement instanceof LinePlacementBuilder)) {
            this.placement = new LinePlacementBuilder(this);
        }
        this.unset = false;
        return (LinePlacementBuilder)this.placement;
    }

    public PointPlacementBuilder pointPlacement() {
        if (!(this.placement instanceof PointPlacementBuilder)) {
            this.placement = new PointPlacementBuilder(this);
        }
        this.unset = false;
        return (PointPlacementBuilder)this.placement;
    }

    public TextSymbolizerBuilder uom(Unit<Length> uom) {
        this.unset = false;
        this.uom = uom;
        return this;
    }

    @Override
    public TextSymbolizer build() {
        if (this.unset) {
            return null;
        }
        Font[] array = new Font[this.fonts.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.fonts.get(i).build();
        }
        TextSymbolizer ts = this.sf.createTextSymbolizer(this.fill.build(), array, this.halo.build(), this.label, this.placement.build(), this.geometry);
        if (this.uom != null) {
            ts.setUnitOfMeasure(this.uom);
        }
        if (ts instanceof TextSymbolizer2 && this.options != null) {
            TextSymbolizer2 ts2 = (TextSymbolizer2)ts;
            ts2.getOptions().putAll(this.options);
        }
        this.reset();
        return ts;
    }

    @Override
    public TextSymbolizerBuilder unset() {
        return (TextSymbolizerBuilder)super.unset();
    }

    public TextSymbolizerBuilder reset() {
        this.fill.reset();
        this.halo.unset();
        this.label = null;
        this.geometry = null;
        this.placement.reset();
        this.options.clear();
        this.uom = null;
        this.unset = false;
        return this;
    }

    public TextSymbolizerBuilder reset(TextSymbolizer symbolizer) {
        this.fill.reset(symbolizer.getFill());
        this.halo.reset(symbolizer.getHalo());
        this.label = symbolizer.getLabel();
        this.geometry = symbolizer.getGeometryPropertyName();
        LabelPlacement otherPlacement = symbolizer.getLabelPlacement();
        if (symbolizer.getLabelPlacement() instanceof PointPlacement) {
            PointPlacementBuilder builder = new PointPlacementBuilder(this);
            builder.reset((PointPlacement)otherPlacement);
            this.placement = builder;
        } else if (symbolizer.getLabelPlacement() instanceof LabelPlacement) {
            LinePlacementBuilder builder = new LinePlacementBuilder(this);
            builder.reset((LinePlacement)otherPlacement);
            this.placement = builder;
        } else {
            throw new IllegalArgumentException("Unrecognized label placement: " + otherPlacement);
        }
        this.unset = false;
        return this;
    }

    public TextSymbolizerBuilder option(String name, Object value) {
        this.options.put(name, value.toString());
        this.unset = false;
        return this;
    }

    public TextSymbolizerBuilder label(Expression label) {
        this.unset = false;
        this.label = label;
        return this;
    }

    public TextSymbolizerBuilder label(String cqlExpression) {
        return this.label(this.cqlExpression(cqlExpression));
    }

    public TextSymbolizerBuilder labelText(String text) {
        return this.label(this.literal(text));
    }

    @Override
    protected void buildStyleInternal(StyleBuilder sb) {
        sb.featureTypeStyle().rule().text().init(this);
    }
}

