/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.builder.AbstractStyleBuilder;
import org.geotools.styling.builder.FillBuilder;
import org.geotools.styling.builder.StrokeBuilder;
import org.geotools.styling.builder.StyleBuilder;
import org.opengis.filter.expression.Expression;

public class PolygonSymbolizerBuilder
extends AbstractStyleBuilder<PolygonSymbolizer> {
    StrokeBuilder stroke = new StrokeBuilder(this).unset();
    FillBuilder fill = new FillBuilder(this).unset();
    Expression geometry = null;
    Unit<Length> uom;

    public PolygonSymbolizerBuilder() {
        this((AbstractStyleBuilder<?>)null);
    }

    PolygonSymbolizerBuilder(AbstractStyleBuilder<?> parent) {
        super(parent);
        this.reset();
    }

    public PolygonSymbolizerBuilder geometry(Expression geometry) {
        this.geometry = geometry;
        return this;
    }

    public PolygonSymbolizerBuilder geometry(String cqlExpression) {
        return this.geometry(this.cqlExpression(cqlExpression));
    }

    public StrokeBuilder stroke() {
        this.unset = false;
        this.stroke.reset();
        return this.stroke;
    }

    public FillBuilder fill() {
        this.unset = false;
        this.fill.reset();
        return this.fill;
    }

    public PolygonSymbolizerBuilder uom(Unit<Length> uom) {
        this.unset = false;
        this.uom = uom;
        return this;
    }

    @Override
    public PolygonSymbolizer build() {
        if (this.unset) {
            return null;
        }
        PolygonSymbolizer ps = this.sf.createPolygonSymbolizer(this.stroke.build(), this.fill.build(), null);
        if (this.geometry != null) {
            ps.setGeometry(this.geometry);
        }
        if (this.uom != null) {
            ps.setUnitOfMeasure(this.uom);
        }
        if (this.parent == null) {
            this.reset();
        }
        return ps;
    }

    public PolygonSymbolizerBuilder reset() {
        this.stroke.unset();
        this.fill.unset();
        this.unset = false;
        return this;
    }

    public PolygonSymbolizerBuilder reset(org.opengis.style.PolygonSymbolizer symbolizer) {
        if (symbolizer == null) {
            return this.unset();
        }
        if (symbolizer instanceof PolygonSymbolizer) {
            return this.reset((PolygonSymbolizer)symbolizer);
        }
        this.stroke.reset(symbolizer.getStroke());
        this.fill.reset(symbolizer.getFill());
        this.uom = symbolizer.getUnitOfMeasure();
        this.geometry = this.property(symbolizer.getGeometryPropertyName());
        this.unset = false;
        return this;
    }

    public PolygonSymbolizerBuilder reset(PolygonSymbolizer symbolizer) {
        if (symbolizer == null) {
            return this.unset();
        }
        this.stroke.reset(symbolizer.getStroke());
        this.fill.reset(symbolizer.getFill());
        this.uom = symbolizer.getUnitOfMeasure();
        this.geometry = symbolizer.getGeometry();
        this.unset = false;
        return this;
    }

    @Override
    public PolygonSymbolizerBuilder unset() {
        return (PolygonSymbolizerBuilder)super.unset();
    }

    @Override
    protected void buildStyleInternal(StyleBuilder sb) {
        sb.featureTypeStyle().rule().polygon().init(this);
    }
}

