/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.builder.AbstractStyleBuilder;
import org.geotools.styling.builder.ColorReplacementBuilder;
import org.geotools.styling.builder.StyleBuilder;
import org.opengis.metadata.citation.OnLineResource;
import org.opengis.style.ColorReplacement;

public class ExternalGraphicBuilder
extends AbstractStyleBuilder<ExternalGraphic> {
    private Icon inline;
    private String format;
    private OnLineResource resource;
    private Set<ColorReplacementBuilder> replacements = new HashSet<ColorReplacementBuilder>();

    public ExternalGraphicBuilder() {
        this((AbstractStyleBuilder<?>)null);
    }

    public ExternalGraphicBuilder(AbstractStyleBuilder<?> parent) {
        super(parent);
        this.reset();
    }

    public String format() {
        return this.format;
    }

    public ExternalGraphicBuilder format(String format) {
        this.format = format;
        return this;
    }

    public Icon inline() {
        return this.inline;
    }

    public ExternalGraphicBuilder inline(Icon icon) {
        this.inline = icon;
        return this;
    }

    public Set<ColorReplacementBuilder> replacements() {
        return this.replacements;
    }

    public ColorReplacementBuilder replacement() {
        ColorReplacementBuilder replacement = new ColorReplacementBuilder(this);
        this.replacements.add(replacement);
        return replacement;
    }

    public ExternalGraphicBuilder resource(OnLineResource resource) {
        this.resource = resource;
        return this;
    }

    @Override
    public ExternalGraphic build() {
        if (this.unset) {
            return null;
        }
        HashSet<ColorReplacement> set = new HashSet<ColorReplacement>();
        for (ColorReplacementBuilder replacement : this.replacements) {
            set.add(replacement.build());
        }
        ExternalGraphic externalGraphic = this.inline != null ? this.sf.externalGraphic(this.inline, set) : this.sf.externalGraphic(this.resource, this.format, set);
        if (this.parent == null) {
            this.reset();
        }
        return externalGraphic;
    }

    public ExternalGraphicBuilder reset() {
        this.unset = false;
        return this;
    }

    @Override
    public ExternalGraphicBuilder unset() {
        return (ExternalGraphicBuilder)super.unset();
    }

    public ExternalGraphicBuilder reset(ExternalGraphic original) {
        this.unset = false;
        this.format = original.getFormat();
        this.inline = original.getInlineContent();
        this.replacements.clear();
        this.resource = original.getOnlineResource();
        if (original.getColorReplacements() != null) {
            for (ColorReplacement cr : original.getColorReplacements()) {
                this.replacements.add(new ColorReplacementBuilder().reset(cr));
            }
        }
        return this;
    }

    @Override
    protected void buildStyleInternal(StyleBuilder sb) {
        sb.featureTypeStyle().rule().point().graphic().externalGraphic().init(this);
    }
}

