/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.builder.AbstractStyleBuilder;
import org.geotools.styling.builder.StyleBuilder;
import org.opengis.filter.expression.Expression;
import org.opengis.style.ContrastMethod;

public class ContrastEnhancementBuilder
extends AbstractStyleBuilder<ContrastEnhancement> {
    private Expression gamma = null;
    private ContrastMethod method;

    public ContrastEnhancementBuilder() {
        this((AbstractStyleBuilder<?>)null);
    }

    public ContrastEnhancementBuilder(AbstractStyleBuilder<?> parent) {
        super(parent);
        this.reset();
    }

    public ContrastEnhancementBuilder gamma(Expression gamma) {
        this.gamma = gamma;
        this.unset = false;
        return this;
    }

    public ContrastEnhancementBuilder gamma(double gamma) {
        return this.gamma(this.literal(gamma));
    }

    public ContrastEnhancementBuilder normalize() {
        this.method = ContrastMethod.NORMALIZE;
        this.unset = false;
        return this;
    }

    public ContrastEnhancementBuilder histogram() {
        this.method = ContrastMethod.HISTOGRAM;
        this.unset = false;
        return this;
    }

    public ContrastEnhancementBuilder gamma(String cqlExpression) {
        return this.gamma(this.cqlExpression(cqlExpression));
    }

    @Override
    public ContrastEnhancement build() {
        if (this.unset) {
            return null;
        }
        ContrastEnhancement contrastEnhancement = this.sf.contrastEnhancement(this.gamma, this.method);
        return contrastEnhancement;
    }

    public ContrastEnhancementBuilder reset() {
        this.gamma = null;
        this.method = ContrastMethod.NONE;
        this.unset = false;
        return this;
    }

    public ContrastEnhancementBuilder reset(ContrastEnhancement contrastEnhancement) {
        if (contrastEnhancement == null) {
            return this.reset();
        }
        this.gamma = contrastEnhancement.getGammaValue();
        this.method = contrastEnhancement.getMethod();
        this.unset = false;
        return this;
    }

    @Override
    public ContrastEnhancementBuilder unset() {
        return (ContrastEnhancementBuilder)super.unset();
    }

    @Override
    protected void buildStyleInternal(StyleBuilder sb) {
        throw new UnsupportedOperationException("Cannot build a meaningful style out of a contrast enhancement alone");
    }
}

