/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.shp;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.shp.ShpServiceExtension;
import net.refractions.udig.ui.CharsetSelectionDialog;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.operations.IOp;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;

public class CharsetChange
implements IOp {
    private final ShpServiceExtension extension = new ShpServiceExtension();

    public void op(final Display display, Object target, IProgressMonitor monitor) throws Exception {
        final IService[] services = this.toService((Object[])target);
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    CharsetSelectionDialog dialog = new CharsetSelectionDialog(display.getActiveShell(), false, this.getCharset(services[0]).name());
                    dialog.open();
                    Charset newCharset = (Charset)dialog.getFirstResult();
                    if (newCharset != null) {
                        this.setNewCharset(services, newCharset);
                    }
                }
                catch (IOException e) {
                    throw (RuntimeException)new RuntimeException().initCause(e);
                }
            }

            private void setNewCharset(final IService[] services2, final Charset newCharset) {
                PlatformGIS.run((IRunnableWithProgress)new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        IService[] iServiceArray = services2;
                        int n = services2.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IService service = iServiceArray[n2];
                            HashMap<String, Serializable> params = new HashMap<String, Serializable>(service.getConnectionParams());
                            params.put(ShapefileDataStoreFactory.DBFCHARSET.key, (Serializable)((Object)newCharset.name()));
                            IService newService = CharsetChange.this.extension.createService(service.getIdentifier(), params);
                            CatalogPlugin.getDefault().getLocalCatalog().replace(service.getID(), newService);
                            ++n2;
                        }
                    }
                });
            }

            private Charset getCharset(IService serviceImpl) throws IOException {
                Object lookUp = ShapefileDataStoreFactory.DBFCHARSET.lookUp(serviceImpl.getConnectionParams());
                String name = null;
                if (lookUp instanceof String) {
                    name = (String)lookUp;
                }
                if (name == null) {
                    return Charset.defaultCharset();
                }
                return Charset.forName(name);
            }
        });
    }

    private IService[] toService(Object[] target) throws IOException {
        HashSet<IService> result = new HashSet<IService>(target.length);
        Object[] objectArray = target;
        int n = target.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IService) {
                result.add((IService)object);
            } else {
                result.add(((IGeoResource)object).service((IProgressMonitor)new NullProgressMonitor()));
            }
            ++n2;
        }
        return result.toArray(new IService[result.size()]);
    }
}

