/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.shp;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveChangeEvent;
import net.refractions.udig.catalog.IResolveDelta;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceInfo;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.internal.CatalogImpl;
import net.refractions.udig.catalog.internal.ResolveChangeEvent;
import net.refractions.udig.catalog.internal.ResolveDelta;
import net.refractions.udig.catalog.internal.shp.ShpGeoResourceImpl;
import net.refractions.udig.catalog.internal.shp.ShpPlugin;
import net.refractions.udig.catalog.internal.shp.ShpServiceInfo;
import net.refractions.udig.catalog.shp.internal.Messages;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.UDIGDisplaySafeLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.shapefile.indexed.IndexedShapefileDataStore;
import org.opengis.filter.Filter;

public class ShpServiceImpl
extends IService {
    private ID id;
    private Map<String, Serializable> params = null;
    private Throwable msg = null;
    volatile ShapefileDataStore ds = null;
    protected final Lock rLock = new UDIGDisplaySafeLock();
    private static final Lock dsInstantiationLock = new UDIGDisplaySafeLock();
    private volatile List<ShpGeoResourceImpl> members = null;

    public ShpServiceImpl(URL url, Map<String, Serializable> params) {
        if (url == null) {
            throw new NullPointerException("ShpService requres a URL");
        }
        try {
            this.id = new ID(url);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Unable to create ID from:" + url, t);
        }
        this.params = params;
        Serializable memorymapped = params.get("memory mapped buffer");
        if (memorymapped == null) {
            memorymapped = Boolean.valueOf(false);
            try {
                File file = URLUtils.urlToFile((URL)url);
                if (file.length() > 0x200000L) {
                    memorymapped = Boolean.valueOf(false);
                }
            }
            catch (Exception exception) {
                memorymapped = Boolean.valueOf(false);
            }
        }
        if (!params.containsKey(ShapefileDataStoreFactory.CREATE_SPATIAL_INDEX.key)) {
            params.put(ShapefileDataStoreFactory.CREATE_SPATIAL_INDEX.key, Boolean.valueOf(ShpPlugin.getDefault().isUseSpatialIndex()));
        }
        if (!params.containsKey(ShapefileDataStoreFactory.DBFCHARSET.key)) {
            params.put(ShapefileDataStoreFactory.DBFCHARSET.key, (Serializable)((Object)ShpPlugin.getDefault().defaultCharset()));
        }
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (adaptee == null) {
            throw new NullPointerException("No adaptor specified");
        }
        if (adaptee.isAssignableFrom(ShapefileDataStore.class)) {
            return adaptee.cast(this.getDS(monitor));
        }
        if (adaptee.isAssignableFrom(File.class)) {
            return adaptee.cast(this.toFile());
        }
        return (T)super.resolve(adaptee, monitor);
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(ShapefileDataStore.class) || adaptee.isAssignableFrom(File.class) || super.canResolve(adaptee);
    }

    public void dispose(IProgressMonitor monitor) {
        super.dispose(monitor);
        if (this.members != null) {
            this.members = null;
        }
        if (this.ds != null) {
            this.ds.dispose();
            this.ds = null;
        }
    }

    public List<ShpGeoResourceImpl> resources(IProgressMonitor monitor) throws IOException {
        if (this.members == null) {
            this.getDS(monitor);
            this.rLock.lock();
            try {
                if (this.members == null) {
                    this.members = new LinkedList<ShpGeoResourceImpl>();
                    String[] typenames = this.ds.getTypeNames();
                    if (typenames != null) {
                        int i = 0;
                        while (i < typenames.length) {
                            ShpGeoResourceImpl shpGeoResource = new ShpGeoResourceImpl(this, typenames[i]);
                            this.members.add(shpGeoResource);
                            ++i;
                        }
                    }
                }
            }
            finally {
                this.rLock.unlock();
            }
        }
        return this.members;
    }

    public ShpServiceInfo getInfo(IProgressMonitor monitor) throws IOException {
        return (ShpServiceInfo)super.getInfo(monitor);
    }

    protected IServiceInfo createInfo(IProgressMonitor monitor) throws IOException {
        ShapefileDataStore dataStore = this.getDS(monitor);
        if (dataStore == null) {
            return null;
        }
        this.rLock.lock();
        try {
            ShpServiceInfo shpServiceInfo = new ShpServiceInfo(this);
            return shpServiceInfo;
        }
        finally {
            this.rLock.unlock();
        }
    }

    public Map<String, Serializable> getConnectionParams() {
        return this.params;
    }

    ShapefileDataStore getDS(IProgressMonitor monitor) throws IOException {
        if (this.ds == null) {
            block8: {
                dsInstantiationLock.lock();
                try {
                    ShapefileDataStoreFactory dsf;
                    if (this.ds != null || !(dsf = new ShapefileDataStoreFactory()).canProcess(this.params)) break block8;
                    try {
                        this.ds = (ShapefileDataStore)dsf.createDataStore(this.params);
                        this.openIndexGenerationDialog(this.ds);
                        this.ds.getFeatureSource();
                    }
                    catch (IOException e) {
                        this.msg = e;
                        try {
                            this.params.remove(ShapefileDataStoreFactory.CREATE_SPATIAL_INDEX.key);
                            this.ds = (ShapefileDataStore)dsf.createDataStore(this.params);
                            this.ds.getFeatureSource();
                        }
                        catch (Exception e2) {
                            this.msg = e2;
                            throw (IOException)new IOException().initCause(e2);
                        }
                    }
                }
                finally {
                    dsInstantiationLock.unlock();
                }
            }
            ResolveDelta delta = new ResolveDelta((IResolve)this, IResolveDelta.Kind.CHANGED);
            ResolveChangeEvent event = new ResolveChangeEvent((Object)this, IResolveChangeEvent.Type.POST_CHANGE, (IResolveDelta)delta);
            this.fire(event);
        }
        return this.ds;
    }

    private void fire(ResolveChangeEvent event) {
        ICatalog catalog = this.parent((IProgressMonitor)new NullProgressMonitor());
        if (catalog instanceof CatalogImpl) {
            ((CatalogImpl)catalog).fire((IResolveChangeEvent)event);
        }
    }

    private void openIndexGenerationDialog(final ShapefileDataStore ds) {
        this.rLock.lock();
        try {
            if (ds instanceof IndexedShapefileDataStore) {
                IndexedShapefileDataStore ids = (IndexedShapefileDataStore)ds;
                if (ids.isIndexed()) {
                    return;
                }
                String name = this.getIdentifier().getFile();
                int lastIndexOf = name.lastIndexOf(File.separator);
                if (lastIndexOf > 0) {
                    name = name.substring(lastIndexOf + 1);
                }
                final String finalName = name;
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(String.valueOf(Messages.ShpPreferencePage_createindex) + " " + finalName, -1);
                        ShpServiceImpl.this.index(ds, ds.getTypeNames()[0]);
                        monitor.done();
                    }
                };
                PlatformUI.getWorkbench().isClosing();
                PlatformGIS.runInProgressDialog((String)(String.valueOf(Messages.ShpServiceImpl_indexing) + " " + finalName), (boolean)true, (IRunnableWithProgress)runnable, (boolean)false);
            }
        }
        finally {
            this.rLock.unlock();
        }
    }

    private void index(ShapefileDataStore ds, String typename) {
        block12: {
            FeatureReader reader = null;
            try {
                try {
                    reader = ds.getFeatureReader((Query)new DefaultQuery(typename, (Filter)Filter.INCLUDE, new String[0]), Transaction.AUTO_COMMIT);
                }
                catch (Exception e) {
                    ShpPlugin.log("", e);
                    if (reader == null) break block12;
                    try {
                        reader.close();
                    }
                    catch (IOException e2) {
                        ShpPlugin.log("", e2);
                    }
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        ShpPlugin.log("", e);
                    }
                }
            }
        }
    }

    public IResolve.Status getStatus() {
        if (this.ds == null) {
            return super.getStatus();
        }
        return IResolve.Status.CONNECTED;
    }

    public Throwable getMessage() {
        return this.msg;
    }

    public URL getIdentifier() {
        return this.id.toURL();
    }

    public ID getID() {
        return this.id;
    }

    public File toFile() {
        Map<String, Serializable> parametersMap = this.getConnectionParams();
        URL url = (URL)parametersMap.get(ShapefileDataStoreFactory.URLP.key);
        return URLUtils.urlToFile((URL)url);
    }
}

