/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.shp;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.refractions.udig.catalog.AbstractDataStoreServiceExtension;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ServiceExtension;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.internal.shp.ShpServiceImpl;
import net.refractions.udig.catalog.shp.internal.Messages;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;

public class ShpServiceExtension
extends AbstractDataStoreServiceExtension
implements ServiceExtension {
    private static final String OLD_URLP_KEY = "shapefile url";
    private static ShapefileDataStoreFactory shpDSFactory;

    public static ShapefileDataStoreFactory getSHPDSFactory() {
        if (shpDSFactory == null) {
            shpDSFactory = new ShapefileDataStoreFactory();
        }
        return shpDSFactory;
    }

    public IService createService(URL id, Map<String, Serializable> params) {
        if (params.containsKey(OLD_URLP_KEY)) {
            params.put(ShapefileDataStoreFactory.URLP.key, params.get(OLD_URLP_KEY));
            params.remove(OLD_URLP_KEY);
        }
        if (params.containsKey(ShapefileDataStoreFactory.URLP.key)) {
            URL url = null;
            if (params.get(ShapefileDataStoreFactory.URLP.key) == null) {
                return null;
            }
            if (params.get(ShapefileDataStoreFactory.URLP.key) instanceof URL) {
                url = (URL)params.get(ShapefileDataStoreFactory.URLP.key);
            } else {
                try {
                    url = (URL)ShapefileDataStoreFactory.URLP.parse(params.get(ShapefileDataStoreFactory.URLP.key).toString());
                    params.put(ShapefileDataStoreFactory.URLP.key, url);
                }
                catch (Throwable e1) {
                    e1.printStackTrace();
                    return null;
                }
            }
            String file = url.getFile();
            file = file.toLowerCase();
            if (!(file.endsWith(".shp") || file.endsWith(".shx") || file.endsWith(".qix") || file.endsWith(".dbf"))) {
                return null;
            }
            if (ShpServiceExtension.getSHPDSFactory().canProcess(params)) {
                if (id == null) {
                    return new ShpServiceImpl(url, params);
                }
                return new ShpServiceImpl(id, params);
            }
        }
        return null;
    }

    public Map<String, Serializable> createParams(URL url) {
        if (!this.isSupportedExtension(url)) {
            return null;
        }
        URL cleanedShapeURL = this.toShpURL(url);
        if (cleanedShapeURL == null) {
            return null;
        }
        if (ShpServiceExtension.getSHPDSFactory().canProcess(cleanedShapeURL)) {
            File file = URLUtils.urlToFile((URL)cleanedShapeURL);
            if (!file.exists()) {
                return null;
            }
            HashMap<String, Serializable> params = new HashMap<String, Serializable>();
            params.put(ShapefileDataStoreFactory.URLP.key, cleanedShapeURL);
            return params;
        }
        return null;
    }

    private boolean isSupportedExtension(URL url) {
        String file = url.getFile();
        return (file = file.toLowerCase()).endsWith(".shp") || file.endsWith(".shx") || file.endsWith(".qix") || file.endsWith(".dbf");
    }

    private URL toShpURL(URL url) {
        File file = URLUtils.urlToFile((URL)url);
        URL shpURL = URLUtils.fileToURL((File)file);
        if (shpURL != null) {
            return shpURL;
        }
        String authority = url.getAuthority();
        String path = url.getPath();
        if (authority != null && authority.length() != 0) {
            path = "//" + authority + path;
        }
        if (!path.toLowerCase().endsWith(".shp")) {
            path = String.valueOf(path.substring(0, path.lastIndexOf(46))) + ".shp";
        }
        file = new File(path);
        shpURL = URLUtils.fileToURL((File)file);
        return shpURL;
    }

    protected String doOtherChecks(Map<String, Serializable> params) {
        ShapefileDataStoreFactory factory = ShpServiceExtension.getSHPDSFactory();
        if (!factory.canProcess(params)) {
            DataStore datastore = null;
            try {
                try {
                    datastore = factory.createDataStore(params);
                }
                catch (Throwable t) {
                    String string = t.getLocalizedMessage();
                    if (datastore != null) {
                        datastore.dispose();
                    }
                    return string;
                }
            }
            finally {
                if (datastore != null) {
                    datastore.dispose();
                }
            }
        }
        return null;
    }

    protected DataStoreFactorySpi getDataStoreFactory() {
        return ShpServiceExtension.getSHPDSFactory();
    }

    public String reasonForFailure(URL url) {
        if (!this.isSupportedExtension(url)) {
            return Messages.ShpServiceExtension_badExtension;
        }
        if (this.toShpURL(url) == null) {
            return Messages.ShpServiceExtension_cantCreateURL;
        }
        return this.reasonForFailure(this.createParams(url));
    }
}

