/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.shp;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.refractions.udig.internal.ui.UiPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.osgi.framework.BundleContext;

public class ShpPlugin
extends AbstractUIPlugin {
    private static ShpPlugin plugin;
    private ResourceBundle resourceBundle;
    public static final String SHP_TRACE_FINEST = "net.refractions.udig.catalog.shp/debug/finest";
    public static final String SHP_TRACE_FINE = "net.refractions.udig.catalog.shp/debug/fine";
    public static final String ID = "net.refractions.udig.catalog.shp";

    public ShpPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Logger logger = ShapefileDataStoreFactory.LOGGER;
        if (ShpPlugin.isDebugging(SHP_TRACE_FINEST) || ShpPlugin.isDebugging(SHP_TRACE_FINE)) {
            if (ShpPlugin.isDebugging(SHP_TRACE_FINE)) {
                logger.setLevel(Level.FINE);
            } else {
                logger.setLevel(Level.FINEST);
            }
        } else {
            logger.setLevel(Level.SEVERE);
        }
        logger.addHandler(new ConsoleHandler());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.resourceBundle = null;
        super.stop(context);
    }

    public static ShpPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = ShpPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("net.refractions.udig.catalog.internal.shp.ShpPluginResources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public static void log(String message, Throwable t) {
        int status = t instanceof Exception || message != null ? 4 : 2;
        ShpPlugin.getDefault().getLog().log((IStatus)new Status(status, ID, 0, message, t));
    }

    public static void trace(String message, Throwable e) {
        if (ShpPlugin.getDefault().isDebugging()) {
            if (message != null) {
                System.out.println(message);
            }
            if (e != null) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isDebugging(String trace) {
        return ShpPlugin.getDefault().isDebugging() && "true".equalsIgnoreCase(Platform.getDebugOption((String)trace));
    }

    public boolean isUseSpatialIndex() {
        return this.getPreferenceStore().getBoolean("booleanPreference");
    }

    public void setUseSpatialIndex(boolean useSpatialIndex) {
        this.getPreferenceStore().setValue("booleanPreference", useSpatialIndex);
    }

    public String defaultCharset() {
        return UiPlugin.getDefault().getPreferenceStore().getString("P_DEFAULT_CHARSET");
    }
}

