/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.shp;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.internal.shp.ShpGeoResourceImpl;
import net.refractions.udig.catalog.shp.internal.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.geotools.data.ResourceInfo;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class ShpGeoResourceInfo
extends IGeoResourceInfo {
    private final ShpGeoResourceImpl shpResource;
    private SimpleFeatureType featureType;
    private ResourceInfo header;

    ShpGeoResourceInfo(ShpGeoResourceImpl shpGeoResourceImpl) throws IOException {
        block9: {
            this.featureType = null;
            this.shpResource = shpGeoResourceImpl;
            this.featureType = this.shpResource.parent.getDS(null).getSchema();
            try {
                SimpleFeatureSource source = this.shpResource.parent.getDS(null).getFeatureSource();
                this.header = source.getInfo();
                this.bounds = this.header.getBounds();
                ReferencedEnvelope tmpBounds = source.getBounds();
                if (tmpBounds instanceof ReferencedEnvelope) {
                    this.bounds = tmpBounds;
                }
                if (tmpBounds != null) {
                    this.bounds = new ReferencedEnvelope((Envelope)tmpBounds, this.getCRS());
                }
                if (this.bounds != null) break block9;
                this.bounds = new ReferencedEnvelope(new Envelope(), this.getCRS());
                FeatureIterator iter = source.getFeatures().features();
                try {
                    while (iter.hasNext()) {
                        SimpleFeature element = (SimpleFeature)iter.next();
                        if (this.bounds.isNull()) {
                            this.bounds.init(element.getBounds());
                            continue;
                        }
                        this.bounds.include(element.getBounds());
                    }
                }
                finally {
                    iter.close();
                }
            }
            catch (Exception e) {
                CatalogPlugin.getDefault().getLog().log((IStatus)new Status(2, "net.refractions.udig.catalog", 0, Messages.ShpGeoResourceImpl_error_layer_bounds, (Throwable)e));
                this.bounds = new ReferencedEnvelope(new Envelope(), this.getCRS());
            }
        }
        this.keywords = new String[]{".shp", "Shapefile", this.featureType.getName().getLocalPart(), this.featureType.getName().getNamespaceURI()};
        this.title = this.featureType.getName().getLocalPart();
        this.title = this.title.replace('_', ' ');
        this.title = this.title.replace("%20", " ");
        this.title = this.title.trim();
    }

    public CoordinateReferenceSystem getCRS() {
        return this.featureType.getCoordinateReferenceSystem();
    }

    public String getName() {
        return this.featureType.getName().getLocalPart();
    }

    public URI getSchema() {
        try {
            return new URI(this.featureType.getName().getNamespaceURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }
}

