/*
 * Decompiled with CFR 0.152.
 */
package org.tcat.citd.sim.udig.bookmarks.internal.ui;

import java.util.Collection;
import java.util.List;
import net.refractions.udig.aoi.AOIProxy;
import net.refractions.udig.aoi.IAOIService;
import net.refractions.udig.aoi.IAOIStrategy;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.tcat.citd.sim.udig.bookmarks.BookmarkAOIStrategy;
import org.tcat.citd.sim.udig.bookmarks.BookmarkListener;
import org.tcat.citd.sim.udig.bookmarks.BookmarksPlugin;
import org.tcat.citd.sim.udig.bookmarks.IBookmark;
import org.tcat.citd.sim.udig.bookmarks.IBookmarkService;

public class BookmarkAOIPage
extends Page {
    private Composite page;
    private AOIProxy strategy;
    private ComboViewer comboViewer;
    private ISelectionChangedListener comboListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selectedBookmark = (IStructuredSelection)event.getSelection();
            IBookmark selected = (IBookmark)selectedBookmark.getFirstElement();
            IAOIService service = PlatformGIS.getAOIService();
            IAOIStrategy bookmarkStrategy = service.findProxy(BookmarkAOIStrategy.ID).getStrategy();
            if (bookmarkStrategy instanceof BookmarkAOIStrategy) {
                ((BookmarkAOIStrategy)bookmarkStrategy).setCurrentBookmark(selected);
            }
        }
    };
    private BookmarkListener serviceWatcher = new BookmarkListener(){

        @Override
        public void handleEvent(BookmarkListener.Event event) {
            PlatformGIS.asyncInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    IBookmark currentBookmark = BookmarkAOIPage.this.getSelected();
                    Collection<IBookmark> bookmarks = BookmarksPlugin.getBookmarkService().getBookmarks();
                    BookmarkAOIPage.this.comboViewer.setInput(bookmarks);
                    if (bookmarks.contains(currentBookmark)) {
                        BookmarkAOIPage.this.setSelected(currentBookmark);
                    } else {
                        BookmarkAOIPage.this.setSelected(null);
                    }
                }
            }, (boolean)true);
        }
    };

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        IAOIService service = PlatformGIS.getAOIService();
        this.strategy = service.findProxy(BookmarkAOIStrategy.ID);
    }

    protected BookmarkAOIStrategy getStrategy() {
        if (this.strategy == null) {
            return null;
        }
        return (BookmarkAOIStrategy)this.strategy.getStrategy();
    }

    public void createControl(Composite parent) {
        this.page = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.page.setLayout((Layout)layout);
        Label label = new Label(this.page, 16384);
        label.setText("Bookmarks ");
        label.pack();
        IBookmarkService bookmarkService = BookmarksPlugin.getBookmarkService();
        this.listenService(true);
        this.comboViewer = new ComboViewer(this.page, 8);
        this.comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBookmark) {
                    IBookmark bookmark = (IBookmark)element;
                    return bookmark.getName();
                }
                return super.getText(element);
            }
        });
        List bookmarks = (List)bookmarkService.getBookmarks();
        this.comboViewer.setInput((Object)bookmarks);
        this.comboViewer.addSelectionChangedListener(this.comboListener);
    }

    private void setSelected(IBookmark selected) {
        boolean disposed = this.comboViewer.getControl().isDisposed();
        if (this.comboViewer == null || disposed) {
            this.listenService(false);
            return;
        }
        IBookmark current = this.getSelected();
        if (current != selected) {
            this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)selected), true);
        }
    }

    private IBookmark getSelected() {
        if (this.comboViewer.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)this.comboViewer.getSelection();
            return (IBookmark)selection.getFirstElement();
        }
        return null;
    }

    protected void listenService(boolean listen) {
        IBookmarkService bookmarkService = BookmarksPlugin.getBookmarkService();
        if (listen) {
            bookmarkService.addListener(this.serviceWatcher);
        } else {
            bookmarkService.removeListener(this.serviceWatcher);
        }
    }

    public Composite getControl() {
        return this.page;
    }

    public void setFocus() {
        if (this.page != null && !this.page.isDisposed()) {
            this.page.setFocus();
        }
    }

    public void dispose() {
        if (this.strategy != null) {
            this.strategy = null;
        }
        super.dispose();
    }
}

