/*
 * Decompiled with CFR 0.152.
 */
package org.tcat.citd.sim.udig.bookmarks.internal.command;

import com.vividsolutions.jts.geom.Envelope;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.command.navigation.AbstractNavCommand;
import net.refractions.udig.project.render.IViewportModel;
import net.refractions.udig.project.ui.ApplicationGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.tcat.citd.sim.udig.bookmarks.Bookmark;

public class GotoBookmarkCommand
extends AbstractNavCommand {
    private Bookmark target;

    public GotoBookmarkCommand(Bookmark target) {
        this.target = target;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        ReferencedEnvelope bookmarkedEnvelopeInVieportCRS;
        URI mapID = this.target.getMap().getMapID();
        IMap map = (IMap)ProjectPlugin.getPlugin().getProjectRegistry().eResource().getResourceSet().getResource(mapID, true).getContents().get(0);
        ApplicationGIS.openMap((IMap)map);
        IViewportModel v = map.getViewportModel();
        ReferencedEnvelope bookmarkEnvelope = this.target.getEnvelope();
        ReferencedEnvelope viewportBounds = v.getBounds();
        CoordinateReferenceSystem viewportCrs = v.getCRS();
        CoordinateReferenceSystem bookmarkCrs = bookmarkEnvelope.getCoordinateReferenceSystem();
        if (bookmarkCrs.equals(viewportCrs)) {
            bookmarkedEnvelopeInVieportCRS = bookmarkEnvelope;
        } else {
            boolean lenient = true;
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)bookmarkCrs, (CoordinateReferenceSystem)viewportCrs, (boolean)lenient);
            Envelope xformedEnvelope = JTS.transform((Envelope)bookmarkEnvelope, (MathTransform)transform);
            bookmarkedEnvelopeInVieportCRS = new ReferencedEnvelope(xformedEnvelope, viewportCrs);
        }
        if (!bookmarkedEnvelopeInVieportCRS.equals((Object)viewportBounds)) {
            this.model.zoomToBox((Envelope)bookmarkedEnvelopeInVieportCRS);
        }
    }

    public Command copy() {
        return null;
    }

    public String getName() {
        return null;
    }
}

