/*
 * Decompiled with CFR 0.152.
 */
package org.tcat.citd.sim.udig.bookmarks.internal;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.tcat.citd.sim.udig.bookmarks.Bookmark;
import org.tcat.citd.sim.udig.bookmarks.BookmarksPlugin;
import org.tcat.citd.sim.udig.bookmarks.IBookmark;
import org.tcat.citd.sim.udig.bookmarks.IBookmarkService;
import org.tcat.citd.sim.udig.bookmarks.internal.BookmarkServiceImpl;
import org.tcat.citd.sim.udig.bookmarks.internal.MapReference;
import org.tcat.citd.sim.udig.bookmarks.internal.ProjectWrapper;

public class BookmarksLabelProvider
extends LabelProvider {
    private HashMap<Class, Image> table;

    public BookmarksLabelProvider() {
        try {
            this.table = new HashMap(4);
            Image image = BookmarksPlugin.getDefault().getImageDescriptor("icons/obj16/bookmark_obj.gif").createImage();
            this.table.put(Bookmark.class, image);
            image = BookmarksPlugin.getDefault().getImageDescriptor("icons/obj16/fldr_obj.gif").createImage();
            this.table.put(MapReference.class, image);
            image = BookmarksPlugin.getDefault().getImageDescriptor("icons/obj16/fldr_obj.gif").createImage();
            this.table.put(ProjectWrapper.class, image);
            image = BookmarksPlugin.getDefault().getImageDescriptor("icons/obj16/bookmarkmanager_obj.gif").createImage();
            this.table.put(IBookmarkService.class, image);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        Collection<Image> images = this.table.values();
        this.table.clear();
        for (Image img : images) {
            img.dispose();
        }
    }

    public String getText(Object obj) {
        String name;
        if (obj instanceof IBookmarkService) {
            BookmarkServiceImpl bManager = (BookmarkServiceImpl)obj;
            name = bManager.getName();
        } else if (obj instanceof Bookmark) {
            IBookmark bookmark = (IBookmark)obj;
            name = bookmark.getName();
        } else if (obj instanceof ProjectWrapper) {
            ProjectWrapper project = (ProjectWrapper)obj;
            name = project.getName();
        } else if (obj instanceof MapReference) {
            MapReference map = (MapReference)obj;
            name = map.getName();
        } else {
            name = obj.toString();
        }
        return name;
    }

    public Image getImage(Object obj) {
        Class<?> theClass = obj.getClass();
        Image image = this.table.get(theClass);
        return image;
    }
}

