/*
 * Decompiled with CFR 0.152.
 */
package org.tcat.citd.sim.udig.bookmarks.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.internal.Project;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.prefs.BackingStoreException;
import org.tcat.citd.sim.udig.bookmarks.Bookmark;
import org.tcat.citd.sim.udig.bookmarks.BookmarkListener;
import org.tcat.citd.sim.udig.bookmarks.BookmarksPlugin;
import org.tcat.citd.sim.udig.bookmarks.IBookmark;
import org.tcat.citd.sim.udig.bookmarks.IBookmarkService;
import org.tcat.citd.sim.udig.bookmarks.internal.MapReference;
import org.tcat.citd.sim.udig.bookmarks.internal.Messages;

public class BookmarkServiceImpl
implements IBookmarkService {
    private HashMap<URI, Vector<MapReference>> projectsHash;
    private HashMap<URI, Vector<Bookmark>> mapsHash;
    private HashMap<URI, MapReference> mapReferences;
    private int count = 0;
    protected Set<BookmarkListener> listeners = new CopyOnWriteArraySet<BookmarkListener>();

    public BookmarkServiceImpl() {
        this.projectsHash = new HashMap();
        this.mapsHash = new HashMap();
        this.mapReferences = new HashMap();
    }

    @Override
    public void addBookmark(Bookmark bookmark) {
        this.load(bookmark);
        try {
            BookmarksPlugin.getDefault().storeToPreferences();
        }
        catch (BackingStoreException backingStoreException) {
            ILog log = BookmarksPlugin.getDefault().getLog();
            Status status = new Status(2, BookmarksPlugin.ID, "Unable to save to BookmarksPlugin");
            log.log((IStatus)status);
        }
        CopyOnWriteArraySet<IBookmark> bookmarks = new CopyOnWriteArraySet<IBookmark>();
        this.notifyListeners(new BookmarkListener.Event(bookmarks));
    }

    @Override
    public void load(Bookmark bookmark) {
        Vector<Object> projectMaps;
        MapReference map;
        URI project;
        if (bookmark.getName() == null || bookmark.getName() == "") {
            bookmark.setName(String.valueOf(Messages.BookmarkManager_bookmarkdefaultname) + ++this.count);
        }
        if (!this.projectsHash.containsKey(project = (map = bookmark.getMap()).getProjectID())) {
            projectMaps = new Vector<MapReference>();
            projectMaps.add(map);
            this.projectsHash.put(project, projectMaps);
        } else {
            projectMaps = this.projectsHash.get(project);
            if (!projectMaps.contains(map)) {
                projectMaps.add(map);
            }
        }
        if (!this.mapsHash.containsKey(map.getMapID())) {
            Vector<Bookmark> bookmarks = new Vector<Bookmark>();
            bookmarks.add(bookmark);
            this.mapsHash.put(map.getMapID(), bookmarks);
        } else {
            Vector<Bookmark> bmarks = this.mapsHash.get(map.getMapID());
            if (!bmarks.contains(bookmark)) {
                bmarks.add(bookmark);
            }
        }
    }

    @Override
    public void empty() {
        this.projectsHash.clear();
        this.mapsHash.clear();
        this.notifyListeners(new BookmarkListener.Event(null));
    }

    @Override
    public boolean isEmpty() {
        boolean isEmpty = this.mapsHash.isEmpty();
        return isEmpty;
    }

    @Override
    public Collection<URI> getProjects() {
        Vector<URI> projects = new Vector<URI>(this.projectsHash.keySet());
        return projects;
    }

    @Override
    public Collection<MapReference> getMaps(URI project) {
        Vector<MapReference> maps = this.projectsHash.get(project);
        return maps;
    }

    @Override
    public Collection<Bookmark> getBookmarks(MapReference map) {
        if (!this.mapsHash.containsKey(map.getMapID())) {
            this.mapsHash.put(map.getMapID(), new Vector());
        }
        Vector<Bookmark> bookmarks = this.mapsHash.get(map.getMapID());
        return bookmarks;
    }

    @Override
    public Collection<IBookmark> getBookmarks() {
        Vector<IBookmark> bookmarks = new Vector<IBookmark>();
        for (URI project : this.getProjects()) {
            for (MapReference map : this.getMaps(project)) {
                for (IBookmark iBookmark : this.getBookmarks(map)) {
                    if (bookmarks.contains(iBookmark)) continue;
                    bookmarks.add(iBookmark);
                }
            }
        }
        return bookmarks;
    }

    @Override
    public String getName() {
        return Messages.BookmarkManager_name_bookmarkmanager;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void removeBookmark(Bookmark bookmark) {
        MapReference map = bookmark.getMap();
        this.mapsHash.get(map.getMapID()).remove(bookmark);
        if (this.mapsHash.get(map.getMapID()).isEmpty()) {
            URI projectID = map.getProjectID();
            this.mapsHash.remove(map.getMapID());
            this.projectsHash.get(projectID).remove(map);
            if (this.projectsHash.get(projectID).isEmpty()) {
                this.projectsHash.remove(projectID);
            }
        }
        CopyOnWriteArraySet<IBookmark> bookmarks = new CopyOnWriteArraySet<IBookmark>();
        this.notifyListeners(new BookmarkListener.Event(bookmarks));
    }

    @Override
    public void removeBookmarks(Collection<IBookmark> elements) {
        for (IBookmark element : elements) {
            if (!(element instanceof Bookmark)) continue;
            Bookmark bmark = (Bookmark)element;
            this.removeBookmark(bmark);
        }
        this.notifyListeners(new BookmarkListener.Event(elements));
    }

    @Override
    public void removeMap(MapReference map) {
        this.mapsHash.remove(map.getMapID());
        URI projectID = map.getProjectID();
        Vector<MapReference> maps = this.projectsHash.get(projectID);
        if (maps != null && maps.size() > 0) {
            maps.remove(map);
            if (maps.isEmpty()) {
                this.projectsHash.remove(projectID);
            }
        }
        this.notifyListeners(new BookmarkListener.Event(null));
    }

    @Override
    public void removeMaps(Collection<MapReference> elements) {
        for (MapReference element : elements) {
            if (!(element instanceof MapReference)) continue;
            MapReference map = element;
            this.removeMap(map);
        }
        this.notifyListeners(new BookmarkListener.Event(null));
    }

    @Override
    public void removeProject(URI project) {
        Vector<MapReference> maps = this.projectsHash.get(project);
        this.projectsHash.remove(project);
        for (MapReference map : maps) {
            maps.remove(map);
        }
        this.notifyListeners(new BookmarkListener.Event(null));
    }

    @Override
    public void removeProjects(Collection<URI> elements) {
        for (URI element : elements) {
            if (!(element instanceof URI)) continue;
            URI project = element;
            this.removeProject(project);
        }
        this.notifyListeners(new BookmarkListener.Event(null));
    }

    @Override
    public MapReference getMapReference(IMap map) {
        MapReference ref = null;
        if (!this.mapReferences.containsKey(map.getID())) {
            Project project = (Project)map.getProject();
            if (project != null) {
                URI projectURI = project.eResource().getURI();
                ref = new MapReference(map.getID(), projectURI, map.getName());
                this.mapReferences.put(map.getID(), ref);
            }
        } else {
            ref = this.mapReferences.get(map.getID());
        }
        return ref;
    }

    @Override
    public void addListener(BookmarkListener listener) {
        if (listener == null) {
            throw new NullPointerException("BookmarkService listener required to be non null");
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(BookmarkListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private void notifyListeners(BookmarkListener.Event event) {
        if (event == null) {
            event = new BookmarkListener.Event(this.getBookmarks());
        }
        for (BookmarkListener listener : this.listeners) {
            try {
                if (listener == null) continue;
                listener.handleEvent(event);
            }
            catch (Exception e) {
                UiPlugin.log(this.getClass(), (String)"notifyListeners", (Throwable)e);
            }
        }
    }
}

