/*
 * Decompiled with CFR 0.152.
 */
package org.tcat.citd.sim.udig.bookmarks;

import com.vividsolutions.jts.geom.Envelope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.tcat.citd.sim.udig.bookmarks.Bookmark;
import org.tcat.citd.sim.udig.bookmarks.IBookmark;
import org.tcat.citd.sim.udig.bookmarks.IBookmarkService;
import org.tcat.citd.sim.udig.bookmarks.internal.MapReference;

public class BookmarksPlugin
extends AbstractUIPlugin {
    public static String ID = "org.tcat.citd.sim.udig.bookmarks";
    private static final String KEY_NAME = "name";
    private static final String KEY_MINX = "minx";
    private static final String KEY_MINY = "miny";
    private static final String KEY_MAXX = "maxx";
    private static final String KEY_MAXY = "maxy";
    private static final String KEY_CRS = "crs";
    private static BookmarksPlugin plugin;

    public BookmarksPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.restoreFromPreferences();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static BookmarksPlugin getDefault() {
        return plugin;
    }

    public ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)plugin.getBundle().getSymbolicName(), (String)path);
    }

    public void restoreFromPreferences() throws BackingStoreException {
        IPreferencesService prefs = Platform.getPreferencesService();
        IEclipsePreferences root = prefs.getRootNode();
        Preferences node = root.node("instance").node(String.valueOf(this.getBundle().getSymbolicName()) + ".bookmarks");
        String[] stringArray = node.childrenNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String projectId = stringArray[n2];
            URI projectURI = URI.createURI((String)URI.decode((String)projectId));
            Preferences projectNode = node.node(projectId);
            String[] stringArray2 = projectNode.childrenNames();
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String mapId = stringArray2[n4];
                URI mapURI = URI.createURI((String)URI.decode((String)mapId));
                Preferences mapNode = projectNode.node(mapId);
                String mapName = mapNode.get(KEY_NAME, null);
                String[] stringArray3 = mapNode.childrenNames();
                int n5 = stringArray3.length;
                int n6 = 0;
                while (n6 < n5) {
                    CoordinateReferenceSystem crs;
                    String bmarkName = stringArray3[n6];
                    Preferences bmarkNode = mapNode.node(bmarkName);
                    double minx = bmarkNode.getDouble(KEY_MINX, 0.0);
                    double miny = bmarkNode.getDouble(KEY_MINY, 0.0);
                    double maxx = bmarkNode.getDouble(KEY_MAXX, 0.0);
                    double maxy = bmarkNode.getDouble(KEY_MAXY, 0.0);
                    Envelope env = new Envelope(minx, maxx, miny, maxy);
                    String crsString = bmarkNode.get(KEY_CRS, "");
                    try {
                        crs = CRS.parseWKT((String)crsString);
                    }
                    catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                        crs = DefaultGeographicCRS.WGS84;
                    }
                    catch (FactoryException factoryException) {
                        crs = DefaultGeographicCRS.WGS84;
                    }
                    ReferencedEnvelope bounds = new ReferencedEnvelope(env, crs);
                    Bookmark bmark = new Bookmark(bounds, new MapReference(mapURI, projectURI, mapName), URI.decode((String)bmarkName));
                    BookmarksPlugin.getBookmarkService().load(bmark);
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void storeToPreferences() throws BackingStoreException {
        IBookmarkService mgr = BookmarksPlugin.getBookmarkService();
        if (mgr == null) {
            return;
        }
        IPreferencesService prefs = Platform.getPreferencesService();
        IEclipsePreferences root = prefs.getRootNode();
        Preferences node = root.node("instance").node(String.valueOf(this.getBundle().getSymbolicName()) + ".bookmarks");
        this.clearPreferences(node);
        for (URI project : mgr.getProjects()) {
            String projectString = project.toString();
            String encPStr = URI.encodeSegment((String)projectString, (boolean)true);
            Preferences projectNode = node.node(encPStr);
            for (MapReference map : mgr.getMaps(project)) {
                Preferences mapNode = projectNode.node(URI.encodeSegment((String)map.getMapID().toString(), (boolean)true));
                mapNode.put(KEY_NAME, map.getName());
                for (IBookmark iBookmark : mgr.getBookmarks(map)) {
                    Preferences bmarkNode = mapNode.node(URI.encodeSegment((String)iBookmark.getName(), (boolean)true));
                    ReferencedEnvelope bounds = iBookmark.getEnvelope();
                    bmarkNode.putDouble(KEY_MINX, bounds.getMinX());
                    bmarkNode.putDouble(KEY_MINY, bounds.getMinY());
                    bmarkNode.putDouble(KEY_MAXX, bounds.getMaxX());
                    bmarkNode.putDouble(KEY_MAXY, bounds.getMaxY());
                    bmarkNode.put(KEY_CRS, bounds.getCoordinateReferenceSystem().toWKT());
                }
                mapNode.flush();
            }
            projectNode.flush();
        }
        node.flush();
    }

    private void clearPreferences(Preferences node) throws BackingStoreException {
        String[] stringArray = node.childrenNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Preferences child = node.node(name);
            child.removeNode();
            ++n2;
        }
    }

    public static IBookmarkService getBookmarkService() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IBookmarkService bookmarkService = (IBookmarkService)workbench.getService(IBookmarkService.class);
        return bookmarkService;
    }
}

