/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.geotools.process;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveManager;
import net.refractions.udig.catalog.geotools.process.LocalProcess;
import net.refractions.udig.catalog.geotools.process.LocalProcessService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.process.ProcessFactory;
import org.opengis.feature.type.Name;
import org.opengis.util.InternationalString;

public class LocalProcessFolder
implements IResolve {
    private ProcessFactory factory;
    private LocalProcessService service;
    private volatile List<IResolve> members;
    private ID id;

    LocalProcessFolder(LocalProcessService service, ProcessFactory factory) {
        this.service = service;
        this.factory = factory;
        this.id = new ID(service.getID() + "/" + factory.getClass().getSimpleName(), "local");
    }

    public ProcessFactory getFactory() {
        return this.factory;
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (adaptee == null) {
            throw new NullPointerException("No adaptor specified");
        }
        if (adaptee.isInstance(this.factory)) {
            return adaptee.cast(this.factory);
        }
        IResolveManager rm = CatalogPlugin.getDefault().getResolveManager();
        if (rm.canResolve((IResolve)this, adaptee)) {
            return (T)rm.resolve((IResolve)this, adaptee, monitor);
        }
        return null;
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isInstance(this.factory) || CatalogPlugin.getDefault().getResolveManager().canResolve((IResolve)this, adaptee);
    }

    public LocalProcessService parent(IProgressMonitor monitor) throws IOException {
        return this.service;
    }

    public synchronized List<IResolve> members(IProgressMonitor monitor) throws IOException {
        if (this.members == null) {
            this.members = new ArrayList<IResolve>();
            for (Name name : this.factory.getNames()) {
                LocalProcess member = new LocalProcess(this, name);
                this.members.add((IResolve)member);
            }
        }
        return this.members;
    }

    public IResolve.Status getStatus() {
        if (this.factory == null) {
            return IResolve.Status.NOTCONNECTED;
        }
        if (this.factory.isAvailable()) {
            return IResolve.Status.CONNECTED;
        }
        return IResolve.Status.BROKEN;
    }

    public Throwable getMessage() {
        if (this.factory == null) {
            return new IllegalStateException("Factory registered, but not available");
        }
        if (this.factory.isAvailable()) {
            return null;
        }
        return new IllegalStateException(String.valueOf(this.factory.getClass().getName()) + " not avaialble");
    }

    public URL getIdentifier() {
        return this.getID().toURL();
    }

    public ID getID() {
        return this.id;
    }

    public String getTitle() {
        String text;
        if (this.factory == null) {
            return "Unavailable";
        }
        InternationalString title = this.factory.getTitle();
        String string = text = title == null ? null : title.toString();
        if (text == null) {
            return this.factory.getClass().getSimpleName();
        }
        return text;
    }

    public void dispose(IProgressMonitor monitor) {
    }
}

